/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions;

import com.neptunelabs.fsiframework.helpers.StringUtils;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiserver.fsiadministrator.actions.FormHelpers;
import com.neptunelabs.fsiserver.fsiadministrator.actions.RendererAction;
import com.neptunelabs.fsiserver.requestprocessor.settings.Renderer;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;

public class EditRendererAction
extends RendererAction {
    public EditRendererAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/editrenderer.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else if (parameters.get("renderername") != null) {
            templateData.put("available_formats", FormHelpers.getAvailableOutputFormats());
            String renderername = parameters.get("renderername") instanceof String ? (String)parameters.get("renderername") : ((String[])parameters.get("renderername"))[0];
            if (parameters.get("confirmed") != null && parameters.get("confirmed").equals("1")) {
                for (Map.Entry<String, Object> e : parameters.entrySet()) {
                    templateData.put(e.getKey(), e.getValue());
                }
                try {
                    Document doc = FormHelpers.buildRendererDocument(parameters);
                    Path rendererFile = this.requestProcessorSettings.getRendererDirectory().resolve(renderername + ".xml");
                    FileOperations.saveXMLFileContent(this.sourceManagerLogger, rendererFile, doc);
                    templateData.put("show_confirmation", true);
                }
                catch (ParserConfigurationException e) {
                    templateData.put("message", (Object)"Error saving renderer.");
                    templateData.put("show_form", true);
                }
                catch (NumberFormatException e) {
                    templateData.put("message", (Object)"Invalid quality value.");
                    templateData.put("show_form", true);
                    status = 200;
                }
                status = 200;
            } else {
                String listRenderer;
                String infoRenderer;
                String dirImageRenderer;
                String imageRenderer;
                Renderer renderer = this.requestProcessorSettings.getRenderer(renderername);
                templateData.put("renderername", parameters.get("renderername"));
                templateData.put("enabled", (Object)Boolean.toString(renderer.isEnabled()));
                String string = imageRenderer = renderer.getImageRenderer() != null ? renderer.getImageRenderer().getClass().getName() : "com.neptunelabs.fsiserver.requestprocessor.renderers.StandardImageRenderer";
                if (!imageRenderer.equals("com.neptunelabs.fsiserver.requestprocessor.renderers.StandardImageRenderer")) {
                    templateData.put("img_rend_impl", (Object)imageRenderer);
                }
                SimpleHash imageRendererOptions = new SimpleHash();
                Set<String> imgRendOptionNames = renderer.getImageRenderer().getSupportedOptions();
                for (String optionname : imgRendOptionNames) {
                    imageRendererOptions.put(optionname, (Object)renderer.getImageRenderer().getOption(optionname));
                }
                Set<String> irag = renderer.getImageRenderer().getAllowedGroups();
                imageRendererOptions.put("allowedgroups", (Object)StringUtils.join(irag, ','));
                templateData.put("imagerendereroptions", (Object)imageRendererOptions);
                String string2 = dirImageRenderer = renderer.getDirectoryImageRenderer() != null ? renderer.getDirectoryImageRenderer().getClass().getName() : "com.neptunelabs.fsiserver.requestprocessor.renderers.StandardDirectoryImageRenderer";
                if (!dirImageRenderer.equals("com.neptunelabs.fsiserver.requestprocessor.renderers.StandardDirectoryImageRenderer")) {
                    templateData.put("dirimg_rend_impl", (Object)dirImageRenderer);
                }
                SimpleHash dirImageRendererOptions = new SimpleHash();
                Set<String> dirImgRendOptionNames = renderer.getImageRenderer().getSupportedOptions();
                for (String optionname : dirImgRendOptionNames) {
                    dirImageRendererOptions.put(optionname, (Object)renderer.getDirectoryImageRenderer().getOption(optionname));
                }
                Set<String> dirag = renderer.getImageRenderer().getAllowedGroups();
                dirImageRendererOptions.put("allowedgroups", (Object)StringUtils.join(dirag, ','));
                templateData.put("dirimagerendereroptions", (Object)dirImageRendererOptions);
                String string3 = infoRenderer = renderer.getInfoRenderer() != null ? renderer.getInfoRenderer().getClass().getName() : "com.neptunelabs.fsiserver.requestprocessor.renderers.StandardInfoRenderer";
                if (!infoRenderer.equals("com.neptunelabs.fsiserver.requestprocessor.renderers.StandardInfoRenderer")) {
                    templateData.put("inf_rend_impl", (Object)infoRenderer);
                }
                SimpleHash infoRendererOptions = new SimpleHash();
                Set<String> infRendOptionnames = renderer.getInfoRenderer().getSupportedOptions();
                for (String optionname : infRendOptionnames) {
                    infoRendererOptions.put(optionname, (Object)renderer.getInfoRenderer().getOption(optionname));
                }
                Set<String> infoRag = renderer.getImageRenderer().getAllowedGroups();
                infoRendererOptions.put("allowedgroups", (Object)StringUtils.join(infoRag, ','));
                templateData.put("inforendereroptions", (Object)infoRendererOptions);
                String string4 = listRenderer = renderer.getListRenderer() != null ? renderer.getListRenderer().getClass().getName() : "com.neptunelabs.fsiserver.requestprocessor.renderers.StandardListRenderer";
                if (!listRenderer.equals("com.neptunelabs.fsiserver.requestprocessor.renderers.StandardListRenderer")) {
                    templateData.put("lst_rend_impl", (Object)listRenderer);
                }
                SimpleHash listRendererOptions = new SimpleHash();
                Set<String> listRendOptionnames = renderer.getListRenderer().getSupportedOptions();
                for (String optionname : listRendOptionnames) {
                    listRendererOptions.put(optionname, (Object)renderer.getListRenderer().getOption(optionname));
                }
                Set<String> listRag = renderer.getImageRenderer().getAllowedGroups();
                listRendererOptions.put("allowedgroups", (Object)StringUtils.join(listRag, ','));
                templateData.put("listrendereroptions", (Object)listRendererOptions);
                List<String> effects = renderer.getOutputEffects();
                String effectsStr = "";
                for (int i = 0; i < effects.size(); ++i) {
                    effectsStr = effectsStr.concat(effects.get(i));
                    if (i == effects.size() - 1) continue;
                    effectsStr = effectsStr.concat(";");
                }
                templateData.put("effects", (Object)effectsStr);
                templateData.put("format", (Object)renderer.getOutputFormat());
                this.outputParametersToTemplate(renderer.getOutputParameters(), templateData);
                templateData.put("show_form", true);
            }
            status = 200;
        }
        return status;
    }
}

