/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions;

import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import com.neptunelabs.fsiserver.fsiadministrator.actions.FormHelpers;
import com.neptunelabs.fsiserver.utils.SourceConnector;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.io.File;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXB;

public class EditSourceConnectorAction
extends Action {
    public EditSourceConnectorAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/editsourceconnector.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else if (parameters.get("connectorname") != null) {
            templateData.put("available_formats", FormHelpers.getAvailableFormats());
            templateData.put("available_types", FormHelpers.getAvailableSourceConnectorTypes());
            templateData.put("available_levelqualities", FormHelpers.getAvailableLevelQualities());
            String connectorname = (String)parameters.get("connectorname");
            SourceConnectorReader connector = this.sourceManagerSettings.getAllConnectors().get(connectorname);
            SourceConnector rawsc = connector.getSourceConnectorDefinition();
            if (parameters.get("confirmed") != null && parameters.get("confirmed").equals("1")) {
                for (Map.Entry<String, Object> e : parameters.entrySet()) {
                    templateData.put(e.getKey(), e.getValue());
                }
                try {
                    rawsc.enabled = Boolean.valueOf((String)parameters.get("enabled"));
                    rawsc.origin.location = (String)parameters.get("location");
                    rawsc.copyrightnotice = (String)parameters.get("copyrightnotice");
                    rawsc.conversion.format = (String)parameters.get("format");
                    rawsc.conversion.quality = Integer.valueOf((String)parameters.get("quality"));
                    rawsc.conversion.levelquality = (String)parameters.get("levelquality");
                    rawsc.conversion.chromasubsampling = (String)parameters.get("chromasubsampling");
                    rawsc.conversion.histogram = Boolean.valueOf((String)parameters.get("histogram"));
                    rawsc.comment = (String)parameters.get("comment");
                    rawsc.type = (String)parameters.get("type");
                    PathCached targetFile = connector.getSourceConnectorFile();
                    JAXB.marshal((Object)rawsc, (File)targetFile.toFile());
                    templateData.put("show_confirmation", true);
                }
                catch (NumberFormatException e) {
                    templateData.put("message", (Object)"Invalid quality value.");
                    templateData.put("show_form", true);
                }
                catch (DataBindingException ioe) {
                    templateData.put("message", (Object)("Error saving renderer: " + ioe.getLocalizedMessage()));
                    templateData.put("show_form", true);
                }
            } else {
                templateData.put("connectorname", (Object)connectorname);
                templateData.put("enabled", (Object)String.valueOf(rawsc.enabled));
                templateData.put("type", (Object)rawsc.type);
                templateData.put("currentlyEnabled", (Object)String.valueOf(connector.isEnabled()));
                templateData.put("location", (Object)rawsc.origin.location);
                templateData.put("copyrightnotice", (Object)rawsc.copyrightnotice);
                templateData.put("format", (Object)rawsc.conversion.format);
                templateData.put("quality", (Object)rawsc.conversion.quality);
                templateData.put("levelquality", (Object)rawsc.conversion.levelquality.toUpperCase());
                templateData.put("available_chromasubsamplings", FormHelpers.getAvailableChromasubsamplings());
                templateData.put("chromasubsampling", (Object)rawsc.conversion.chromasubsampling);
                templateData.put("histogram", rawsc.conversion.histogram);
                templateData.put("comment", (Object)rawsc.comment);
                templateData.put("show_form", true);
            }
            status = 200;
        }
        return status;
    }
}

