/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions;

import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.OutputFormat;
import com.neptunelabs.fsiserver.requestprocessor.settings.OutputParameters;
import com.neptunelabs.fsiserver.sourcemanager.storage.utils.TileCompression;
import com.neptunelabs.fsiserver.utils.SourceConnector;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.imagemanipulator.encoder.ImageEncoderUtils;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleSequence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

final class FormHelpers {
    FormHelpers() {
    }

    static SimpleSequence getUserListFromAuthenticationInterface(UserAuthenticationInterface uai) {
        SimpleSequence result = new SimpleSequence();
        Set<String> userset = uai.getUsers();
        ArrayList<String> userlist = new ArrayList<String>();
        userlist.addAll(userset);
        Collections.sort(userlist);
        for (String user : userlist) {
            SimpleHash entry = new SimpleHash();
            entry.put("value", (Object)user);
            entry.put("description", (Object)user);
            result.add((Object)entry);
        }
        return result;
    }

    static List<Map<String, Object>> getServerTokens() {
        ArrayList<Map<String, Object>> availables = new ArrayList<Map<String, Object>>();
        HashMap<String, String> entry1 = new HashMap<String, String>();
        entry1.put("value", "full");
        entry1.put("description", "Full");
        availables.add(entry1);
        HashMap<String, String> entry2 = new HashMap<String, String>();
        entry2.put("value", "prod");
        entry2.put("description", "Production");
        availables.add(entry2);
        HashMap<String, String> entry3 = new HashMap<String, String>();
        entry3.put("value", "debug");
        entry3.put("description", "Debug");
        availables.add(entry3);
        HashMap<String, String> entry4 = new HashMap<String, String>();
        entry4.put("value", "none");
        entry4.put("description", "None");
        availables.add(entry4);
        return availables;
    }

    static List<Map<String, Object>> getAvailableSourceConnectorTypes() {
        ArrayList<Map<String, Object>> availables = new ArrayList<Map<String, Object>>();
        HashMap<String, String> entry1 = new HashMap<String, String>();
        entry1.put("value", "storage");
        entry1.put("description", "Storage");
        availables.add(entry1);
        HashMap<String, String> entry2 = new HashMap<String, String>();
        entry2.put("value", "static");
        entry2.put("description", "Static");
        availables.add(entry2);
        HashMap<String, String> entry3 = new HashMap<String, String>();
        entry3.put("value", "multiresolution");
        entry3.put("description", "Multiresolution");
        availables.add(entry3);
        return availables;
    }

    static List<Map<String, Object>> getServerByteOrder() {
        ArrayList<Map<String, Object>> availables = new ArrayList<Map<String, Object>>();
        HashMap<String, String> entry1 = new HashMap<String, String>();
        entry1.put("value", "little_endian");
        entry1.put("description", "Little Endian");
        availables.add(entry1);
        HashMap<String, String> entry2 = new HashMap<String, String>();
        entry2.put("value", "big_endian");
        entry2.put("description", "Big Endian");
        availables.add(entry2);
        return availables;
    }

    static List<Map<String, Object>> getAvailableOutputFormats() {
        ArrayList<Map<String, Object>> availables = new ArrayList<Map<String, Object>>();
        for (OutputFormat type : OutputFormat.values()) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("value", type.name());
            entry.put("description", type.name());
            availables.add(entry);
        }
        return availables;
    }

    static List<Map<String, Object>> getAvailableOutputEncodings() {
        ArrayList<Map<String, Object>> availables = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> unset = new HashMap<String, Object>();
        unset.put("value", (Object)OutputParameters.Encoding.UNSET);
        unset.put("description", "default");
        availables.add(unset);
        HashMap<String, Object> image = new HashMap<String, Object>();
        image.put("value", (Object)OutputParameters.Encoding.IMAGE);
        image.put("description", "image");
        availables.add(image);
        HashMap<String, Object> b64 = new HashMap<String, Object>();
        b64.put("value", (Object)OutputParameters.Encoding.BASE64);
        b64.put("description", "base64");
        availables.add(b64);
        return availables;
    }

    static List<Map<String, Object>> getAvailableColorspaces() {
        ArrayList<Map<String, Object>> availables = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> unset = new HashMap<String, Object>();
        unset.put("value", (Object)OutputParameters.Colorspace.UNSET);
        unset.put("description", "default");
        availables.add(unset);
        HashMap<String, Object> gray = new HashMap<String, Object>();
        gray.put("value", (Object)OutputParameters.Colorspace.GRAY);
        gray.put("description", "gray");
        availables.add(gray);
        HashMap<String, Object> rgb = new HashMap<String, Object>();
        rgb.put("value", (Object)OutputParameters.Colorspace.RGB);
        rgb.put("description", "rgb");
        availables.add(rgb);
        return availables;
    }

    static List<Map<String, Object>> getAvailableChromasubsamplings() {
        ArrayList<Map<String, Object>> availables = new ArrayList<Map<String, Object>>();
        HashMap<String, String> cs420 = new HashMap<String, String>();
        cs420.put("value", "4:2:0");
        cs420.put("description", "4:2:0");
        availables.add(cs420);
        HashMap<String, String> cs422 = new HashMap<String, String>();
        cs422.put("value", "4:2:2");
        cs422.put("description", "4:2:2");
        availables.add(cs422);
        HashMap<String, String> cs444 = new HashMap<String, String>();
        cs444.put("value", "4:4:4");
        cs444.put("description", "4:4:4");
        availables.add(cs444);
        return availables;
    }

    static List<Map<String, Object>> getAvailableQuantizer() {
        ArrayList<Map<String, Object>> availables = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> d1 = new HashMap<String, Object>();
        d1.put("value", (Object)ImageEncoderUtils.QuantizerMode.NEUQUANT);
        d1.put("description", "NeuQuant");
        availables.add(d1);
        HashMap<String, Object> d2 = new HashMap<String, Object>();
        d2.put("value", (Object)ImageEncoderUtils.QuantizerMode.OCTREE);
        d2.put("description", "Octree");
        availables.add(d2);
        HashMap<String, Object> d3 = new HashMap<String, Object>();
        d3.put("value", (Object)ImageEncoderUtils.QuantizerMode.WEBSAFE);
        d3.put("description", "WebSafe");
        availables.add(d3);
        return availables;
    }

    static List<Map<String, Object>> getAvailableDitherers() {
        ArrayList<Map<String, Object>> availables = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> d1 = new HashMap<String, Object>();
        d1.put("value", (Object)ImageEncoderUtils.DithererMode.FLOYDSTEINBERG);
        d1.put("description", "Floyd Steinberg");
        availables.add(d1);
        HashMap<String, Object> d2 = new HashMap<String, Object>();
        d2.put("value", (Object)ImageEncoderUtils.DithererMode.NODITHER);
        d2.put("description", "No Dithering");
        availables.add(d2);
        return availables;
    }

    static List<Map<String, Object>> getAvailableCompressionLevels() {
        ArrayList<Map<String, Object>> availables = new ArrayList<Map<String, Object>>();
        HashMap<String, String> defaultLevel = new HashMap<String, String>();
        defaultLevel.put("value", "-1");
        defaultLevel.put("description", "default");
        availables.add(defaultLevel);
        for (int i = 0; i < 10; ++i) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("value", String.valueOf(i));
            entry.put("description", String.valueOf(i));
            availables.add(entry);
        }
        return availables;
    }

    static List<Map<String, Object>> getAvailableCompressionFilters() {
        ArrayList<Map<String, Object>> availables = new ArrayList<Map<String, Object>>();
        HashMap<String, String> defaultFilter = new HashMap<String, String>();
        defaultFilter.put("value", "-1");
        defaultFilter.put("description", "default");
        availables.add(defaultFilter);
        HashMap<String, String> noFilter = new HashMap<String, String>();
        noFilter.put("value", "0");
        noFilter.put("description", "none");
        availables.add(noFilter);
        HashMap<String, String> subFilter = new HashMap<String, String>();
        subFilter.put("value", "1");
        subFilter.put("description", "sub");
        availables.add(subFilter);
        return availables;
    }

    static List<Map<String, Object>> getAvailableFormats() {
        ArrayList<Map<String, Object>> availables = new ArrayList<Map<String, Object>>();
        for (TileCompression type : TileCompression.values()) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("value", type.name());
            entry.put("description", type.name());
            availables.add(entry);
        }
        return availables;
    }

    static List<Map<String, Object>> getAvailableLevelQualities() {
        ArrayList<Map<String, Object>> availables = new ArrayList<Map<String, Object>>();
        for (SourceConnectorReader.LevelQuality q : SourceConnectorReader.LevelQuality.values()) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("value", q.name());
            entry.put("description", q.name());
            availables.add(entry);
        }
        return availables;
    }

    static List<Map<String, Object>> getAvailableLocaleStrings() {
        ArrayList<Map<String, Object>> availables = new ArrayList<Map<String, Object>>();
        for (String language : Locale.getISOLanguages()) {
            Locale locale = new Locale(language);
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("value", language);
            entry.put("description", locale.getDisplayLanguage() + " (" + language + ")");
            availables.add(entry);
        }
        Collections.sort(availables, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> map1, Map<String, Object> map2) {
                return map1.get("description").toString().compareTo(map2.get("description").toString());
            }
        });
        HashMap<String, String> none = new HashMap<String, String>();
        none.put("value", "none");
        none.put("description", "No Language Defined");
        availables.add(0, none);
        HashMap<String, String> auto = new HashMap<String, String>();
        auto.put("value", "auto");
        auto.put("description", "Default Language");
        availables.add(0, auto);
        return availables;
    }

    static SourceConnector buildRawSourceConnector(Map<String, Object> parameters) throws ParserConfigurationException {
        SourceConnector rawsc = new SourceConnector();
        rawsc.enabled = Boolean.valueOf((String)parameters.get("enabled"));
        rawsc.type = (String)parameters.get("type");
        rawsc.type = rawsc.type == null || rawsc.type.trim().length() == 0 ? "storage" : rawsc.type.trim().toLowerCase();
        rawsc.comment = (String)parameters.get("comment");
        if (rawsc.comment != null) {
            rawsc.comment = rawsc.comment.trim();
        }
        rawsc.origin.location = (String)parameters.get("location");
        rawsc.copyrightnotice = (String)parameters.get("copyrightnotice");
        rawsc.conversion.format = (String)parameters.get("format");
        rawsc.conversion.quality = Integer.parseInt((String)parameters.get("quality"));
        rawsc.access = new SourceConnector.AccessType();
        SourceConnector.GroupEntry ge1 = new SourceConnector.GroupEntry();
        ge1.groupname = "public";
        ge1.permissionset = rawsc.type.equals("storage") || rawsc.type.equals("multiresolution") ? "public_images" : "public_statics";
        rawsc.access.groupEntries.add(ge1);
        SourceConnector.GroupEntry ge2 = new SourceConnector.GroupEntry();
        ge2.groupname = ((String)parameters.get("group")).trim();
        ge2.permissionset = ((String)parameters.get("permissionset")).trim();
        rawsc.access.groupEntries.add(ge2);
        return rawsc;
    }

    static Document buildRendererDocument(Map<String, Object> parameters) throws ParserConfigurationException {
        String[] parameterNames;
        Object implementation;
        Object implementation2;
        Element element;
        Object implementation3;
        Element element2;
        Object implementation4;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        DOMImplementation domimpl = builder.getDOMImplementation();
        Document doc = domimpl.createDocument(null, "renderer", null);
        Element rootNode = doc.getDocumentElement();
        Element enabledNode = doc.createElement("enabled");
        boolean enabled = parameters.containsKey("enabled") && Boolean.parseBoolean((String)parameters.get("enabled"));
        enabledNode.appendChild(doc.createTextNode(Boolean.toString(enabled)));
        rootNode.appendChild(enabledNode);
        Element imageRendererNode = doc.createElement("imagerenderer");
        if (parameters.containsKey("img_rend_impl") && parameters.get("img_rend_impl") != null && !((String)(implementation4 = ((String)parameters.get("img_rend_impl")).trim())).equalsIgnoreCase("default") && ((String)implementation4).length() <= 0) {
            Element element3 = doc.createElement("implementation");
            element3.appendChild(doc.createTextNode((String)implementation4));
            imageRendererNode.appendChild(element3);
        }
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String value;
            if (!entry.getKey().startsWith("imagerendereroption.") || entry.getValue() == null || !(entry.getValue() instanceof String) || (value = (String)entry.getValue()).length() <= 0) continue;
            element2 = doc.createElement(entry.getKey().substring("imagerendereroption.".length()));
            element2.appendChild(doc.createTextNode(value));
            imageRendererNode.appendChild(element2);
        }
        rootNode.appendChild(imageRendererNode);
        Element dirImageRendererNode = doc.createElement("directoryimagerenderer");
        if (parameters.containsKey("dirimg_rend_impl") && parameters.get("dirimg_rend_impl") != null && !((String)(implementation3 = ((String)parameters.get("dirimg_rend_impl")).trim())).equalsIgnoreCase("default") && ((String)implementation3).length() <= 0) {
            Element element4 = doc.createElement("implementation");
            element4.appendChild(doc.createTextNode((String)implementation3));
            dirImageRendererNode.appendChild(element4);
        }
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String value;
            if (!entry.getKey().startsWith("dirimagerendereroption.") || entry.getValue() == null || !(entry.getValue() instanceof String) || (value = (String)entry.getValue()).length() <= 0) continue;
            element = doc.createElement(entry.getKey().substring("dirimagerendereroption.".length()));
            element.appendChild(doc.createTextNode(value));
            dirImageRendererNode.appendChild(element);
        }
        rootNode.appendChild(dirImageRendererNode);
        Element infoRendererNode = doc.createElement("inforenderer");
        if (parameters.containsKey("inf_rend_impl") && parameters.get("inf_rend_impl") != null && !((String)(implementation2 = ((String)parameters.get("inf_rend_impl")).trim())).equalsIgnoreCase("default") && ((String)implementation2).length() <= 0) {
            element2 = doc.createElement("implementation");
            element2.appendChild(doc.createTextNode((String)implementation2));
            infoRendererNode.appendChild(element2);
        }
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String value;
            if (!entry.getKey().startsWith("inforendereroption.") || entry.getValue() == null || !(entry.getValue() instanceof String) || (value = (String)entry.getValue()).length() <= 0) continue;
            Element element5 = doc.createElement(entry.getKey().substring("inforendereroption.".length()));
            element5.appendChild(doc.createTextNode(value));
            infoRendererNode.appendChild(element5);
        }
        rootNode.appendChild(infoRendererNode);
        Element listRendererNode = doc.createElement("listrenderer");
        if (parameters.containsKey("lst_rend_impl") && parameters.get("lst_rend_impl") != null && !((String)(implementation = ((String)parameters.get("lst_rend_impl")).trim())).equalsIgnoreCase("default") && ((String)implementation).length() <= 0) {
            element = doc.createElement("implementation");
            element.appendChild(doc.createTextNode((String)implementation));
            listRendererNode.appendChild(element);
        }
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String[] value;
            if (!entry.getKey().startsWith("listrendereroption.") || entry.getValue() == null || !(entry.getValue() instanceof String) || (value = (String[])entry.getValue()).length() <= 0) continue;
            Element element6 = doc.createElement(entry.getKey().substring("listrendereroption.".length()));
            element6.appendChild(doc.createTextNode((String)value));
            listRendererNode.appendChild(element6);
        }
        rootNode.appendChild(listRendererNode);
        if (parameters.containsKey("effect")) {
            String[] effectsStrings;
            Element outputeffectsNode = doc.createElement("outputeffects");
            for (String effect : effectsStrings = ((String)parameters.get("effect")).split(";")) {
                if (effect == null || effect.trim().length() <= 0) continue;
                Element effectNode = doc.createElement("effect");
                effectNode.appendChild(doc.createTextNode(effect));
                outputeffectsNode.appendChild(effectNode);
            }
            rootNode.appendChild(outputeffectsNode);
        }
        Element outputcompressionNode = doc.createElement("output");
        Element formatElement = doc.createElement("format");
        String formatStr = (String)parameters.get("format");
        formatElement.appendChild(doc.createTextNode(formatStr));
        outputcompressionNode.appendChild(formatElement);
        String encoding = (String)parameters.get("encoding");
        if (encoding.equalsIgnoreCase("image") || encoding.equalsIgnoreCase("base64")) {
            Element encodingNode = doc.createElement("encoding");
            encodingNode.appendChild(doc.createTextNode(encoding));
            outputcompressionNode.appendChild(encodingNode);
        }
        for (String parameterName : parameterNames = new String[]{"chromasubsampling", "compressionlevel", "compressionfilter", "backgroundcolor", "ditherer", "quantizer", "quantizersampledepth", "colorspace", "quality", "dpi", "maxcolors", "embedicc", "optimizehuffman", "loop", "framepalette", "encoding"}) {
            String parameterValue = (String)parameters.get(parameterName);
            if (parameterValue == null || parameterValue.length() <= 0 || parameterValue.equals("-1") || parameterValue.equals("default")) continue;
            Element pNode = doc.createElement(parameterName);
            pNode.appendChild(doc.createTextNode(parameterValue));
            outputcompressionNode.appendChild(pNode);
        }
        rootNode.appendChild(outputcompressionNode);
        return doc;
    }
}

