/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions;

import com.neptunelabs.fsiframework.licensing.ApplicationIDMapping;
import com.neptunelabs.fsiframework.licensing.LicenceContainer;
import com.neptunelabs.fsiframework.licensing.LicenceManager;
import com.neptunelabs.fsiframework.licensing.RawLicence;
import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.interfacewebservice.UploadFile;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleSequence;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.servlet.ServletContext;

public class LicenceAction
extends Action {
    public LicenceAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/licence.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else {
            if (parameters.containsKey("installlicence")) {
                Path workDir = this.sourceManagerSettings.getWorkDirectory();
                UploadFile[] fileEntries = files.getEntry();
                Path tmpfile = null;
                for (UploadFile fileEntry : fileEntries) {
                    tmpfile = workDir.resolve(fileEntry.getName() + System.currentTimeMillis());
                    DataHandler dh = fileEntry.getData();
                    try {
                        dh.writeTo(Files.newOutputStream(tmpfile, new OpenOption[0]));
                    }
                    catch (IOException ioe) {
                        this.requestProcessorLogger.logException(ioe, 3157, "Licence upload", ioe.getLocalizedMessage());
                    }
                }
                if (tmpfile != null) {
                    try {
                        LicenceContainer lc = LicenceContainer.getInstance(tmpfile);
                        if (!lc.hasInitializationErrors() && lc.isValid()) {
                            int licencecounter = lc.getRawLicences().size();
                            this.requestProcessorSettings.getLicenceManager().addLicences(lc.getRawLicences());
                            templateData.put("show_install_confirmation", (Object)licencecounter);
                        } else {
                            templateData.put("show_invalid_file_format", true);
                            templateData.put("message", (Object)lc.getErrorMessage());
                        }
                        Files.delete(tmpfile);
                    }
                    catch (IOException e) {
                        this.requestProcessorLogger.logException(e, 3157, "Licence upload", "Failed to delete temp file " + tmpfile);
                    }
                }
            } else if (parameters.containsKey("deletelicence")) {
                if (parameters.containsKey("confirmed")) {
                    try {
                        this.requestProcessorSettings.getLicenceManager().removeLicence(Integer.valueOf((String)parameters.get("appid")), Integer.valueOf((String)parameters.get("version")));
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    templateData.put("show_remove_confirmation", true);
                } else {
                    templateData.put("appid", parameters.get("appid"));
                    templateData.put("version", parameters.get("version"));
                    templateData.put("show_confirm_remove_request", true);
                }
            } else if (parameters.containsKey("licenceform")) {
                templateData.put("show_licence_form", true);
            } else {
                LicenceManager lm = this.requestProcessorSettings.getLicenceManager();
                List<RawLicence> allLicences = lm.getAllLicences();
                SimpleSequence templateLicences = new SimpleSequence();
                for (RawLicence rl : allLicences) {
                    SimpleHash templateLicenceEntry = new SimpleHash();
                    templateLicenceEntry.put("appid", (Object)rl.appid);
                    templateLicenceEntry.put("appname", (Object)ApplicationIDMapping.getInstance().getApplicationName(rl.appid));
                    templateLicenceEntry.put("version", (Object)rl.version);
                    SimpleHash properties = new SimpleHash();
                    if (rl.properties != null) {
                        for (RawLicence.LicenceProperty pl : rl.properties) {
                            properties.put(pl.name, pl.values);
                        }
                    }
                    templateLicenceEntry.put("properties", (Object)properties);
                    templateLicences.add((Object)templateLicenceEntry);
                }
                templateData.put("licences", (Object)templateLicences);
                templateData.put("show_summary", true);
            }
            status = 200;
        }
        return status;
    }
}

