/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import com.neptunelabs.fsiserver.sourcemanager.MainManager;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.utils.ServletUtils;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleSequence;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;

public class ListSkinsAction
extends Action {
    public ListSkinsAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/listskins.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else {
            MainManager importer = (MainManager)this.servletContext.getAttribute("com.neptunelabs.fsiserver.sourcemanager.MainManager");
            SourceManagerSettings settings = importer.getSourceManagerSettings();
            if (parameters.containsKey("user")) {
                String user = ((String)parameters.get("user")).trim();
                templateData.put("user", (Object)user);
                Path userDir = ServletUtils.getRealPath(settings.getServletContext(), "/users").resolve(user);
                Path viewerDir = userDir.resolve("viewer");
                if (Files.exists(viewerDir, new LinkOption[0])) {
                    templateData.put("skins", this.getSkins(viewerDir.resolve("skins")));
                }
            } else if (parameters.containsKey("defaultviewer")) {
                Path viewerDir = ServletUtils.getRealPath(settings.getServletContext(), "/viewer");
                templateData.put("skins", this.getSkins(viewerDir.resolve("skins")));
            } else {
                SimpleSequence existingViewerList = new SimpleSequence();
                Path usersDir = ServletUtils.getRealPath(this.sourceManagerSettings.getServletContext(), "users");
                try {
                    List<PathCached> usersDirList = FileOperations.listDirectories(usersDir);
                    for (PathCached dir : usersDirList) {
                        Path viewerSubDir = dir.getPath().resolve("viewer");
                        if (!Files.exists(viewerSubDir, new LinkOption[0])) continue;
                        SimpleHash entry = new SimpleHash();
                        entry.put("value", (Object)dir.getFileName());
                        entry.put("description", (Object)dir.getFileName());
                        existingViewerList.add((Object)entry);
                    }
                    templateData.put("existing_userviewers", (Object)existingViewerList);
                    templateData.put("show_chooser", true);
                }
                catch (IOException ioe) {
                    templateData.put("show_error", true);
                }
            }
            status = 200;
        }
        return status;
    }

    private Map<String, Map<String, Boolean>> getSkins(Path skinDirectory) {
        if (!Files.exists(skinDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException();
        }
        HashMap<String, Map<String, Boolean>> result = new HashMap<String, Map<String, Boolean>>();
        try {
            List<PathCached> list = FileOperations.listAllFiles(skinDirectory);
            for (PathCached file : list) {
                String name;
                String filename = file.getFileName();
                if (!filename.endsWith(".swf") || filename.equals("dialogs.swf")) continue;
                HashMap<String, Boolean> entry = new HashMap<String, Boolean>();
                if (!filename.startsWith("intro_")) {
                    name = filename.substring(0, filename.lastIndexOf(46));
                    entry.put("viewer", true);
                } else {
                    name = filename.substring(6, filename.lastIndexOf(46));
                    entry.put("intro", true);
                }
                if (result.containsKey(name)) {
                    ((Map)result.get(name)).putAll(entry);
                    continue;
                }
                result.put(name, entry);
            }
        }
        catch (IOException list) {
            // empty catch block
        }
        try {
            Path pagesSkinDirectory = skinDirectory.resolve("pages");
            List<PathCached> pagesList = FileOperations.listAllFiles(pagesSkinDirectory);
            for (PathCached file : pagesList) {
                String filename = file.getFileName();
                if (!filename.endsWith(".swf")) continue;
                HashMap<String, Boolean> entry = new HashMap<String, Boolean>();
                String name = filename.substring(0, filename.lastIndexOf(46));
                entry.put("pages", true);
                if (result.containsKey(name)) {
                    ((Map)result.get(name)).putAll(entry);
                    continue;
                }
                result.put(name, entry);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

