/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions;

import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import com.neptunelabs.fsiserver.sourcemanager.MainManager;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.util.Map;
import javax.servlet.ServletContext;

public class ListSourceConnectorsAction
extends Action {
    public ListSourceConnectorsAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/listsourceconnectors.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else {
            MainManager importer = (MainManager)this.servletContext.getAttribute("com.neptunelabs.fsiserver.sourcemanager.MainManager");
            SourceManagerSettings settings = importer.getSourceManagerSettings();
            Map<String, SourceConnectorReader> connectors = settings.getAllConnectors();
            SimpleHash connectorList = new SimpleHash();
            for (Map.Entry<String, SourceConnectorReader> connector : connectors.entrySet()) {
                SimpleHash connectorProperties = new SimpleHash();
                connectorProperties.put("enabled", connector.getValue().isEnabled());
                connectorProperties.put("images", (Object)connector.getValue().getCurrentImageCount());
                connectorList.put(connector.getKey(), (Object)connectorProperties);
            }
            templateData.put("connectors", (Object)connectorList);
            status = 200;
        }
        return status;
    }
}

