/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions;

import com.neptunelabs.fsiframework.cache.CacheManager;
import com.neptunelabs.fsiframework.cache.CacheType;
import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.util.Map;
import javax.servlet.ServletContext;

public class MemoryCacheAction
extends Action {
    public MemoryCacheAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/memorycache.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else {
            CacheManager serverCacheManager = this.requestProcessorSettings.getCacheManager();
            CacheManager importerCacheManager = this.sourceManagerSettings.getCacheManager();
            if (parameters.get("clearcache") != null && serverCacheManager != null) {
                serverCacheManager.clearAll();
                if (importerCacheManager != null && serverCacheManager != importerCacheManager) {
                    importerCacheManager.clearAll();
                }
                templateData.put("message", (Object)"All server internal caches have been cleared.");
            }
            if (serverCacheManager != null) {
                SimpleHash requestProcessorCacheStats = this.getCacheManagerStats(serverCacheManager);
                templateData.put("requestprocessorcache", (Object)requestProcessorCacheStats);
            }
            if (serverCacheManager != importerCacheManager) {
                SimpleHash sourceManagerCacheStats = this.getCacheManagerStats(importerCacheManager);
                templateData.put("sourcemanagercache", (Object)sourceManagerCacheStats);
            }
            templateData.put("show_form", true);
            status = 200;
        }
        return status;
    }

    private SimpleHash getCacheManagerStats(CacheManager manager) {
        SimpleHash cacheStats = new SimpleHash();
        cacheStats.put("total_bytes", (Object)manager.getAllocatedCacheSize());
        cacheStats.put("used_bytes", (Object)manager.getUsedCacheSize());
        cacheStats.put("objects", (Object)manager.getObjectCountL2());
        for (CacheType ct : CacheType.values()) {
            cacheStats.put("requests_" + ct.name(), (Object)manager.getStatRequests(ct));
            cacheStats.put("hits_L1_" + ct.name(), (Object)manager.getStatL1Hits(ct));
            cacheStats.put("hits_L2_" + ct.name(), (Object)manager.getStatL2Hits(ct));
            cacheStats.put("saves_" + ct.name(), (Object)manager.getStatSaved(ct));
            cacheStats.put("savesfailed_" + ct.name(), (Object)manager.getStatSaveFailed(ct));
        }
        return cacheStats;
    }
}

