/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiserver.authentication.Group;
import com.neptunelabs.fsiserver.authentication.PropertySet;
import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import com.neptunelabs.fsiserver.utils.SourceConnector;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.utils.ServletUtils;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleSequence;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXB;

public class NewAccountWizard
extends Action {
    public NewAccountWizard(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/newaccount.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        UserAuthenticationInterface uai = this.getUserAuthenticationInterface();
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            return 403;
        }
        if (!uai.isUserModificationPossible()) {
            templateData.put("externalusermanagement", true);
            return 200;
        }
        if (!parameters.containsKey("wizardaction")) {
            templateData.put("wizard_intro", true);
            templateData.put("available_groups", (Object)this.getGroups());
            return 200;
        }
        templateData.put("wizardaction", parameters.get("wizardaction"));
        if (((String)parameters.get("wizardaction")).equals("newadmin")) {
            if (parameters.containsKey("newusername")) {
                boolean isOk = true;
                isOk &= this.checkUserName(parameters, templateData);
                String newUsername = (String)parameters.get("newusername");
                if (isOk &= this.checkPassword(parameters, templateData)) {
                    String password = (String)parameters.get("pwd1");
                    boolean success = uai.addUser(newUsername, password);
                    if (success) {
                        templateData.put("user_created", (Object)newUsername);
                        success = uai.addUserGroupAssignment("administrators", newUsername);
                        if (success) {
                            templateData.put("user_added_to_group", (Object)"administrators");
                            templateData.put("show_confirmation", (Object)"true");
                        } else {
                            templateData.put("message", (Object)"Failed to add user to group.");
                        }
                    } else {
                        templateData.put("message", (Object)"Failed to create user.");
                    }
                    return 200;
                }
                templateData.put("newusername", (Object)newUsername);
            }
            templateData.put("show_form", true);
            templateData.put("request_username", true);
            if (!uai.isKerberosAuthenticationEnabled()) {
                templateData.put("request_password", true);
            }
            return 200;
        }
        if (((String)parameters.get("wizardaction")).equals("neweverything")) {
            if (parameters.containsKey("newusername")) {
                boolean isOk = true;
                isOk &= this.checkUserName(parameters, templateData);
                isOk &= this.checkPassword(parameters, templateData);
                isOk &= this.checkNewGroupname(parameters, templateData);
                List<Map<String, String>> connectors = this.extractConnectors(parameters);
                String username = (String)parameters.get("newusername");
                String groupname = (String)parameters.get("newgroupname");
                if (!(isOk &= this.checkConnectors(connectors, templateData))) {
                    this.undoDirectoryCreation(connectors);
                }
                if (isOk) {
                    String password = (String)parameters.get("pwd1");
                    uai.addUser(username, password);
                    TreeSet<String> usersSet = new TreeSet<String>();
                    usersSet.add(username);
                    String userViewerPath = this.createUserViewerDirectory(groupname);
                    uai.addPublishingSet(groupname, userViewerPath);
                    PropertySet propSet = new PropertySet();
                    propSet.addPublishingSet(groupname);
                    uai.addPropertySet(groupname, propSet);
                    templateData.put("publishingset_created", (Object)groupname);
                    templateData.put("propertyset_created", (Object)groupname);
                    uai.addGroup(groupname, usersSet, "default_authenticated", groupname);
                    templateData.put("user_created", (Object)username);
                    templateData.put("group_created", (Object)groupname);
                    templateData.put("user_added_to_group", (Object)username);
                    for (Map<String, String> connectorDef : connectors) {
                        this.createConnector(connectorDef, groupname);
                    }
                    templateData.put("connectors_created", (Object)"true");
                    templateData.put("show_confirmation", true);
                } else {
                    templateData.put("request_username", true);
                    if (!uai.isKerberosAuthenticationEnabled()) {
                        templateData.put("request_password", true);
                    }
                    templateData.put("newusername", (Object)username);
                    templateData.put("request_groupname", true);
                    templateData.put("groupname", (Object)groupname);
                    templateData.put("request_connectors", true);
                    templateData.put("storageconnector", parameters.get("storageconnector"));
                    templateData.put("storageconnectorname", parameters.get("storageconnectorname"));
                    templateData.put("storageconnectordirectory", parameters.get("storageconnectordirectory"));
                    templateData.put("staticconnector", parameters.get("staticconnector"));
                    templateData.put("staticconnectorname", parameters.get("staticconnectorname"));
                    templateData.put("staticconnectordirectory", parameters.get("staticconnectordirectory"));
                    templateData.put("multiresolutionconnector", parameters.get("multiresolutionconnector"));
                    templateData.put("multiresolutionconnectorname", parameters.get("multiresolutionconnectorname"));
                    templateData.put("multiresolutionconnectordirectory", parameters.get("multiresolutionconnectordirectory"));
                    templateData.put("show_form", true);
                }
            } else {
                templateData.put("request_username", true);
                if (!uai.isKerberosAuthenticationEnabled()) {
                    templateData.put("request_password", true);
                }
                templateData.put("request_groupname", true);
                templateData.put("request_connectors", true);
                templateData.put("show_form", true);
            }
            return 200;
        }
        if (((String)parameters.get("wizardaction")).equals("newuserforgroup")) {
            if (parameters.containsKey("newusername")) {
                boolean isOk = true;
                isOk &= this.checkUserName(parameters, templateData);
                isOk &= this.checkPassword(parameters, templateData);
                String username = (String)parameters.get("newusername");
                String groupname = (String)parameters.get("groupname");
                if (isOk &= this.checkExistingGroupname(parameters, templateData)) {
                    String password = (String)parameters.get("pwd1");
                    uai.addUser(username, password);
                    templateData.put("user_created", (Object)username);
                    uai.addUserGroupAssignment(groupname, username);
                    templateData.put("user_added_to_group", (Object)groupname);
                    templateData.put("show_confirmation", true);
                } else {
                    templateData.put("request_username", true);
                    if (!uai.isKerberosAuthenticationEnabled()) {
                        templateData.put("request_password", true);
                    }
                    templateData.put("request_existing_group", true);
                    templateData.put("available_groups", (Object)this.getGroups());
                    templateData.put("groupname", (Object)groupname);
                    templateData.put("show_form", true);
                }
            } else {
                templateData.put("request_username", true);
                if (!uai.isKerberosAuthenticationEnabled()) {
                    templateData.put("request_password", true);
                }
                templateData.put("request_existing_group", true);
                templateData.put("available_groups", (Object)this.getGroups());
                templateData.put("show_form", true);
            }
            return 200;
        }
        return 0;
    }

    private String createUserViewerDirectory(String name) {
        Path userDir = ServletUtils.getRealPath(this.sourceManagerSettings.getServletContext(), "/users").resolve(name);
        Path userViewerDir = userDir.resolve("viewer");
        Path defaultViewerDir = ServletUtils.getRealPath(this.sourceManagerSettings.getServletContext(), "/viewer");
        FileOperations.copyDirectory(this.sourceManagerLogger, defaultViewerDir, userViewerDir);
        return "users/" + name + "/viewer";
    }

    private boolean checkUserName(Map<String, Object> parameters, SimpleHash templateData) {
        boolean isOk = true;
        String requestedUsername = (String)parameters.get("newusername");
        if (requestedUsername.length() == 0) {
            templateData.put("message", (Object)"Invalid username. Please choose a different name.");
            isOk = false;
        }
        if (this.getUserAuthenticationInterface().getUsers().contains(requestedUsername)) {
            templateData.put("message", (Object)"A user with the requested name already exists.");
            isOk = false;
        }
        return isOk;
    }

    private boolean checkPassword(Map<String, Object> parameters, SimpleHash templateData) {
        boolean isOk = true;
        if (!this.getUserAuthenticationInterface().isKerberosAuthenticationEnabled()) {
            String password2;
            String password = (String)parameters.get("pwd1");
            if (isOk && !password.equals(password2 = (String)parameters.get("pwd2"))) {
                templateData.put("message", (Object)"The passwords do not match.");
                isOk = false;
            }
        }
        return isOk;
    }

    private boolean checkExistingGroupname(Map<String, Object> parameters, SimpleHash templateData) {
        String requestedGroupname = (String)parameters.get("groupname");
        if (requestedGroupname == null || requestedGroupname.length() == 0) {
            templateData.put("message", (Object)"Please provide a group name");
            return false;
        }
        if (!this.getUserAuthenticationInterface().getGroups().containsKey(requestedGroupname)) {
            templateData.put("message", (Object)"The requested group does not exist.");
            return false;
        }
        return true;
    }

    private boolean checkNewGroupname(Map<String, Object> parameters, SimpleHash templateData) {
        String requestedGroupname = (String)parameters.get("newgroupname");
        if (requestedGroupname == null || requestedGroupname.length() == 0) {
            templateData.put("message", (Object)"Please enter a group name");
            return false;
        }
        if (this.getUserAuthenticationInterface().getGroups().containsKey(requestedGroupname)) {
            templateData.put("message", (Object)"A group of the name already exists.");
            return false;
        }
        return true;
    }

    private List<Map<String, String>> extractConnectors(Map<String, Object> parameters) {
        HashMap<String, String> connector;
        ArrayList<Map<String, String>> connectors = new ArrayList<Map<String, String>>();
        if (parameters.containsKey("storageconnector") && Boolean.valueOf((String)parameters.get("storageconnector")).booleanValue()) {
            connector = new HashMap<String, String>();
            connector.put("type", "storage");
            connector.put("name", (String)parameters.get("storageconnectorname"));
            connector.put("directory", (String)parameters.get("storageconnectordirectory"));
            connectors.add(connector);
        }
        if (parameters.containsKey("staticconnector") && Boolean.valueOf((String)parameters.get("staticconnector")).booleanValue()) {
            connector = new HashMap();
            connector.put("type", "static");
            connector.put("name", (String)parameters.get("staticconnectorname"));
            connector.put("directory", (String)parameters.get("staticconnectordirectory"));
            connectors.add(connector);
        }
        if (parameters.containsKey("multiresolutionconnector") && Boolean.valueOf((String)parameters.get("multiresolutionconnector")).booleanValue()) {
            connector = new HashMap();
            connector.put("type", "multiresolution");
            connector.put("name", (String)parameters.get("multiresolutionconnectorname"));
            connector.put("directory", (String)parameters.get("multiresolutionconnectordirectory"));
            connectors.add(connector);
        }
        return connectors;
    }

    private boolean checkConnectors(List<Map<String, String>> connectorDefinitions, SimpleHash templateData) {
        boolean isOk = true;
        Set<String> existingConnectorNames = this.sourceManagerSettings.getAllConnectors().keySet();
        for (Map<String, String> connectorDef : connectorDefinitions) {
            if (existingConnectorNames.contains(connectorDef.get("name"))) {
                isOk = false;
                templateData.put("message", (Object)("A connector named " + connectorDef.get("name") + " already exists."));
                continue;
            }
            Path connectorDir = Paths.get(connectorDef.get("directory"), new String[0]);
            if (Files.exists(connectorDir, new LinkOption[0])) {
                if (Files.isReadable(connectorDir)) continue;
                isOk = false;
                templateData.put("message", (Object)("The directory " + connectorDef.get("directory") + " exists, but is not readable."));
                continue;
            }
            try {
                Files.createDirectories(connectorDir, new FileAttribute[0]);
                connectorDef.put("created", "true");
            }
            catch (IOException ioe) {
                isOk = false;
                templateData.put("message", (Object)("The directory " + connectorDef.get("directory") + " could not be created."));
            }
        }
        return isOk;
    }

    private void undoDirectoryCreation(List<Map<String, String>> connectors) {
        for (Map<String, String> connectorDef : connectors) {
            if (!connectorDef.containsKey("created")) continue;
            Path dir = Paths.get(connectorDef.get("directory"), new String[0]);
            try {
                Files.deleteIfExists(dir);
            }
            catch (IOException iOException) {}
        }
    }

    private boolean createConnector(Map<String, String> connectorDefinition, String groupname) {
        SourceConnector rsc = new SourceConnector();
        rsc.type = connectorDefinition.get("type");
        rsc.enabled = true;
        rsc.origin.location = connectorDefinition.get("directory");
        rsc.access = new SourceConnector.AccessType();
        SourceConnector.GroupEntry publicGroup = new SourceConnector.GroupEntry();
        publicGroup.groupname = "public";
        publicGroup.permissionset = rsc.type.equals("static") ? "public_statics" : "public_images";
        rsc.access.groupEntries.add(publicGroup);
        SourceConnector.GroupEntry userGroup = new SourceConnector.GroupEntry();
        userGroup.groupname = groupname;
        userGroup.permissionset = "read_write";
        rsc.access.groupEntries.add(userGroup);
        Path connectorfile = this.sourceManagerSettings.getSourceConnectorPath().resolve(connectorDefinition.get("name") + ".xml");
        try {
            JAXB.marshal((Object)rsc, (File)connectorfile.toFile());
        }
        catch (DataBindingException ioe) {
            return false;
        }
        return true;
    }

    private SimpleSequence getGroups() {
        UserAuthenticationInterface uai = this.getUserAuthenticationInterface();
        Map<String, Group> groupmap = uai.getGroups();
        ArrayList<String> groupnames = new ArrayList<String>(groupmap.keySet());
        Collections.sort(groupnames);
        SimpleSequence s = new SimpleSequence();
        for (String gname : groupnames) {
            if (gname.equalsIgnoreCase("authenticated") || gname.equalsIgnoreCase("public")) continue;
            SimpleHash entry = new SimpleHash();
            entry.put("value", (Object)gname);
            entry.put("description", (Object)gname);
            s.add((Object)entry);
        }
        return s;
    }
}

