/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions;

import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import com.neptunelabs.fsiserver.fsiadministrator.actions.FormHelpers;
import com.neptunelabs.fsiserver.requestprocessor.settings.OutputParameters;
import com.neptunelabs.imagemanipulator.encoder.jpeg.JPEGPreparation;
import freemarker.template.SimpleHash;
import javax.servlet.ServletContext;

public abstract class RendererAction
extends Action {
    public RendererAction(ServletContext servletContext) {
        super(servletContext);
    }

    protected void outputParametersToTemplate(OutputParameters parameters, SimpleHash templateData) {
        String qualityStr = parameters.quality == -1 ? "default" : String.valueOf(parameters.quality);
        templateData.put("quality", (Object)qualityStr);
        templateData.put("embedicc", parameters.embedicc);
        templateData.put("available_chromasubsamplings", FormHelpers.getAvailableChromasubsamplings());
        if (parameters.chromaSubsampling == JPEGPreparation.ChromaSubsampling.CS420) {
            templateData.put("chromasubsampling", (Object)"4:2:0");
        } else if (parameters.chromaSubsampling == JPEGPreparation.ChromaSubsampling.CS422) {
            templateData.put("chromasubsampling", (Object)"4:2:2");
        } else if (parameters.chromaSubsampling == JPEGPreparation.ChromaSubsampling.CS444) {
            templateData.put("chromasubsampling", (Object)"4:4:4");
        }
        templateData.put("available_ditherers", FormHelpers.getAvailableDitherers());
        templateData.put("ditherer", (Object)String.valueOf((Object)parameters.ditherer));
        templateData.put("available_quantizers", FormHelpers.getAvailableQuantizer());
        templateData.put("quantizer", (Object)String.valueOf((Object)parameters.quantizer));
        templateData.put("quantizersampledepth", (Object)String.valueOf(parameters.quantizerSampleDepth));
        templateData.put("available_compressionlevels", FormHelpers.getAvailableCompressionLevels());
        templateData.put("compressionlevel", (Object)String.valueOf(parameters.compressionLevel));
        templateData.put("available_compressionfilters", FormHelpers.getAvailableCompressionFilters());
        templateData.put("compressionfilter", (Object)String.valueOf(parameters.compressionFilter));
        templateData.put("available_colorspaces", FormHelpers.getAvailableColorspaces());
        templateData.put("colorspace", (Object)String.valueOf((Object)parameters.colorspace));
        templateData.put("available_encodings", FormHelpers.getAvailableOutputEncodings());
        templateData.put("encoding", (Object)parameters.encoding);
        templateData.put("loop", (Object)parameters.gifLoopCount);
        templateData.put("framepalette", parameters.gifFramePalette);
        templateData.put("optimizehuffman", parameters.optimizeHuffman);
        int colorValue = parameters.backgroundColor;
        String bgColorString = colorValue >= 0 ? Integer.toHexString(colorValue) : "";
        templateData.put("backgroundcolor", (Object)bgColorString);
        templateData.put("delay", (Object)parameters.gifDelay);
        String maxColorsString = parameters.maxIndexedColors == -1 ? "" : String.valueOf(parameters.maxIndexedColors);
        templateData.put("maxcolors", (Object)maxColorsString);
        String dpiStr = parameters.dpi == -1 ? "default" : String.valueOf(parameters.dpi);
        templateData.put("dpi", (Object)dpiStr);
    }
}

