/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions;

import com.neptunelabs.fsiframework.SoftwareVersion;
import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import com.neptunelabs.fsiserver.fsiadministrator.actions.FormHelpers;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.settings.Section;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleSequence;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;

public class RequestProcessorSettingsAction
extends Action {
    private final String[] searchParameters = new String[]{"solrserveruri", "core", "authentication", "authenticationtype", "authenticationusername", "authenticationpassword", "proxy", "proxyhostname", "proxyport", "proxyssl", "proxyauthentication", "proxyusername", "proxypassword", "connectionpoolmax"};
    private final String[] advancedParameters = new String[]{"jmx", "byteorder", "cachetemplates", "priority", "maxcpu", "maxio", "tempdirectory"};
    private final String[] cacheParameters = new String[]{"directmemory", "maxmemory"};

    public RequestProcessorSettingsAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/requestprocessorsettings.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        status = sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal() ? 403 : (parameters.containsKey("editsettings") ? this.performEditApplicationSettings(parameters, templateData) : (parameters.containsKey("editsearch") ? this.performEditSearchSettings(parameters, templateData) : (parameters.containsKey("editcms") ? this.performEditColorManagement(parameters, templateData) : (parameters.containsKey("editlimits") ? this.performEditLimitsSettings(parameters, templateData) : (parameters.containsKey("editadvanced") ? this.performEditAdvancedSettings(parameters, templateData) : (parameters.containsKey("editrequestprocessorcache") ? this.performEditCacheSettings(parameters, templateData) : this.displaySettings(templateData)))))));
        return status;
    }

    private int performEditApplicationSettings(Map<String, Object> parameters, SimpleHash templateData) {
        int status;
        if (parameters.containsKey("save")) {
            this.requestProcessorSettings.enableSection("application", (String)parameters.get("enabled"));
            this.requestProcessorSettings.setPrefs("application", Section.SectionTypes.valueNames, "sourcemanager", (String)parameters.get("sourcemanager"));
            this.requestProcessorSettings.setPrefs("application", Section.SectionTypes.valueNames, "storage", (String)parameters.get("storage"));
            this.requestProcessorSettings.setPrefs("application", Section.SectionTypes.valueNames, "requestprocessortokens", (String)parameters.get("requestprocessortokens"));
            String copyrightnotice = (String)parameters.get("copyrightnotice");
            if (copyrightnotice.trim().length() > 0) {
                this.requestProcessorSettings.setPrefs("application", Section.SectionTypes.valueNames, "copyrightnotice", copyrightnotice);
            }
            this.requestProcessorSettings.saveSettingsFile();
            templateData.put("show_confirmation", true);
            status = 200;
        } else {
            this.settingsToTemplate(templateData);
            templateData.put("show_form", true);
            templateData.put("available_requestprocessortokens", FormHelpers.getServerTokens());
            status = 200;
        }
        return status;
    }

    private int performEditAdvancedSettings(Map<String, Object> parameters, SimpleHash templateData) {
        int status;
        if (parameters.containsKey("save")) {
            for (String parameterName : this.advancedParameters) {
                this.trimAndSetPref(parameters, "application", parameterName);
            }
            this.requestProcessorSettings.saveSettingsFile();
            templateData.put("show_confirmation", true);
            status = 200;
        } else {
            this.advancedSettingsToTemplate(templateData);
            templateData.put("show_advancedsettings_form", true);
            templateData.put("available_byteorders", FormHelpers.getServerByteOrder());
            status = 200;
        }
        return status;
    }

    private void advancedSettingsToTemplate(SimpleHash templateData) {
        templateData.put("enabled", this.requestProcessorSettings.hasSectionEnabled("application"));
        for (String parameterName : this.advancedParameters) {
            templateData.put(parameterName, (Object)this.requestProcessorSettings.getPrefsString("application", parameterName));
        }
    }

    private int performEditColorManagement(Map<String, Object> parameters, SimpleHash templateData) {
        if (parameters.containsKey("save")) {
            this.requestProcessorSettings.enableSection("colormanagementsystem", (String)parameters.get("enabled"));
            this.requestProcessorSettings.setPrefs("colormanagementsystem", Section.SectionTypes.valueNames, "fallbackICCConversion", (String)parameters.get("fallbackICCConversion"));
            String defaultcmykprofile = ((String)parameters.get("defaultcmykprofile")).trim();
            this.requestProcessorSettings.setPrefs("colormanagementsystem", Section.SectionTypes.valueNames, "defaultcmykprofile", defaultcmykprofile.length() > 0 ? defaultcmykprofile : "auto");
            String defaultrgbprofile = ((String)parameters.get("defaultrgbprofile")).trim();
            this.requestProcessorSettings.setPrefs("colormanagementsystem", Section.SectionTypes.valueNames, "defaultrgbprofile", defaultrgbprofile.length() > 0 ? defaultrgbprofile : "auto");
            String defaultgrayprofile = ((String)parameters.get("defaultgrayprofile")).trim();
            this.requestProcessorSettings.setPrefs("colormanagementsystem", Section.SectionTypes.valueNames, "defaultgrayprofile", defaultgrayprofile.length() > 0 ? defaultgrayprofile : "auto");
            this.requestProcessorSettings.saveSettingsFile();
            templateData.put("show_confirmation", true);
        } else {
            this.cmsSettingsToTemplate(templateData);
            templateData.put("show_cmssettings_form", true);
        }
        int status = 200;
        return status;
    }

    private int performEditLimitsSettings(Map<String, Object> parameters, SimpleHash templateData) {
        if (parameters.containsKey("save")) {
            String defaultrenderer = ((String)parameters.get("defaultrenderer")).trim();
            this.requestProcessorSettings.setPrefs("limits", Section.SectionTypes.valueNames, "defaultrenderer", defaultrenderer.length() > 0 ? defaultrenderer : "default");
            String defaultwidth = ((String)parameters.get("defaultwidth")).trim();
            this.requestProcessorSettings.setPrefs("limits", Section.SectionTypes.valueNames, "defaultwidth", defaultwidth.length() > 0 ? defaultwidth : Integer.toString(400));
            String defaultheight = ((String)parameters.get("defaultheight")).trim();
            this.requestProcessorSettings.setPrefs("limits", Section.SectionTypes.valueNames, "defaultheight", defaultheight.length() > 0 ? defaultheight : Integer.toString(300));
            String maxwidth = ((String)parameters.get("maxwidth")).trim();
            this.requestProcessorSettings.setPrefs("limits", Section.SectionTypes.valueNames, "maxwidth", maxwidth.length() > 0 ? maxwidth : Integer.toString(5120));
            String maxheight = ((String)parameters.get("maxheight")).trim();
            this.requestProcessorSettings.setPrefs("limits", Section.SectionTypes.valueNames, "maxheight", maxheight.length() > 0 ? maxheight : Integer.toString(300));
            String sortcollator = ((String)parameters.get("sortcollator")).trim();
            this.requestProcessorSettings.setPrefs("limits", Section.SectionTypes.valueNames, "sortcollator", sortcollator.length() > 0 ? sortcollator : "auto");
            this.requestProcessorSettings.saveSettingsFile();
            templateData.put("show_confirmation", true);
        } else {
            this.limitsSettingsToTemplate(templateData);
            templateData.put("show_limitssettings_form", true);
            templateData.put("available_sortcollatorstrings", FormHelpers.getAvailableLocaleStrings());
        }
        int status = 200;
        return status;
    }

    private int performEditCacheSettings(Map<String, Object> parameters, SimpleHash templateData) {
        int status;
        if (this.requestProcessorSettings.useOwnCacheManager()) {
            if (parameters.containsKey("save")) {
                this.requestProcessorSettings.enableSection("cache", (String)parameters.get("memorycacheenabled"));
                for (String parameterName : this.cacheParameters) {
                    this.trimAndSetPref(parameters, "cache", parameterName);
                }
                this.requestProcessorSettings.saveSettingsFile();
                templateData.put("show_confirmation", true);
                status = 200;
            } else {
                this.serverCacheSettingsToTemplate(templateData);
                templateData.put("show_requestprocessorcachesettings_form", true);
                status = 200;
            }
        } else {
            templateData.put("show_uses_source_manager_cache_message", true);
            status = 200;
        }
        return status;
    }

    private void serverCacheSettingsToTemplate(SimpleHash templateData) {
        if (this.requestProcessorSettings.useOwnCacheManager()) {
            templateData.put("cacheenabled", this.requestProcessorSettings.hasSectionEnabled("cache"));
            templateData.put("directmemory", this.requestProcessorSettings.getPrefsBoolean("cache", "directmemory"));
            templateData.put("maxmemory", (Object)this.requestProcessorSettings.getPrefsString("cache", "maxmemory"));
        } else {
            templateData.put("uses_source_manager_cache", true);
        }
    }

    private int performEditSearchSettings(Map<String, Object> parameters, SimpleHash templateData) {
        if (parameters.containsKey("save")) {
            this.requestProcessorSettings.enableSection("search", (String)parameters.get("enabled"));
            for (String parameterName : this.searchParameters) {
                this.trimAndSetPref(parameters, "search", parameterName);
            }
            this.requestProcessorSettings.saveSettingsFile();
            templateData.put("show_confirmation", true);
        } else {
            templateData.put("all_searchdbtypes", (Object)this.getAllSearchDatabaseTypesForTemplate());
            this.searchSettingsToTemplate(templateData);
            templateData.put("authentication_types", (Object)this.getAvailableHTTPAuthenticationMethods());
            templateData.put("show_searchsettings_form", true);
        }
        int status = 200;
        return status;
    }

    private void searchSettingsToTemplate(SimpleHash templateData) {
        templateData.put("searchenabled", this.requestProcessorSettings.hasSectionEnabled("search"));
        templateData.put("type", (Object)this.requestProcessorSettings.getPrefsString("search", "type"));
        for (String parameterName : this.searchParameters) {
            templateData.put(parameterName, (Object)this.requestProcessorSettings.getPrefsString("search", parameterName));
        }
    }

    private void trimAndSetPref(Map<String, Object> parameters, String section, String name) {
        String value = ((String)parameters.get(name)).trim();
        this.requestProcessorSettings.setPrefs(section, Section.SectionTypes.valueNames, name, value);
    }

    private void settingsToTemplate(SimpleHash templateData) {
        templateData.put("enabled", this.requestProcessorSettings.hasSectionEnabled("application"));
        templateData.put("requestprocessortokens", (Object)this.requestProcessorSettings.getPrefsString("application", "requestprocessortokens"));
        templateData.put("storage", (Object)this.requestProcessorSettings.getPrefsString("application", "storage"));
        templateData.put("sourcemanager", (Object)this.requestProcessorSettings.getPrefsString("application", "sourcemanager"));
        String copyrightnotice = this.requestProcessorSettings.getPrefsString("application", "copyrightnotice");
        if (copyrightnotice.equals(SoftwareVersion.getVendor())) {
            templateData.put("copyrightnotice", (Object)"");
        } else {
            templateData.put("copyrightnotice", (Object)this.requestProcessorSettings.getPrefsString("application", "copyrightnotice"));
        }
    }

    private void cmsSettingsToTemplate(SimpleHash templateData) {
        templateData.put("cmsenabled", this.requestProcessorSettings.hasSectionEnabled("colormanagementsystem"));
        templateData.put("fallbackICCConversion", this.requestProcessorSettings.getPrefsBoolean("colormanagementsystem", "fallbackICCConversion"));
        templateData.put("defaultcmykprofile", (Object)this.requestProcessorSettings.getPrefsString("colormanagementsystem", "defaultcmykprofile"));
        templateData.put("defaultrgbprofile", (Object)this.requestProcessorSettings.getPrefsString("colormanagementsystem", "defaultrgbprofile"));
        templateData.put("defaultgrayprofile", (Object)this.requestProcessorSettings.getPrefsString("colormanagementsystem", "defaultgrayprofile"));
    }

    private void limitsSettingsToTemplate(SimpleHash templateData) {
        templateData.put("defaultrenderer", (Object)this.requestProcessorSettings.getPrefsString("limits", "defaultrenderer"));
        templateData.put("defaultwidth", (Object)this.requestProcessorSettings.getPrefsString("limits", "defaultwidth"));
        templateData.put("defaultheight", (Object)this.requestProcessorSettings.getPrefsString("limits", "defaultheight"));
        templateData.put("maxwidth", (Object)this.requestProcessorSettings.getPrefsString("limits", "maxwidth"));
        templateData.put("maxheight", (Object)this.requestProcessorSettings.getPrefsString("limits", "maxheight"));
        String sortcollator = this.requestProcessorSettings.getPrefsString("limits", "sortcollator");
        templateData.put("sortcollator", (Object)sortcollator);
        if (sortcollator != null && sortcollator.length() > 0 && !sortcollator.equals("auto") && !sortcollator.equals("none")) {
            sortcollator = sortcollator + " (" + new Locale(sortcollator).getDisplayLanguage() + ")";
        }
        templateData.put("sortcollatortext", (Object)sortcollator);
    }

    private SimpleSequence getAllSearchDatabaseTypesForTemplate() {
        SimpleSequence dbTypes = new SimpleSequence();
        SimpleHash type1 = new SimpleHash();
        type1.put("value", (Object)"h2");
        type1.put("description", (Object)"H2 - embedded");
        dbTypes.add((Object)type1);
        SimpleHash type2 = new SimpleHash();
        type2.put("value", (Object)"mysql");
        type2.put("description", (Object)"MySQL/MariaDB - external");
        dbTypes.add((Object)type2);
        return dbTypes;
    }

    private int displaySettings(SimpleHash templateData) {
        this.settingsToTemplate(templateData);
        this.searchSettingsToTemplate(templateData);
        this.cmsSettingsToTemplate(templateData);
        this.limitsSettingsToTemplate(templateData);
        this.advancedSettingsToTemplate(templateData);
        this.serverCacheSettingsToTemplate(templateData);
        templateData.put("showsettings", true);
        return 200;
    }

    private SimpleSequence getAvailableHTTPAuthenticationMethods() {
        SimpleSequence result = new SimpleSequence();
        SimpleHash method1 = new SimpleHash();
        method1.put("value", (Object)"basic");
        method1.put("description", (Object)"BASIC");
        result.add((Object)method1);
        SimpleHash method2 = new SimpleHash();
        method2.put("value", (Object)"digest");
        method2.put("description", (Object)"DIGEST");
        result.add((Object)method2);
        SimpleHash method3 = new SimpleHash();
        method3.put("value", (Object)"ntlm");
        method3.put("description", (Object)"NTLM");
        result.add((Object)method3);
        return result;
    }
}

