/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions;

import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import com.neptunelabs.fsiserver.search.SDBChecker;
import com.neptunelabs.fsiserver.search.solr.SearchDatabaseSolr;
import com.neptunelabs.fsiserver.search.solr.SolrResponse;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.util.Map;
import javax.servlet.ServletContext;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class SearchDatabaseAction
extends Action {
    public SearchDatabaseAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/searchdatabase.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else {
            SearchDatabaseSolr solr = this.requestProcessorSettings.getSearchDatabaseSolr();
            if (solr == null || !solr.isInitiated()) {
                templateData.put("show_disabled", true);
            } else {
                SDBChecker sdbChecker;
                boolean showSummary = false;
                if (parameters.containsKey("schedule_check")) {
                    if (parameters.containsKey("confirmed")) {
                        sdbChecker = this.sourceManager.getSDBChecker();
                        if (sdbChecker != null) {
                            sdbChecker.scheduleCheck();
                        }
                        templateData.put("message", (Object)"Search Database Check scheduled.");
                        showSummary = true;
                    } else {
                        templateData.put("show_check_request", true);
                    }
                } else {
                    showSummary = true;
                }
                if (showSummary) {
                    sdbChecker = this.sourceManager.getSDBChecker();
                    if (sdbChecker != null) {
                        templateData.put("check_status", (Object)sdbChecker.getStatus().name());
                        templateData.put("check_scheduled", sdbChecker.isCheckScheduled());
                    }
                    templateData.put("solrserveruri", (Object)solr.getSolrServerURI());
                    templateData.put("solrcore", (Object)solr.getSolrCore());
                    SolrResponse systemStatusResponse = solr.getSystemStatusJSON();
                    if (systemStatusResponse.statusCode == 200) {
                        String systemStatusJSON = new String(systemStatusResponse.responseBytes, systemStatusResponse.encoding);
                        this.parseSystemStatusJSON(systemStatusJSON, templateData);
                        templateData.put("solrserver_found", true);
                    }
                    SolrResponse coreStatusResponse = solr.getCoreStatusJSON();
                    if (coreStatusResponse.statusCode == 200) {
                        String coreStatusJSON = new String(coreStatusResponse.responseBytes, coreStatusResponse.encoding);
                        this.parseCoreStatusJSON(coreStatusJSON, templateData, solr.getSolrCore());
                    }
                    templateData.put("show_summary", true);
                }
            }
            status = 200;
        }
        return status;
    }

    private void parseCoreStatusJSON(String json, SimpleHash templateData, String coreName) {
        if (json != null) {
            try {
                JSONObject obj = new JSONObject(json);
                JSONObject statusObject = obj.getJSONObject("status");
                JSONObject coreObject = statusObject.getJSONObject(coreName);
                if (coreObject != null) {
                    SimpleHash core = new SimpleHash();
                    core.put("name", (Object)coreObject.getString("name"));
                    core.put("is_default_core", coreObject.getBoolean("isDefaultCore"));
                    core.put("instance_dir", (Object)coreObject.getString("instanceDir"));
                    core.put("config", (Object)coreObject.getString("config"));
                    core.put("schema", (Object)coreObject.getString("schema"));
                    core.put("uptime", (Object)(coreObject.getLong("uptime") / 1000L));
                    JSONObject indexObject = coreObject.getJSONObject("index");
                    core.put("num_docs", (Object)indexObject.getInt("numDocs"));
                    core.put("max_docs", (Object)indexObject.getInt("maxDoc"));
                    core.put("size", (Object)indexObject.getLong("sizeInBytes"));
                    if (indexObject.has("lastModified")) {
                        core.put("last_modified", indexObject.get("lastModified"));
                    }
                    templateData.put("core", (Object)core);
                    templateData.put("solrcore_found", true);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private void parseSystemStatusJSON(String json, SimpleHash templateData) {
        if (json != null) {
            try {
                JSONObject obj = new JSONObject(json);
                JSONObject jvmObject = obj.getJSONObject("jvm");
                SimpleHash jvm = new SimpleHash();
                jvm.put("name", (Object)jvmObject.getString("name"));
                jvm.put("version", (Object)jvmObject.getString("version"));
                SimpleHash jvmMemValues = new SimpleHash();
                JSONObject jvmMemory = jvmObject.getJSONObject("memory");
                JSONObject rawJVMMemory = jvmMemory.getJSONObject("raw");
                jvmMemValues.put("free", (Object)rawJVMMemory.getLong("free"));
                jvmMemValues.put("total", (Object)rawJVMMemory.getLong("total"));
                jvmMemValues.put("used", (Object)rawJVMMemory.getLong("used"));
                jvmMemValues.put("max", (Object)rawJVMMemory.getLong("max"));
                jvm.put("memory", (Object)jvmMemValues);
                templateData.put("jvm", (Object)jvm);
                JSONObject sysObject = obj.getJSONObject("system");
                SimpleHash system = new SimpleHash();
                system.put("name", (Object)sysObject.getString("name"));
                system.put("version", (Object)sysObject.getString("version"));
                SimpleHash physicalMem = new SimpleHash();
                physicalMem.put("free", (Object)sysObject.getLong("freePhysicalMemorySize"));
                physicalMem.put("total", (Object)sysObject.getLong("totalPhysicalMemorySize"));
                system.put("physical_memory", (Object)physicalMem);
                SimpleHash swapSpace = new SimpleHash();
                swapSpace.put("free", (Object)sysObject.getLong("freeSwapSpaceSize"));
                swapSpace.put("total", (Object)sysObject.getLong("totalSwapSpaceSize"));
                system.put("swap_space", (Object)swapSpace);
                SimpleHash files = new SimpleHash();
                files.put("open", (Object)sysObject.getLong("openFileDescriptorCount"));
                files.put("max", (Object)sysObject.getLong("maxFileDescriptorCount"));
                system.put("files", (Object)files);
                templateData.put("system", (Object)system);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }
}

