/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions;

import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiserver.authentication.Group;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import com.neptunelabs.fsiserver.utils.SourceConnector;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXB;

public class SourceConnectorAccessAction
extends Action {
    public SourceConnectorAccessAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/sourceconnectoraccess.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else {
            if (parameters.containsKey("connectorname")) {
                String connectorname = ((String)parameters.get("connectorname")).trim();
                templateData.put("connectorname", (Object)connectorname);
                SourceConnectorReader connector = this.sourceManagerSettings.getSourceConnector(connectorname);
                if (connector != null) {
                    templateData.put("available_groups", this.getUnassignedGroups(connector));
                    templateData.put("available_permissionsets", this.getPermissionSets());
                    if (parameters.containsKey("add")) {
                        templateData.put("show_form", true);
                    } else if (parameters.containsKey("save")) {
                        UserAuthenticationInterface uai = this.getUserAuthenticationInterface();
                        String newgroupname = (String)parameters.get("group");
                        Group newGroup = uai.getGroups().get(newgroupname);
                        String newpermissionsetname = (String)parameters.get("permissionset");
                        PermissionSet newPermissionSet = uai.getPermissionSets().get(newpermissionsetname);
                        Map<Group, PermissionSet> permissions = connector.getAccessPermissions();
                        permissions.put(newGroup, newPermissionSet);
                        SourceConnector.GroupEntry ge = new SourceConnector.GroupEntry();
                        ge.groupname = newgroupname;
                        ge.permissionset = newpermissionsetname;
                        SourceConnector rip = connector.getSourceConnectorDefinition();
                        rip.access.groupEntries.add(ge);
                        PathCached connectorFile = connector.getSourceConnectorFile();
                        try {
                            JAXB.marshal((Object)rip, (File)connectorFile.toFile());
                            templateData.put("show_confirmation", true);
                        }
                        catch (DataBindingException ioe) {
                            templateData.put("show_error", true);
                            templateData.put("message", (Object)("Error saving source connector: " + ioe.getLocalizedMessage()));
                        }
                    } else if (parameters.containsKey("deletegroup")) {
                        String deletegroup = ((String)parameters.get("deletegroup")).trim();
                        if (parameters.containsKey("confirmed")) {
                            SourceConnector rip = connector.getSourceConnectorDefinition();
                            List<SourceConnector.GroupEntry> list = rip.access.groupEntries;
                            SourceConnector.GroupEntry found = null;
                            for (SourceConnector.GroupEntry ge : list) {
                                if (!ge.groupname.equalsIgnoreCase(deletegroup)) continue;
                                found = ge;
                                break;
                            }
                            if (found != null) {
                                rip.access.groupEntries.remove(found);
                                PathCached connectorFile = connector.getSourceConnectorFile();
                                try {
                                    JAXB.marshal((Object)rip, (File)connectorFile.toFile());
                                    templateData.put("show_confirmation", true);
                                }
                                catch (DataBindingException ioe) {
                                    templateData.put("message", (Object)("Error saving source connector: " + ioe.getLocalizedMessage()));
                                    templateData.put("show_error", true);
                                }
                            }
                        } else {
                            templateData.put("deletegroup", (Object)deletegroup);
                            templateData.put("show_delete_form", true);
                        }
                    } else {
                        SimpleHash accessPermissions = new SimpleHash();
                        for (Map.Entry<Group, PermissionSet> entry : connector.getAccessPermissions().entrySet()) {
                            accessPermissions.put(entry.getKey().getName(), (Object)entry.getValue().getName());
                        }
                        templateData.put("accesspermissions", (Object)accessPermissions);
                        templateData.put("show_list", true);
                    }
                } else {
                    templateData.put("show_error", true);
                    templateData.put("message", (Object)"Unknown source connector");
                }
            } else {
                templateData.put("show_error", true);
                templateData.put("message", (Object)"Unknown source connector");
            }
            status = 200;
        }
        return status;
    }

    private List<Map<String, Object>> getPermissionSets() {
        UserAuthenticationInterface uai = this.getUserAuthenticationInterface();
        Set<String> psets = uai.getPermissionSets().keySet();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (String setname : psets) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("value", setname);
            entry.put("description", setname);
            result.add(entry);
        }
        return result;
    }

    private List<Map<String, String>> getUnassignedGroups(SourceConnectorReader connector) {
        UserAuthenticationInterface uai = this.getUserAuthenticationInterface();
        Set<String> allGroupNames = uai.getGroups().keySet();
        HashSet<String> assignedGroupNames = new HashSet<String>();
        for (Group g : connector.getAccessPermissions().keySet()) {
            assignedGroupNames.add(g.getName());
        }
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (String name : allGroupNames) {
            if (assignedGroupNames.contains(name)) continue;
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("value", name);
            entry.put("description", name);
            result.add(entry);
        }
        Collections.sort(result, new Comparator<Map<String, String>>(){

            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {
                String n1 = o1.get("description");
                String n2 = o2.get("description");
                return n1.compareTo(n2);
            }
        });
        return result;
    }
}

