/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions;

import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.settings.Section;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleSequence;
import java.util.Map;
import javax.servlet.ServletContext;

public class SourceManagerSettingsAction
extends Action {
    private final String[] searchParameters = new String[]{"solrserveruri", "core", "authentication", "authenticationtype", "authenticationusername", "authenticationpassword", "proxy", "proxyhostname", "proxyport", "proxyssl", "proxyauthentication", "proxyusername", "proxypassword", "connectionpoolmax"};
    private final String[] cacheParameters = new String[]{"directmemory", "maxmemory"};

    public SourceManagerSettingsAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/sourcemanagersettings.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        status = sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal() ? 403 : (parameters.containsKey("editsettings") ? this.performEditSettings(parameters, templateData) : (parameters.containsKey("editcachesettings") ? this.performEditCacheSettings(parameters, templateData) : (parameters.containsKey("editscanner") ? this.performEditScannerSettings(parameters, templateData) : (parameters.containsKey("editcms") ? this.performEditColorManagement(parameters, templateData) : (parameters.containsKey("editprotectedfiles") ? this.performEditProtectedSettings(parameters, templateData) : (parameters.containsKey("editsearch") ? this.performEditSearchSettings(parameters, templateData) : this.displaySettings(templateData)))))));
        return status;
    }

    private int performEditCacheSettings(Map<String, Object> parameters, SimpleHash templateData) {
        int status;
        if (parameters.containsKey("save")) {
            this.sourceManagerSettings.enableSection("cache", (String)parameters.get("cacheenabled"));
            for (String parameterName : this.cacheParameters) {
                this.trimAndSetPref(parameters, "cache", parameterName);
            }
            this.sourceManagerSettings.saveSettingsFile();
            templateData.put("show_confirmation", true);
            status = 200;
        } else {
            this.cacheSettingsToTemplate(templateData);
            templateData.put("show_cachesettings_form", true);
            status = 200;
        }
        return status;
    }

    private int performEditProtectedSettings(Map<String, Object> parameters, SimpleHash templateData) {
        if (parameters.containsKey("save")) {
            this.putListValuesToSettings(this.sourceManagerSettings, parameters, "protected_files", "file");
            this.putListValuesToSettings(this.sourceManagerSettings, parameters, "protected_dirs", "dir");
            this.sourceManagerSettings.saveSettingsFile();
            templateData.put("show_confirmation", true);
        } else {
            this.protectedSettingsToTemplate(templateData);
            templateData.put("show_protectedsettings_form", true);
        }
        int status = 200;
        return status;
    }

    private int performEditScannerSettings(Map<String, Object> parameters, SimpleHash templateData) {
        if (parameters.containsKey("save")) {
            this.sourceManagerSettings.enableSection("scanner", (String)parameters.get("enabled"));
            String sorting = ((String)parameters.get("sorting")).trim();
            this.sourceManagerSettings.setPrefs("scanner", Section.SectionTypes.valueNames, "sorting", sorting);
            String convertbefore1stscan = ((String)parameters.get("convertbefore1stscan")).trim();
            this.sourceManagerSettings.setPrefs("scanner", Section.SectionTypes.valueNames, "convertbefore1stscan", convertbefore1stscan);
            String filescandelay = ((String)parameters.get("filescandelay")).trim();
            this.sourceManagerSettings.setPrefs("scanner", Section.SectionTypes.valueNames, "filescandelay", filescandelay);
            this.sourceManagerSettings.saveSettingsFile();
            templateData.put("show_confirmation", true);
        } else {
            this.scannerSettingsToTemplate(templateData);
            templateData.put("show_scannersettings_form", true);
        }
        int status = 200;
        return status;
    }

    private int performEditColorManagement(Map<String, Object> parameters, SimpleHash templateData) {
        if (parameters.containsKey("save")) {
            this.sourceManagerSettings.enableSection("colormanagementsystem", (String)parameters.get("enabled"));
            this.sourceManagerSettings.setPrefs("colormanagementsystem", Section.SectionTypes.valueNames, "fallbackICCConversion", (String)parameters.get("fallbackICCConversion"));
            String defaultcmykprofile = ((String)parameters.get("defaultcmykprofile")).trim();
            this.sourceManagerSettings.setPrefs("colormanagementsystem", Section.SectionTypes.valueNames, "defaultcmykprofile", defaultcmykprofile.length() > 0 ? defaultcmykprofile : "auto");
            String defaultrgbprofile = ((String)parameters.get("defaultrgbprofile")).trim();
            this.sourceManagerSettings.setPrefs("colormanagementsystem", Section.SectionTypes.valueNames, "defaultrgbprofile", defaultrgbprofile.length() > 0 ? defaultrgbprofile : "auto");
            String defaultgrayprofile = ((String)parameters.get("defaultgrayprofile")).trim();
            this.sourceManagerSettings.setPrefs("colormanagementsystem", Section.SectionTypes.valueNames, "defaultgrayprofile", defaultgrayprofile.length() > 0 ? defaultgrayprofile : "auto");
            this.sourceManagerSettings.saveSettingsFile();
            templateData.put("show_confirmation", true);
        } else {
            this.cmsSettingsToTemplate(templateData);
            templateData.put("show_cmssettings_form", true);
        }
        int status = 200;
        return status;
    }

    private int performEditSettings(Map<String, Object> parameters, SimpleHash templateData) {
        if (parameters.containsKey("save")) {
            this.sourceManagerSettings.enableSection("application", (String)parameters.get("enabled"));
            this.sourceManagerSettings.setPrefs("application", Section.SectionTypes.valueNames, "conversionthreads", (String)parameters.get("conversionthreads"));
            this.sourceManagerSettings.setPrefs("application", Section.SectionTypes.valueNames, "storage", (String)parameters.get("storage"));
            this.sourceManagerSettings.setPrefs("application", Section.SectionTypes.valueNames, "maxcpu", (String)parameters.get("maxcpu"));
            this.sourceManagerSettings.setPrefs("application", Section.SectionTypes.valueNames, "maxio", (String)parameters.get("maxio"));
            this.sourceManagerSettings.setPrefs("application", Section.SectionTypes.valueNames, "maxthreadsperjob", (String)parameters.get("maxthreadsperjob"));
            this.sourceManagerSettings.setPrefs("application", Section.SectionTypes.valueNames, "importstrategy", (String)parameters.get("importstrategy"));
            this.sourceManagerSettings.setPrefs("application", Section.SectionTypes.valueNames, "logtostorage", (String)parameters.get("logtostorage"));
            this.sourceManagerSettings.setPrefs("application", Section.SectionTypes.valueNames, "parallelread", (String)parameters.get("parallelread"));
            this.sourceManagerSettings.setPrefs("application", Section.SectionTypes.valueNames, "parallelwrite", (String)parameters.get("parallelwrite"));
            this.sourceManagerSettings.setPrefs("application", Section.SectionTypes.valueNames, "parallelreadwrite", (String)parameters.get("parallelreadwrite"));
            String usekrb = (String)parameters.get("usekrb");
            this.sourceManagerSettings.setPrefs("application", Section.SectionTypes.valueNames, "usekrb", usekrb);
            if (usekrb.equals("true")) {
                this.sourceManagerSettings.setPrefs("application", Section.SectionTypes.valueNames, "krbdebug", (String)parameters.get("krbdebug"));
            }
            String userdb = (String)parameters.get("userdb");
            this.sourceManagerSettings.setPrefs("application", Section.SectionTypes.valueNames, "userdb", userdb);
            if (userdb.equals("ldap")) {
                this.sourceManagerSettings.setPrefs("application", Section.SectionTypes.valueNames, "ldapuri", (String)parameters.get("ldapuri"));
                this.sourceManagerSettings.setPrefs("application", Section.SectionTypes.valueNames, "ldapuser", (String)parameters.get("ldapuser"));
                this.sourceManagerSettings.setPrefs("application", Section.SectionTypes.valueNames, "ldappasswd", (String)parameters.get("ldappasswd"));
                this.sourceManagerSettings.setPrefs("application", Section.SectionTypes.valueNames, "ldapbasedn", (String)parameters.get("ldapbasedn"));
            }
            this.sourceManagerSettings.setPrefs("application", Section.SectionTypes.valueNames, "tempdirectory", (String)parameters.get("tempdirectory"));
            this.sourceManagerSettings.setPrefs("application", Section.SectionTypes.valueNames, "jmx", (String)parameters.get("jmx"));
            this.putListValuesToSettings(this.sourceManagerSettings, parameters, "pingservice", "address");
            this.sourceManagerSettings.saveSettingsFile();
            templateData.put("show_confirmation", true);
        } else {
            templateData.put("all_importstrategies", (Object)this.getAllImportStrategiesForTemplate());
            templateData.put("all_userdb_values", (Object)this.getAllUserDBValues());
            this.applicationSettingsToTemplate(templateData);
            templateData.put("show_mainsettings_form", true);
        }
        int status = 200;
        return status;
    }

    private SimpleSequence getAllSearchDatabaseTypesForTemplate() {
        SimpleSequence dbTypes = new SimpleSequence();
        SimpleHash type1 = new SimpleHash();
        type1.put("value", (Object)"h2");
        type1.put("description", (Object)"H2 - embedded");
        dbTypes.add((Object)type1);
        SimpleHash type2 = new SimpleHash();
        type2.put("value", (Object)"mysql");
        type2.put("description", (Object)"MySQL/MariaDB - external");
        dbTypes.add((Object)type2);
        return dbTypes;
    }

    private SimpleSequence getAllUserDBValues() {
        SimpleSequence result = new SimpleSequence();
        SimpleHash value1 = new SimpleHash();
        value1.put("value", (Object)"xmlfile");
        value1.put("description", (Object)"Local XML Files");
        result.add((Object)value1);
        SimpleHash value2 = new SimpleHash();
        value2.put("value", (Object)"ldap");
        value2.put("description", (Object)"LDAP Server");
        result.add((Object)value2);
        return result;
    }

    private SimpleSequence getAllImportStrategiesForTemplate() {
        SimpleSequence allImportstrategies = new SimpleSequence();
        SimpleHash strategy1 = new SimpleHash();
        strategy1.put("value", (Object)"background");
        strategy1.put("description", (Object)"BACKGROUND");
        allImportstrategies.add((Object)strategy1);
        SimpleHash strategy2 = new SimpleHash();
        strategy2.put("value", (Object)"shared");
        strategy2.put("description", (Object)"SHARED");
        allImportstrategies.add((Object)strategy2);
        SimpleHash strategy3 = new SimpleHash();
        strategy3.put("value", (Object)"standalone");
        strategy3.put("description", (Object)"STANDALONE");
        allImportstrategies.add((Object)strategy3);
        return allImportstrategies;
    }

    private void applicationSettingsToTemplate(SimpleHash templateData) {
        templateData.put("application_enabled", this.sourceManagerSettings.hasSectionEnabled("application"));
        templateData.put("conversionthreads", (Object)this.sourceManagerSettings.getPrefsString("application", "conversionthreads"));
        templateData.put("storage", (Object)this.sourceManagerSettings.getPrefsString("application", "storage"));
        templateData.put("logtostorage", this.sourceManagerSettings.getPrefsBoolean("application", "logtostorage"));
        templateData.put("maxcpu", (Object)this.sourceManagerSettings.getPrefsString("application", "maxcpu"));
        templateData.put("maxio", (Object)this.sourceManagerSettings.getPrefsString("application", "maxio"));
        templateData.put("maxthreadsperjob", (Object)this.sourceManagerSettings.getPrefsString("application", "maxthreadsperjob"));
        templateData.put("importstrategy", (Object)this.sourceManagerSettings.getPrefsString("application", "importstrategy"));
        templateData.put("jmx", this.sourceManagerSettings.getPrefsBoolean("application", "jmx"));
        templateData.put("tempdirectory", (Object)this.sourceManagerSettings.getPrefsString("application", "tempdirectory"));
        templateData.put("userdb", (Object)this.sourceManagerSettings.getPrefsString("application", "userdb"));
        templateData.put("ldapuri", (Object)this.sourceManagerSettings.getPrefsString("application", "ldapuri"));
        templateData.put("ldappassword", (Object)this.sourceManagerSettings.getPrefsString("application", "ldappassword"));
        templateData.put("ldapuser", (Object)this.sourceManagerSettings.getPrefsString("application", "ldapuser"));
        templateData.put("ldapbasedn", (Object)this.sourceManagerSettings.getPrefsString("application", "ldapbasedn"));
        templateData.put("usekrb", this.sourceManagerSettings.getPrefsBoolean("application", "usekrb"));
        templateData.put("krbdebug", (Object)this.sourceManagerSettings.getPrefsString("application", "krbdebug"));
        templateData.put("tempdirectory", (Object)this.sourceManagerSettings.getPrefsString("application", "tempdirectory"));
        templateData.put("parallelread", this.sourceManagerSettings.getPrefsBoolean("application", "parallelread"));
        templateData.put("parallelwrite", this.sourceManagerSettings.getPrefsBoolean("application", "parallelwrite"));
        templateData.put("parallelreadwrite", this.sourceManagerSettings.getPrefsBoolean("application", "parallelreadwrite"));
        this.putListValuesToTemplate(templateData, "pingservice", "address");
    }

    private void scannerSettingsToTemplate(SimpleHash templateData) {
        templateData.put("scanner_enabled", this.sourceManagerSettings.hasSectionEnabled("scanner"));
        templateData.put("convertbefore1stscan", this.sourceManagerSettings.getPrefsBoolean("scanner", "convertbefore1stscan"));
        templateData.put("sorting", this.sourceManagerSettings.getPrefsBoolean("scanner", "sorting"));
        templateData.put("filescandelay", (Object)this.sourceManagerSettings.getPrefsLong("scanner", "filescandelay"));
    }

    private void cmsSettingsToTemplate(SimpleHash templateData) {
        templateData.put("cmsenabled", this.sourceManagerSettings.hasSectionEnabled("colormanagementsystem"));
        templateData.put("fallbackICCConversion", this.sourceManagerSettings.getPrefsBoolean("colormanagementsystem", "fallbackICCConversion"));
        templateData.put("defaultcmykprofile", (Object)this.sourceManagerSettings.getPrefsString("colormanagementsystem", "defaultcmykprofile"));
        templateData.put("defaultrgbprofile", (Object)this.sourceManagerSettings.getPrefsString("colormanagementsystem", "defaultrgbprofile"));
        templateData.put("defaultgrayprofile", (Object)this.sourceManagerSettings.getPrefsString("colormanagementsystem", "defaultgrayprofile"));
    }

    private int performEditSearchSettings(Map<String, Object> parameters, SimpleHash templateData) {
        if (parameters.containsKey("save")) {
            this.sourceManagerSettings.enableSection("search", (String)parameters.get("enabled"));
            for (String parameterName : this.searchParameters) {
                this.trimAndSetPref(parameters, "search", parameterName);
            }
            this.sourceManagerSettings.saveSettingsFile();
            templateData.put("show_confirmation", true);
        } else {
            templateData.put("all_searchdbtypes", (Object)this.getAllSearchDatabaseTypesForTemplate());
            this.searchSettingsToTemplate(templateData);
            templateData.put("authentication_types", (Object)this.getAvailableHTTPAuthenticationMethods());
            templateData.put("show_searchsettings_form", true);
        }
        int status = 200;
        return status;
    }

    private void searchSettingsToTemplate(SimpleHash templateData) {
        templateData.put("searchenabled", this.sourceManagerSettings.hasSectionEnabled("search"));
        templateData.put("type", (Object)this.sourceManagerSettings.getPrefsString("search", "type"));
        for (String parameterName : this.searchParameters) {
            templateData.put(parameterName, (Object)this.sourceManagerSettings.getPrefsString("search", parameterName));
        }
    }

    private void trimAndSetPref(Map<String, Object> parameters, String section, String name) {
        String value = ((String)parameters.get(name)).trim();
        this.sourceManagerSettings.setPrefs(section, Section.SectionTypes.valueNames, name, value);
    }

    private void protectedSettingsToTemplate(SimpleHash templateData) {
        this.putListValuesToTemplate(templateData, "protected_files", "file");
        this.putListValuesToTemplate(templateData, "protected_dirs", "dir");
    }

    private void cacheSettingsToTemplate(SimpleHash templateData) {
        templateData.put("cacheenabled", this.sourceManagerSettings.hasSectionEnabled("cache"));
        for (String parameterName : this.cacheParameters) {
            templateData.put(parameterName, (Object)this.sourceManagerSettings.getPrefsString("cache", parameterName));
        }
    }

    private int displaySettings(SimpleHash templateData) {
        this.applicationSettingsToTemplate(templateData);
        this.cacheSettingsToTemplate(templateData);
        this.scannerSettingsToTemplate(templateData);
        this.cmsSettingsToTemplate(templateData);
        this.searchSettingsToTemplate(templateData);
        this.protectedSettingsToTemplate(templateData);
        templateData.put("showsettings", true);
        return 200;
    }

    private SimpleSequence getAvailableHTTPAuthenticationMethods() {
        SimpleSequence result = new SimpleSequence();
        SimpleHash method1 = new SimpleHash();
        method1.put("value", (Object)"basic");
        method1.put("description", (Object)"BASIC");
        result.add((Object)method1);
        SimpleHash method2 = new SimpleHash();
        method2.put("value", (Object)"digest");
        method2.put("description", (Object)"DIGEST");
        result.add((Object)method2);
        SimpleHash method3 = new SimpleHash();
        method3.put("value", (Object)"ntlm");
        method3.put("description", (Object)"NTLM");
        result.add((Object)method3);
        return result;
    }
}

