/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions;

import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import com.neptunelabs.fsiserver.sourcemanager.ScannerDaemon;
import com.neptunelabs.fsiserver.sourcemanager.small.ConverterState;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.FileImportJob;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleSequence;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;

public final class SourceManagerStateAction
extends Action {
    public SourceManagerStateAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/sourcemanagerstate.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        templateData.put("queued", (Object)this.sourceManager.getQueuedImages());
        templateData.put("scancount", (Object)this.sourceManager.getScanCount());
        List<ConverterState> importerJobs = this.sourceManager.getCurrentConverterJobs();
        int numberOfCurrentJobs = importerJobs.size();
        templateData.put("currentjobs", (Object)this.buildCurrentJobList(importerJobs));
        templateData.put("recentjobs", (Object)this.buildRecentJobList(this.sourceManager.getRecentConverterJobs()));
        templateData.put("sourcemanager_state", (Object)this.determineSourceManagerState(numberOfCurrentJobs));
        return 200;
    }

    private SimpleSequence buildCurrentJobList(List<ConverterState> importerJobs) {
        SimpleSequence result = new SimpleSequence();
        for (ConverterState cs : importerJobs) {
            SimpleHash jobentry = new SimpleHash();
            jobentry.put("file", (Object)cs.assetURLPath);
            jobentry.put("swap", cs.swap);
            jobentry.put("queuetype", (Object)cs.type);
            if (cs.width > 0 && cs.height > 0) {
                jobentry.put("dimension", (Object)(cs.width + "x" + cs.height));
            } else {
                jobentry.put("dimension", (Object)"unknown");
            }
            result.add((Object)jobentry);
        }
        return result;
    }

    private SimpleSequence buildRecentJobList(List<FileImportJob> recentJobs) {
        SimpleSequence result = new SimpleSequence();
        for (FileImportJob job : recentJobs) {
            SimpleHash jobentry = new SimpleHash();
            jobentry.put("file", (Object)job.assetURLPath);
            jobentry.put("processingtime", (Object)job.processTime);
            jobentry.put("finishtime", (Object)new Date(job.finishTime));
            result.add((Object)jobentry);
        }
        return result;
    }

    private String determineSourceManagerState(int numberOfCurrentJobs) {
        ScannerDaemon.STATE scannerstate = this.sourceManager.getScannerDaemon().getScannerState();
        if (scannerstate == ScannerDaemon.STATE.SCANNING) {
            if (numberOfCurrentJobs > 0) {
                return "scanning & importing";
            }
            return "scanning";
        }
        if (numberOfCurrentJobs > 0) {
            return "importing";
        }
        return "idle";
    }
}

