/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.interfacewebservice.UploadFile;
import com.neptunelabs.fsiservletframework.utils.ServletUtils;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleSequence;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.activation.DataHandler;
import javax.servlet.ServletContext;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class UpdateViewersAction
extends Action {
    public UpdateViewersAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/updateviewers.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else {
            if (parameters.containsKey("viewerToUpdate")) {
                Path workDir = this.sourceManagerSettings.getWorkDirectory();
                if (parameters.containsKey("confirmed")) {
                    Set<Path> targetDirectories = this.getTargetDirectories(parameters);
                    for (Path viewerDir : targetDirectories) {
                        String tmpname = ((String)parameters.get("tmpname")).trim();
                        Path uploadDir = workDir.resolve("viewerupload").resolve(tmpname);
                        this.copyUnzippedFiles(viewerDir, uploadDir);
                    }
                    templateData.put("show_confirmation", true);
                } else {
                    String tmpname = String.valueOf(System.currentTimeMillis());
                    templateData.put("viewerToUpdate", parameters.get("viewerToUpdate"));
                    templateData.put("tmpname", (Object)tmpname);
                    Path uploadDir = workDir.resolve("viewerupload").resolve(tmpname);
                    if (!Files.exists(uploadDir, new LinkOption[0])) {
                        try {
                            Files.createDirectories(uploadDir, new FileAttribute[0]);
                        }
                        catch (IOException ioe) {
                            templateData.put("show_error", true);
                            templateData.put("message", (Object)"Could not create upload directory.");
                        }
                    }
                    Path savedfile = this.saveUploadedFile(files, uploadDir, templateData);
                    this.unzipUpdatePackage(savedfile, uploadDir, templateData);
                    try {
                        Files.deleteIfExists(savedfile);
                    }
                    catch (IOException ioe) {
                        templateData.put("show_error", true);
                        templateData.put("message", (Object)("Temporary " + savedfile.toString() + " files could not be deleted."));
                    }
                    templateData.put("request_confirmation", (Object)"true");
                }
            } else {
                if (parameters.containsKey("preselect_viewer")) {
                    templateData.put("preselect_viewer", parameters.get("preselect_viewer"));
                }
                Set<String> userViewerNames = this.getAllUserViewers();
                SimpleSequence viewerUpdateOptions = this.getAvailableViewerChoices(userViewerNames);
                templateData.put("viewer_update_options", (Object)viewerUpdateOptions);
                SimpleSequence userViewers = new SimpleSequence();
                for (String name : userViewerNames) {
                    SimpleHash sh = new SimpleHash();
                    sh.put("value", (Object)name);
                    sh.put("description", (Object)name);
                    userViewers.add((Object)sh);
                }
                templateData.put("userviewers", (Object)userViewers);
                templateData.put("show_form", true);
            }
            status = 200;
        }
        return status;
    }

    private SimpleSequence getAvailableViewerChoices(Set<String> userViewerNames) {
        SimpleSequence result = new SimpleSequence();
        if (userViewerNames.size() > 0) {
            SimpleHash sh1 = new SimpleHash();
            sh1.put("value", (Object)"all_viewers");
            sh1.put("description", (Object)"All Viewers");
            result.add((Object)sh1);
        }
        SimpleHash sh2 = new SimpleHash();
        sh2.put("value", (Object)"default_viewer");
        sh2.put("description", (Object)"Default Viewer");
        result.add((Object)sh2);
        if (userViewerNames.size() > 0) {
            SimpleHash sh3 = new SimpleHash();
            sh3.put("value", (Object)"specific_viewer");
            sh3.put("description", (Object)"Specific User Viewer");
            result.add((Object)sh3);
        }
        return result;
    }

    private Set<Path> getTargetDirectories(Map<String, Object> parameters) {
        Set<Object> result = new TreeSet();
        if (parameters.get("viewerToUpdate").equals("all_viewers")) {
            Set<String> usernames = this.getAllUserViewers();
            result = this.getUserViewerDirectories(usernames);
            result.add(this.getDefaultViewerDir());
        } else if (parameters.get("viewerToUpdate").equals("default_viewer")) {
            result.add(this.getDefaultViewerDir());
        } else if (parameters.get("viewerToUpdate").equals("specific_viewer")) {
            String username = (String)parameters.get("user");
            TreeSet<String> usernameSet = new TreeSet<String>();
            usernameSet.add(username);
            result = this.getUserViewerDirectories(usernameSet);
        }
        return result;
    }

    private Path getDefaultViewerDir() {
        return ServletUtils.getRealPath(this.sourceManagerSettings.getServletContext(), "viewer");
    }

    private Set<Path> getUserViewerDirectories(Set<String> usernames) {
        TreeSet<Path> result = new TreeSet<Path>();
        Path usersDir = ServletUtils.getRealPath(this.sourceManagerSettings.getServletContext(), "users");
        for (String username : usernames) {
            result.add(usersDir.resolve(username).resolve("viewer"));
        }
        return result;
    }

    private Set<String> getAllUserViewers() {
        TreeSet<String> result = new TreeSet<String>();
        Path usersDir = ServletUtils.getRealPath(this.sourceManagerSettings.getServletContext(), "users");
        try {
            List<PathCached> list = FileOperations.listDirectories(usersDir);
            for (PathCached pc : list) {
                Path viewerDir = pc.getPath().resolve("viewer");
                if (!Files.exists(viewerDir, new LinkOption[0])) continue;
                result.add(pc.getFileName());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private void unzipUpdatePackage(Path savedfile, Path uploadDir, SimpleHash templateData) {
        if (savedfile != null && Files.exists(savedfile, new LinkOption[0])) {
            Path unzipDir = uploadDir.resolve("unzipped");
            this.sourceManagerLogger.log(5012, unzipDir);
            ArrayList<Object> unzippedfiles = new ArrayList<Object>();
            ArrayList<String> filenames = new ArrayList<String>();
            boolean zipBomb = false;
            boolean invalidFiles = false;
            try {
                ZipFile zipFile = new ZipFile(savedfile.toFile());
                Enumeration entries = zipFile.getEntries();
                while (entries.hasMoreElements() && !zipBomb) {
                    ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                    Path destination = unzipDir.resolve(entry.getName());
                    Path path = destination.getParent();
                    try {
                        Files.createDirectories(path, new FileAttribute[0]);
                    }
                    catch (IOException ioe) {
                        this.sourceManagerLogger.log(3199, path.toString());
                    }
                    if (entry.isDirectory()) {
                        try {
                            Files.createDirectory(destination, new FileAttribute[0]);
                        }
                        catch (IOException ioe) {
                            this.sourceManagerLogger.log(3199, destination.toString());
                        }
                        continue;
                    }
                    if (!entry.getName().startsWith("licence")) {
                        filenames.add(entry.getName());
                    }
                    if (entry.getCompressedSize() < entry.getSize() / 15L) {
                        zipBomb = true;
                        break;
                    }
                    BufferedInputStream is = new BufferedInputStream(zipFile.getInputStream(entry));
                    byte[] data = new byte[4096];
                    try (BufferedOutputStream fos = new BufferedOutputStream(Files.newOutputStream(destination, new OpenOption[0]), 4096);){
                        int currentByte;
                        while ((currentByte = is.read(data, 0, 4096)) != -1) {
                            ((OutputStream)fos).write(data, 0, currentByte);
                        }
                    }
                    is.close();
                    FileOperations.setSafeLastModified(destination, entry.getTime());
                    unzippedfiles.add(destination);
                }
                zipFile.close();
                if (zipBomb || invalidFiles) {
                    templateData.put("show_error", true);
                    templateData.put("message", (Object)"Invalid files in zip");
                    boolean allDeleted = true;
                    for (Path path : unzippedfiles) {
                        allDeleted &= Files.deleteIfExists(path);
                    }
                    if (!allDeleted) {
                        this.sourceManagerLogger.log(3235, unzipDir);
                    }
                } else {
                    templateData.put("filelist", filenames);
                    Path licenceFile = unzipDir.resolve("eula.txt");
                    if (Files.exists(licenceFile, new LinkOption[0])) {
                        String eula = FileOperations.getTextFileContent(licenceFile, FileOperations.charsetUTF8);
                        templateData.put("licenceTXT", (Object)eula);
                    }
                    templateData.put("request_confirmation", true);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                templateData.put("show_error", true);
                templateData.put("message", (Object)"The uploaded file could not be unzipped, please check zipfile integrity.");
            }
        }
    }

    private void copyUnzippedFiles(Path viewerDir, Path uploadDir) {
        Path unzipDir = uploadDir.resolve("unzipped");
        Path unzipViewerBase = unzipDir.resolve("viewer");
        if (Files.notExists(unzipViewerBase, new LinkOption[0])) {
            unzipViewerBase = unzipDir;
        }
        this.sourceManagerLogger.log(5014, unzipViewerBase, viewerDir);
        Path licencehtmlFile = unzipViewerBase.resolve("licence.html");
        try {
            Files.deleteIfExists(licencehtmlFile);
        }
        catch (IOException e) {
            this.sourceManagerLogger.logException(e, 3200, licencehtmlFile);
        }
        Path licencetxtFile = unzipViewerBase.resolve("licence.txt");
        try {
            Files.deleteIfExists(licencetxtFile);
        }
        catch (IOException e) {
            this.sourceManagerLogger.logException(e, 3200, licencehtmlFile);
        }
        FileOperations.copyDirectory(this.sourceManagerLogger, unzipViewerBase, viewerDir);
    }

    private Path saveUploadedFile(ListOfFiles files, Path uploadDir, SimpleHash templateData) {
        Path savedfile = null;
        UploadFile[] fileslist = files.getEntry();
        if (fileslist == null || fileslist.length != 1) {
            templateData.put("show_error", true);
            templateData.put("message", (Object)"invalid upload data");
        } else {
            UploadFile uf = fileslist[0];
            DataHandler dh = uf.getData();
            savedfile = uploadDir.resolve(uf.getName());
            this.sourceManagerLogger.log(5011, savedfile);
            try {
                FileOperations.saveStreamToFile(savedfile, dh.getInputStream());
            }
            catch (IOException ioe) {
                templateData.put("show_error", true);
                templateData.put("message", (Object)("Error saving file. " + ioe.getLocalizedMessage()));
            }
        }
        return savedfile;
    }
}

