/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.utils.ServletUtils;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleSequence;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;

public class ViewerSettings
extends Action {
    public ViewerSettings(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/viewersettings.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else {
            if (parameters.containsKey("user")) {
                String user = ((String)parameters.get("user")).trim();
                templateData.put("user", (Object)user);
                Path userViewerDir = ServletUtils.getRealPath(this.sourceManagerSettings.getServletContext(), "users").resolve(user).resolve("viewer");
                Path defaultViewerDir = ServletUtils.getRealPath(this.sourceManagerSettings.getServletContext(), "/viewer");
                if (parameters.containsKey("remove_viewer")) {
                    if (parameters.containsKey("confirmed")) {
                        boolean success = false;
                        try {
                            success = FileOperations.deleteDir(userViewerDir);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (success) {
                            templateData.put("message", (Object)"User FSI Viewer deleted.");
                        } else {
                            templateData.put("message", (Object)"User FSI Viewer could not be deleted, but was disabled.");
                        }
                        templateData.put("show_status", true);
                    } else {
                        templateData.put("request_remove_confirmation", true);
                    }
                } else if (parameters.containsKey("copy_viewer")) {
                    if (FileOperations.copyDirectory(this.sourceManagerLogger, defaultViewerDir, userViewerDir)) {
                        templateData.put("viewerPath", (Object)("users/" + user + "/viewer"));
                        templateData.put("show_created_confirmation", true);
                    } else {
                        templateData.put("message", (Object)"<font color=\"red\">Failed to install user viewer. Please check the directory permissions on the server and try again.</font>");
                    }
                    templateData.put("own_viewer", Files.exists(userViewerDir, new LinkOption[0]));
                    templateData.put("show_status", true);
                } else {
                    templateData.put("own_viewer", Files.exists(userViewerDir, new LinkOption[0]));
                    templateData.put("show_status", true);
                }
            } else if (parameters.containsKey("default")) {
                templateData.put("default", true);
                templateData.put("show_status", true);
            } else {
                SimpleSequence existingViewerList = new SimpleSequence();
                Path usersDir = ServletUtils.getRealPath(this.sourceManagerSettings.getServletContext(), "users");
                try {
                    List<PathCached> list = FileOperations.listAllFiles(usersDir);
                    for (PathCached userdir : list) {
                        Path viewerSubDir = userdir.getPath().resolve("viewer");
                        if (!Files.exists(viewerSubDir, new LinkOption[0])) continue;
                        SimpleHash entry = new SimpleHash();
                        entry.put("value", (Object)userdir.getFileName());
                        entry.put("description", (Object)userdir.getFileName());
                        existingViewerList.add((Object)entry);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                templateData.put("existing_userviewers", (Object)existingViewerList);
                templateData.put("show_chooser", true);
            }
            status = 200;
        }
        return status;
    }
}

