/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.utils.ServletUtils;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletContext;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;

public class ZipViewerAction
extends Action {
    public ZipViewerAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return null;
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        return 0;
    }

    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, Map<String, String> responseHeaders, ByteArrayOutputStream baos) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else {
            Path viewerDir = null;
            if (parameters.containsKey("user")) {
                Path userdir = ServletUtils.getRealPath(this.requestProcessorSettings.getServletContext(), "users").resolve((String)parameters.get("user"));
                viewerDir = userdir.resolve("viewer");
            } else {
                viewerDir = ServletUtils.getRealPath(this.requestProcessorSettings.getServletContext(), "viewer");
            }
            Path workDir = this.requestProcessorSettings.getWebInfPath().resolve("work");
            if (Files.notExists(workDir, new LinkOption[0])) {
                try {
                    Files.createDirectories(workDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    this.sourceManagerLogger.logException(e, 3199, workDir);
                }
            }
            if (Files.exists(workDir, new LinkOption[0])) {
                Path zipfile = workDir.resolve(System.currentTimeMillis() + ".zip");
                try (ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(zipfile, new OpenOption[0])));){
                    this.sourceManagerLogger.log(5010, zipfile);
                    this.addDirToZip(zos, viewerDir, viewerDir);
                    baos.write(FileOperations.readFile(zipfile));
                    responseHeaders.put("Content-Disposition", "viewer.zip");
                    responseHeaders.put("Content-Type", "application/zip");
                    responseHeaders.put("Content-Length", String.valueOf(Files.size(zipfile)));
                    status = 200;
                }
                catch (IOException ioe) {
                    this.sourceManagerLogger.logException(ioe, 3157, "Viewer Zip download", ioe.getLocalizedMessage());
                }
            }
        }
        return status;
    }

    private void addDirToZip(ZipOutputStream zipout, Path baseDir, Path dir) throws IOException {
        List<PathCached> list = FileOperations.listAllFiles(dir);
        for (PathCached f : list) {
            if (!f.isRegularFile()) continue;
            ZipArchiveEntry fileentry = new ZipArchiveEntry(f.getAbsoluteName());
            fileentry.setSize(f.size());
            zipout.putNextEntry((ZipEntry)fileentry);
            zipout.write(FileOperations.readFile(f.getPath()));
            zipout.closeEntry();
        }
        for (PathCached f : list) {
            if (!f.isDirectory()) continue;
            this.addDirToZip(zipout, baseDir, f.getPath());
        }
    }
}

