/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions.groups;

import com.neptunelabs.fsiframework.licensing.Licence;
import com.neptunelabs.fsiserver.authentication.Group;
import com.neptunelabs.fsiserver.fsiadministrator.actions.groups.GroupAction;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.ServletContext;

public class AddGroupAction
extends GroupAction {
    public AddGroupAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/addgroup.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else {
            UserAuthenticationInterface uai = this.getUserAuthenticationInterface();
            if (uai.isUserModificationPossible()) {
                Licence licence = this.sourceManagerSettings.getLicence();
                int groupCount = uai.getGroupCount();
                if (licence.hasLicence() && licence.getMaxUserGroups() != -1 && groupCount >= licence.getMaxUserGroups()) {
                    templateData.put("show_groups_exceeded_message", true);
                } else {
                    templateData.put("available_permissionsets", this.getAvailablePermissionSets(uai));
                    templateData.put("available_propertysets", this.getAvailablePropertySets(uai));
                    if (parameters.get("name") != null) {
                        String groupname = ((String)parameters.get("name")).trim();
                        String permissionset = (String)parameters.get("permissionset");
                        String propertyset = (String)parameters.get("propertyset");
                        Group group = uai.getGroups().get(groupname);
                        if (group != null) {
                            templateData.put("name", (Object)groupname);
                            templateData.put("permissionset", (Object)permissionset);
                            templateData.put("propertyset", (Object)propertyset);
                            templateData.put("show_form", true);
                            templateData.put("message", (Object)"A group of this name already exists. Please choose another name.");
                        } else if (groupname.length() == 0) {
                            templateData.put("message", (Object)"Invalid group name. Please choose a different name.");
                            templateData.put("permissionset", (Object)permissionset);
                            templateData.put("propertyset", (Object)propertyset);
                            templateData.put("show_form", true);
                        } else if (parameters.get("save") != null) {
                            boolean success = uai.addGroup(groupname, new TreeSet<String>(), permissionset, propertyset);
                            if (success) {
                                templateData.put("show_confirmation", true);
                            } else {
                                templateData.put("show_error", true);
                                templateData.put("message", (Object)"Error saving groups. Please check the server log for details.");
                            }
                        }
                    } else {
                        templateData.put("show_form", true);
                    }
                }
            } else {
                templateData.put("ldap_managed_groups", true);
            }
            status = 200;
        }
        return status;
    }
}

