/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions.groups;

import com.neptunelabs.fsiserver.authentication.Group;
import com.neptunelabs.fsiserver.fsiadministrator.actions.groups.GroupAction;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.util.Map;
import javax.servlet.ServletContext;

public class CopyGroupAction
extends GroupAction {
    public CopyGroupAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/copygroup.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else if (parameters.get("name") != null) {
            UserAuthenticationInterface uai = this.getUserAuthenticationInterface();
            String sourcegroupname = ((String)parameters.get("name")).trim();
            Group sourcegroup = uai.getGroups().get(sourcegroupname);
            if (parameters.get("target") != null && ((String)parameters.get("target")).trim().length() > 0) {
                String targetgroupname = ((String)parameters.get("target")).trim();
                if (uai.getGroups().containsKey(targetgroupname)) {
                    templateData.put("name", (Object)sourcegroup.getName());
                    templateData.put("target", (Object)targetgroupname);
                    templateData.put("message", (Object)"A group of that name already exists, please choose another name.");
                    templateData.put("show_from", true);
                } else {
                    boolean success = uai.duplicateGroup(sourcegroupname, targetgroupname);
                    if (success) {
                        templateData.put("show_confirmation", true);
                    } else {
                        templateData.put("show_error", true);
                    }
                }
            } else {
                templateData.put("name", parameters.get("name"));
                templateData.put("show_form", true);
            }
            status = 200;
        }
        return status;
    }
}

