/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions.groups;

import com.neptunelabs.fsiserver.fsiadministrator.actions.groups.GroupAction;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.util.Map;
import javax.servlet.ServletContext;

public class DeleteGroupAction
extends GroupAction {
    public DeleteGroupAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/deletegroup.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else {
            UserAuthenticationInterface uai = this.getUserAuthenticationInterface();
            String groupname = ((String)parameters.get("name")).trim();
            templateData.put("name", (Object)groupname);
            if (!uai.getGroups().containsKey(groupname)) {
                templateData.put("show_error", true);
                templateData.put("message", (Object)"Group not found.");
            } else if (groupname.equals("public") || groupname.equals("users")) {
                templateData.put("show_error", true);
                templateData.put("message", (Object)"System groups 'public' and 'users' can not be deleted.");
            } else if (this.sourceManagerSettings.isGroupInUse(groupname)) {
                templateData.put("show_error", true);
                templateData.put("message", (Object)"Group cannot be deleted. It is currently in use.");
            } else if (parameters.containsKey("confirmed")) {
                boolean success = uai.deleteGroup(groupname);
                if (success) {
                    templateData.put("show_confirmation", true);
                } else {
                    templateData.put("show_error", true);
                    templateData.put("message", (Object)"Error saving groups. Please check the servers log for details.");
                }
            } else {
                templateData.put("request_confirmation", true);
            }
            status = 200;
        }
        return status;
    }
}

