/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions.groups;

import com.neptunelabs.fsiserver.authentication.Group;
import com.neptunelabs.fsiserver.fsiadministrator.actions.groups.GroupAction;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;

public class EditGroupAction
extends GroupAction {
    public EditGroupAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/editgroup.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else if (parameters.get("groupname") != null) {
            UserAuthenticationInterface uai = this.getUserAuthenticationInterface();
            templateData.put("available_permissionsets", this.getAvailablePermissionSets(uai));
            templateData.put("available_propertysets", this.getAvailablePropertySets(uai));
            String groupname = ((String)parameters.get("groupname")).trim();
            templateData.put("groupname", parameters.get("groupname"));
            Group group = uai.getGroups().get(groupname);
            templateData.put("permissionset", (Object)group.getPermissionSet());
            templateData.put("propertyset", (Object)group.getPropertySet());
            if (parameters.get("save") != null) {
                String selectedPropertySet;
                group.getUsers().clear();
                boolean success = true;
                for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                    if (!parameter.getKey().startsWith("user_") || !Boolean.parseBoolean((String)parameter.getValue())) continue;
                    group.getUsers().add(parameter.getKey().substring(5));
                }
                String selectedPermissionSet = (String)parameters.get("permissionset");
                if (selectedPermissionSet != null && selectedPermissionSet.trim().length() > 0) {
                    group.setPermissionSet(selectedPermissionSet);
                }
                if ((selectedPropertySet = (String)parameters.get("propertyset")) != null && selectedPropertySet.trim().length() > 0) {
                    group.setPropertySet(selectedPropertySet);
                }
                if (success &= uai.updateGroup(groupname, group)) {
                    templateData.put("show_confirmation", true);
                } else {
                    templateData.put("show_error", true);
                }
            } else {
                Set<String> users = uai.getUsers();
                SimpleHash tpllist = new SimpleHash();
                for (String user : users) {
                    tpllist.put(user, group.getUsers().contains(user));
                }
                templateData.put("userlist", (Object)tpllist);
                templateData.put("show_form", true);
            }
            status = 200;
        }
        return status;
    }
}

