/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions.groups;

import com.neptunelabs.fsiserver.authentication.Group;
import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import freemarker.template.SimpleHash;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;

abstract class GroupAction
extends Action {
    GroupAction(ServletContext servletContext) {
        super(servletContext);
    }

    static SimpleHash convertGroups(Collection<Group> groups) {
        SimpleHash result = new SimpleHash();
        for (Group g : groups) {
            result.put(g.getName(), (Object)GroupAction.convertGroup(g));
        }
        return result;
    }

    private static SimpleHash convertGroup(Group group) {
        SimpleHash result = new SimpleHash();
        result.put("name", (Object)group.getName());
        result.put("users", group.getUsers());
        return result;
    }

    protected List<Map<String, Object>> getAvailablePermissionSets(UserAuthenticationInterface uai) {
        ArrayList<Map<String, Object>> availables = new ArrayList<Map<String, Object>>();
        HashMap<String, String> emptyEntry = new HashMap<String, String>();
        emptyEntry.put("value", "");
        emptyEntry.put("description", "NONE");
        availables.add(emptyEntry);
        Set<String> setnames = uai.getPermissionSets().keySet();
        for (String setname : setnames) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("value", setname);
            entry.put("description", setname);
            availables.add(entry);
        }
        return availables;
    }

    protected List<Map<String, Object>> getAvailablePropertySets(UserAuthenticationInterface uai) {
        ArrayList<Map<String, Object>> availables = new ArrayList<Map<String, Object>>();
        HashMap<String, String> emptyEntry = new HashMap<String, String>();
        emptyEntry.put("value", "");
        emptyEntry.put("description", "NONE");
        availables.add(emptyEntry);
        Set<String> setnames = uai.getPropertySets().keySet();
        for (String setname : setnames) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("value", setname);
            entry.put("description", setname);
            availables.add(entry);
        }
        return availables;
    }
}

