/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions.permissionsets;

import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.fsiadministrator.actions.permissionsets.PermissionSetAction;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.util.Map;
import javax.servlet.ServletContext;

public class AddPermissionSetAction
extends PermissionSetAction {
    public AddPermissionSetAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/addpermissionset.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else {
            if (parameters.get("name") != null) {
                UserAuthenticationInterface uai = this.getUserAuthenticationInterface();
                String setname = ((String)parameters.get("name")).trim();
                PermissionSet generatedSet = this.createPermissionSetFromParameters(parameters);
                PermissionSet existingSet = uai.getPermissionSets().get(setname);
                if (existingSet != null) {
                    templateData.put("name", (Object)setname);
                    templateData.put("permissionset", (Object)AddPermissionSetAction.convertPermissionSet(generatedSet));
                    templateData.put("show_form", true);
                    templateData.put("message", (Object)"A set of this name already exists. Please choose another name.");
                } else if (parameters.get("save") != null) {
                    if (setname.length() == 0) {
                        templateData.put("permissionset", (Object)AddPermissionSetAction.convertPermissionSet(generatedSet));
                        templateData.put("valueList", this.getAvaiablePermissionValues());
                        templateData.put("show_form", true);
                        templateData.put("message", (Object)"Invalid name for permission set. Please choose another name.");
                    } else {
                        boolean success = uai.addPermissionSet(setname, generatedSet);
                        if (success) {
                            templateData.put("show_confirmation", true);
                        } else {
                            templateData.put("show_error", true);
                            templateData.put("message", (Object)"Error saving permission sets. Please check the server log for details.");
                        }
                    }
                }
            } else {
                PermissionSet ps = new PermissionSet("default");
                templateData.put("permissionset", (Object)AddPermissionSetAction.convertPermissionSet(ps));
                templateData.put("valueList", this.getAvaiablePermissionValues());
                templateData.put("show_form", true);
            }
            status = 200;
        }
        return status;
    }
}

