/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions.permissionsets;

import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.fsiadministrator.actions.permissionsets.PermissionSetAction;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.util.Map;
import javax.servlet.ServletContext;

public class EditPermissionSetAction
extends PermissionSetAction {
    public EditPermissionSetAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/editpermissionset.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else if (parameters.get("name") != null) {
            UserAuthenticationInterface uai = this.getUserAuthenticationInterface();
            if (parameters.get("save") != null) {
                PermissionSet set = this.createPermissionSetFromParameters(parameters);
                boolean success = uai.updatePermissionSet(set.getName(), set);
                if (success) {
                    templateData.put("name", (Object)set.getName());
                    templateData.put("show_confirmation", true);
                } else {
                    templateData.put("name", (Object)set.getName());
                    templateData.put("show_error", true);
                    templateData.put("message", (Object)"Error saving permission sets. Please check the server log for details.");
                }
            } else {
                PermissionSet set = uai.getPermissionSets().get(parameters.get("name"));
                templateData.put("name", (Object)set.getName());
                templateData.put("permissionset", (Object)EditPermissionSetAction.convertPermissionSet(set));
                templateData.put("valueList", this.getAvaiablePermissionValues());
                templateData.put("show_form", true);
            }
            status = 200;
        }
        return status;
    }
}

