/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions.permissionsets;

import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.fsiadministrator.actions.permissionsets.PermissionSetAction;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleSequence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletContext;

public class ListPermissionSetsAction
extends PermissionSetAction {
    public ListPermissionSetsAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/listpermissionsets.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else {
            UserAuthenticationInterface uai = this.getUserAuthenticationInterface();
            Map<String, PermissionSet> permissionSets = uai.getPermissionSets();
            ArrayList<String> nameList = new ArrayList<String>();
            nameList.addAll(permissionSets.keySet());
            Collections.sort(nameList);
            SimpleSequence namesSequence = new SimpleSequence();
            for (String name : nameList) {
                namesSequence.add((Object)name);
            }
            templateData.put("permission_sets", (Object)namesSequence);
            status = 200;
        }
        return status;
    }
}

