/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions.permissionsets;

import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import freemarker.template.SimpleHash;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;

abstract class PermissionSetAction
extends Action {
    PermissionSetAction(ServletContext servletContext) {
        super(servletContext);
    }

    protected PermissionSet createPermissionSetFromParameters(Map<String, Object> parameters) {
        PermissionSet generatedSet = new PermissionSet((String)parameters.get("name"));
        generatedSet.general.changePassword = this.paramToBoolean(parameters.get("general_changePassword"));
        generatedSet.general.writePreferences = this.paramToBoolean(parameters.get("general_writePreferences"));
        generatedSet.general.switchUser = this.paramToBoolean(parameters.get("general_switchUser"));
        generatedSet.general.readLicence = this.paramToBoolean(parameters.get("general_readLicence"));
        generatedSet.general.writeLicence = this.paramToBoolean(parameters.get("general_writeLicence"));
        generatedSet.read.files = this.paramToBoolean(parameters.get("read_files"));
        generatedSet.read.renderedImages = this.paramToBoolean(parameters.get("read_renderedImages"));
        generatedSet.read.basicMetadata = this.paramToBoolean(parameters.get("read_basicMetadata"));
        generatedSet.read.extendedMetadata = this.paramToBoolean(parameters.get("read_extendedMetadata"));
        generatedSet.read.copy = this.paramToBoolean(parameters.get("read_copy"));
        generatedSet.read.downloadSource = this.paramToBoolean(parameters.get("read_downloadSource"));
        generatedSet.read.iccProfiles = this.paramToBoolean(parameters.get("read_iccProfiles"));
        generatedSet.read.storageStatus = this.paramToBoolean(parameters.get("read_storageStatus"));
        generatedSet.read.totalAssetsCount = this.paramToBoolean(parameters.get("read_totalAssetCount"));
        generatedSet.list.files = this.paramToBoolean(parameters.get("list_files"));
        generatedSet.list.directories = this.paramToBoolean(parameters.get("list_directories"));
        generatedSet.list.searchResults = this.paramToBoolean(parameters.get("list_searchResults"));
        generatedSet.list.connector = this.paramToBoolean(parameters.get("list_connector"));
        generatedSet.write.upload = this.paramToBoolean(parameters.get("write_upload"));
        generatedSet.write.createDirectory = this.paramToBoolean(parameters.get("write_createDirectory"));
        generatedSet.write.delete = this.paramToBoolean(parameters.get("write_delete"));
        generatedSet.write.extendedMetadata = this.paramToBoolean(parameters.get("write_extendedMetadata"));
        generatedSet.write.moveToTrash = this.paramToBoolean(parameters.get("write_moveToTrash"));
        generatedSet.write.moveWithinConnector = this.paramToBoolean(parameters.get("write_moveWithinConnector"));
        generatedSet.write.overwrite = this.paramToBoolean(parameters.get("write_overwrite"));
        generatedSet.write.paste = this.paramToBoolean(parameters.get("write_paste"));
        generatedSet.write.rename = this.paramToBoolean(parameters.get("write_rename"));
        generatedSet.tasks.batchRendering = this.paramToBoolean(parameters.get("tasks_batchRendering"));
        generatedSet.tasks.createArchive = this.paramToBoolean(parameters.get("tasks_createArchive"));
        generatedSet.tasks.reimportFiles = this.paramToBoolean(parameters.get("tasks_reimportFiles"));
        return generatedSet;
    }

    private Boolean paramToBoolean(Object parameterValue) {
        if (parameterValue instanceof String) {
            String paramString = (String)parameterValue;
            if (paramString.equals("true")) {
                return Boolean.TRUE;
            }
            if (paramString.equals("false")) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    protected static SimpleHash convertPermissionSet(PermissionSet set) {
        SimpleHash result = new SimpleHash();
        result.put("name", (Object)set.getName());
        result.put("general_changePassword", (Object)(set.general.changePassword == null ? "undefined" : set.general.changePassword.toString()));
        result.put("general_writePreferences", (Object)(set.general.writePreferences == null ? "undefined" : set.general.writePreferences.toString()));
        result.put("general_readLicence", (Object)(set.general.readLicence == null ? "undefined" : set.general.readLicence.toString()));
        result.put("general_writeLicence", (Object)(set.general.writeLicence == null ? "undefined" : set.general.writeLicence.toString()));
        result.put("general_switchUser", (Object)(set.general.switchUser == null ? "undefined" : set.general.switchUser.toString()));
        result.put("read_files", (Object)(set.read.files == null ? "undefined" : set.read.files.toString()));
        result.put("read_renderedImages", (Object)(set.read.renderedImages == null ? "undefined" : set.read.renderedImages.toString()));
        result.put("read_basicMetadata", (Object)(set.read.basicMetadata == null ? "undefined" : set.read.basicMetadata.toString()));
        result.put("read_extendedMetadata", (Object)(set.read.extendedMetadata == null ? "undefined" : set.read.extendedMetadata.toString()));
        result.put("read_copy", (Object)(set.read.copy == null ? "undefined" : set.read.copy.toString()));
        result.put("read_iccProfiles", (Object)(set.read.iccProfiles == null ? "undefined" : set.read.iccProfiles.toString()));
        result.put("read_storageStatus", (Object)(set.read.storageStatus == null ? "undefined" : set.read.storageStatus.toString()));
        result.put("read_downloadSource", (Object)(set.read.downloadSource == null ? "undefined" : set.read.downloadSource.toString()));
        result.put("read_totalAssetCount", (Object)(set.read.totalAssetsCount == null ? "undefined" : set.read.totalAssetsCount.toString()));
        result.put("list_connector", (Object)(set.list.connector == null ? "undefined" : set.list.connector.toString()));
        result.put("list_files", (Object)(set.list.files == null ? "undefined" : set.list.files.toString()));
        result.put("list_directories", (Object)(set.list.directories == null ? "undefined" : set.list.directories.toString()));
        result.put("list_searchResults", (Object)(set.list.searchResults == null ? "undefined" : set.list.searchResults.toString()));
        result.put("write_upload", (Object)(set.write.upload == null ? "undefined" : set.write.upload.toString()));
        result.put("write_createDirectory", (Object)(set.write.createDirectory == null ? "undefined" : set.write.createDirectory.toString()));
        result.put("write_overwrite", (Object)(set.write.overwrite == null ? "undefined" : set.write.overwrite.toString()));
        result.put("write_delete", (Object)(set.write.delete == null ? "undefined" : set.write.delete.toString()));
        result.put("write_extendedMetadata", (Object)(set.write.extendedMetadata == null ? "undefined" : set.write.extendedMetadata.toString()));
        result.put("write_paste", (Object)(set.write.paste == null ? "undefined" : set.write.paste.toString()));
        result.put("write_rename", (Object)(set.write.rename == null ? "undefined" : set.write.rename.toString()));
        result.put("write_moveToTrash", (Object)(set.write.moveToTrash == null ? "undefined" : set.write.moveToTrash.toString()));
        result.put("write_moveWithinConnector", (Object)(set.write.moveWithinConnector == null ? "undefined" : set.write.moveWithinConnector.toString()));
        result.put("tasks_batchRendering", (Object)(set.tasks.batchRendering == null ? "undefined" : set.tasks.batchRendering.toString()));
        result.put("tasks_createArchive", (Object)(set.tasks.createArchive == null ? "undefined" : set.tasks.createArchive.toString()));
        result.put("tasks_reimportFiles", (Object)(set.tasks.reimportFiles == null ? "undefined" : set.tasks.reimportFiles.toString()));
        return result;
    }

    protected SimpleHash convertPermissionSets(Map<String, PermissionSet> permissionSets) {
        SimpleHash result = new SimpleHash();
        for (Map.Entry<String, PermissionSet> entry : permissionSets.entrySet()) {
            result.put(entry.getKey(), (Object)PermissionSetAction.convertPermissionSet(entry.getValue()));
        }
        return result;
    }

    protected List<Map<String, Object>> getAvaiablePermissionValues() {
        ArrayList<Map<String, Object>> availables = new ArrayList<Map<String, Object>>();
        HashMap<String, String> entry1 = new HashMap<String, String>();
        entry1.put("value", "true");
        entry1.put("description", "allowed");
        availables.add(entry1);
        HashMap<String, String> entry2 = new HashMap<String, String>();
        entry2.put("value", "false");
        entry2.put("description", "forbidden");
        availables.add(entry2);
        HashMap<String, String> entry3 = new HashMap<String, String>();
        entry3.put("value", "undefined");
        entry3.put("description", "undefined");
        availables.add(entry3);
        return availables;
    }
}

