/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions.propertysets;

import com.neptunelabs.fsiserver.authentication.PropertySet;
import com.neptunelabs.fsiserver.fsiadministrator.actions.propertysets.PropertySetAction;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.util.Map;
import javax.servlet.ServletContext;

public class CopyPropertySetAction
extends PropertySetAction {
    public CopyPropertySetAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/copypropertyset.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else if (parameters.get("name") != null) {
            UserAuthenticationInterface uai = this.getUserAuthenticationInterface();
            PropertySet sourceset = uai.getPropertySets().get(parameters.get("name"));
            if (parameters.get("target") != null && ((String)parameters.get("target")).trim().length() > 0) {
                String destinationset = (String)parameters.get("target");
                if (uai.getPropertySets().containsKey(destinationset)) {
                    templateData.put("name", (Object)sourceset.getName());
                    templateData.put("target", (Object)destinationset);
                    templateData.put("show_overwrite_request", true);
                } else {
                    PropertySet newSet = new PropertySet(destinationset);
                    boolean success = uai.addPropertySet(destinationset, newSet);
                    if (success) {
                        templateData.put("show_confirmation", true);
                    } else {
                        templateData.put("show_error", true);
                    }
                }
            } else {
                templateData.put("name", parameters.get("name"));
                templateData.put("show_form", true);
            }
            status = 200;
        }
        return status;
    }
}

