/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions.propertysets;

import com.neptunelabs.fsiserver.fsiadministrator.actions.propertysets.PropertySetAction;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.util.Map;
import javax.servlet.ServletContext;

public class DeletePropertySetAction
extends PropertySetAction {
    public DeletePropertySetAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/deletepropertyset.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else {
            UserAuthenticationInterface uai = this.getUserAuthenticationInterface();
            String setname = ((String)parameters.get("name")).trim();
            templateData.put("name", (Object)setname);
            if (!uai.getPropertySets().containsKey(setname)) {
                templateData.put("show_error", true);
                templateData.put("message", (Object)"PropertySet not found.");
            } else if (this.sourceManagerSettings.isPropertySetInUse(setname)) {
                templateData.put("show_error", true);
                templateData.put("message", (Object)"PropertySet cannot be deleted. It is currently in use.");
            } else if (parameters.containsKey("confirmed")) {
                boolean success = uai.deletePropertySet(setname);
                if (success) {
                    templateData.put("show_confirmation", true);
                } else {
                    templateData.put("show_error", true);
                    templateData.put("message", (Object)"Error saving property sets. Please check the servers log for details.");
                }
            } else {
                templateData.put("request_confirmation", true);
            }
            status = 200;
        }
        return status;
    }
}

