/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions.propertysets;

import com.neptunelabs.fsiserver.authentication.PropertySet;
import com.neptunelabs.fsiserver.fsiadministrator.actions.propertysets.PropertySetAction;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.util.Map;
import javax.servlet.ServletContext;

public class EditPropertySetAction
extends PropertySetAction {
    public EditPropertySetAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/editpropertyset.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else {
            UserAuthenticationInterface uai = this.getUserAuthenticationInterface();
            String setname = ((String)parameters.get("name")).trim();
            if (parameters.get("save") != null) {
                PropertySet generatedSet = this.createPropertySetFromParameters(parameters);
                if (parameters.get("save") != null) {
                    templateData.put("propertyset", (Object)EditPropertySetAction.convertPropertySet(generatedSet));
                    if (setname.length() == 0) {
                        templateData.put("valueList", this.getAvaiablePropertyValues());
                        templateData.put("show_form", true);
                        templateData.put("message", (Object)"Invalid name for property set. Please choose another name.");
                    } else {
                        boolean success = uai.addPropertySet(setname, generatedSet);
                        if (success) {
                            templateData.put("show_confirmation", true);
                        } else {
                            templateData.put("show_error", true);
                            templateData.put("message", (Object)"Error saving property sets. Please check the server log for details.");
                        }
                    }
                }
            } else {
                PropertySet existingSet = uai.getPropertySets().get(setname);
                existingSet.setName(setname);
                templateData.put("propertyset", (Object)EditPropertySetAction.convertPropertySet(existingSet));
                templateData.put("valueList", this.getAvaiablePropertyValues());
                templateData.put("show_form", true);
            }
            status = 200;
        }
        return status;
    }
}

