/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions.propertysets;

import com.neptunelabs.fsiserver.authentication.PropertySet;
import com.neptunelabs.fsiserver.fsiadministrator.actions.propertysets.PropertySetAction;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleSequence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletContext;

public class ListPropertySetsAction
extends PropertySetAction {
    public ListPropertySetsAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/listpropertysets.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else {
            UserAuthenticationInterface uai = this.getUserAuthenticationInterface();
            Map<String, PropertySet> propertySets = uai.getPropertySets();
            ArrayList<String> nameList = new ArrayList<String>();
            nameList.addAll(propertySets.keySet());
            Collections.sort(nameList);
            SimpleSequence namesSequence = new SimpleSequence();
            for (String name : nameList) {
                namesSequence.add((Object)name);
            }
            templateData.put("property_sets", (Object)namesSequence);
            status = 200;
        }
        return status;
    }
}

