/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions.propertysets;

import com.neptunelabs.fsiserver.authentication.PropertySet;
import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import freemarker.template.SimpleHash;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;

abstract class PropertySetAction
extends Action {
    PropertySetAction(ServletContext servletContext) {
        super(servletContext);
    }

    protected PropertySet createPropertySetFromParameters(Map<String, Object> parameters) {
        PropertySet generatedSet = new PropertySet((String)parameters.get("name"));
        this.createPropertySetSection(generatedSet.general, "general", parameters);
        this.createPropertySetSection(generatedSet.hideApps, "hideapps", parameters);
        this.createPropertySetSection(generatedSet.hidePublishingTabs, "hidepublishingtabs", parameters);
        this.createPropertySetSection(generatedSet.custommetadatafields, "custommetadatafields", parameters);
        this.createPropertySetSection(generatedSet.publishingsets, "publishingsets", parameters);
        this.createPropertySetSection(generatedSet.custom, "custom", parameters);
        return generatedSet;
    }

    private void createPropertySetSection(List<PropertySet.ItemType> section, String sectionName, Map<String, Object> parameters) {
        for (int i = 1; i <= 20; ++i) {
            String name;
            if (!parameters.containsKey(sectionName + "_name_" + i) || (name = ((String)parameters.get(sectionName + "_name_" + i)).trim()).length() <= 0) continue;
            PropertySet.ItemType item = new PropertySet.ItemType();
            item.name = name;
            item.isProtected = Boolean.valueOf((String)parameters.get(sectionName + "_protected_" + i));
            item.inherit = Boolean.valueOf((String)parameters.get(sectionName + "_inherit_" + i));
            item.value = Boolean.valueOf((String)parameters.get(sectionName + "_value_" + i));
            section.add(item);
        }
    }

    protected static SimpleHash convertPropertySet(PropertySet set) {
        SimpleHash result = new SimpleHash();
        result.put("name", (Object)set.getName());
        SimpleHash generalHash = new SimpleHash();
        for (PropertySet.ItemType itemType : set.general) {
            SimpleHash simpleHash = new SimpleHash();
            simpleHash.put("name", (Object)itemType.name);
            simpleHash.put("protected", itemType.isProtected);
            simpleHash.put("inherit", itemType.inherit);
            simpleHash.put("value", itemType.value);
            generalHash.put(itemType.name, (Object)simpleHash);
        }
        result.put("general", (Object)generalHash);
        SimpleHash hideAppsHash = new SimpleHash();
        for (PropertySet.ItemType itemType : set.hideApps) {
            SimpleHash simpleHash = new SimpleHash();
            simpleHash.put("name", (Object)itemType.name);
            simpleHash.put("protected", itemType.isProtected);
            simpleHash.put("inherit", itemType.inherit);
            simpleHash.put("value", itemType.value);
            hideAppsHash.put(itemType.name, (Object)simpleHash);
        }
        result.put("hideapps", (Object)hideAppsHash);
        SimpleHash simpleHash = new SimpleHash();
        for (PropertySet.ItemType itemType : set.hidePublishingTabs) {
            SimpleHash simpleHash2 = new SimpleHash();
            simpleHash2.put("name", (Object)itemType.name);
            simpleHash2.put("protected", itemType.isProtected);
            simpleHash2.put("inherit", itemType.inherit);
            simpleHash2.put("value", itemType.value);
            simpleHash.put(itemType.name, (Object)simpleHash2);
        }
        result.put("hidepublishingtabs", (Object)simpleHash);
        SimpleHash simpleHash3 = new SimpleHash();
        for (PropertySet.ItemType itemType : set.custommetadatafields) {
            SimpleHash itemHash = new SimpleHash();
            itemHash.put("name", (Object)itemType.name);
            itemHash.put("protected", itemType.isProtected);
            itemHash.put("inherit", itemType.inherit);
            itemHash.put("value", itemType.value);
            simpleHash3.put(itemType.name, (Object)itemHash);
        }
        result.put("custommetadatafields", (Object)simpleHash3);
        SimpleHash simpleHash4 = new SimpleHash();
        for (PropertySet.ItemType item : set.publishingsets) {
            SimpleHash itemHash = new SimpleHash();
            itemHash.put("name", (Object)item.name);
            itemHash.put("protected", item.isProtected);
            itemHash.put("inherit", item.inherit);
            itemHash.put("value", item.value);
            simpleHash4.put(item.name, (Object)itemHash);
        }
        result.put("publishingsets", (Object)simpleHash4);
        SimpleHash simpleHash5 = new SimpleHash();
        for (PropertySet.ItemType item : set.custom) {
            SimpleHash itemHash = new SimpleHash();
            itemHash.put("name", (Object)item.name);
            itemHash.put("protected", item.isProtected);
            itemHash.put("inherit", item.inherit);
            itemHash.put("value", item.value);
            simpleHash5.put(item.name, (Object)itemHash);
        }
        result.put("custom", (Object)simpleHash5);
        return result;
    }

    protected List<Map<String, Object>> getAvaiablePropertyValues() {
        ArrayList<Map<String, Object>> availables = new ArrayList<Map<String, Object>>();
        HashMap<String, String> entry1 = new HashMap<String, String>();
        entry1.put("value", "true");
        entry1.put("description", "true");
        availables.add(entry1);
        HashMap<String, String> entry2 = new HashMap<String, String>();
        entry2.put("value", "false");
        entry2.put("description", "false");
        availables.add(entry2);
        HashMap<String, String> entry3 = new HashMap<String, String>();
        entry3.put("value", "undefined");
        entry3.put("description", "undefined");
        availables.add(entry3);
        return availables;
    }
}

