/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions.publishingsets;

import com.neptunelabs.fsiserver.authentication.PublishingSet;
import com.neptunelabs.fsiserver.fsiadministrator.actions.publishingsets.PublishingSetAction;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.util.Map;
import javax.servlet.ServletContext;

public class AddPublishingSetAction
extends PublishingSetAction {
    public AddPublishingSetAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/addpublishingset.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else {
            if (parameters.get("name") != null) {
                UserAuthenticationInterface uai = this.getUserAuthenticationInterface();
                String setname = ((String)parameters.get("name")).trim();
                PublishingSet generatedSet = this.createPublishingSetFromParameters(parameters);
                PublishingSet existingSet = uai.getPublishingSets().get(setname);
                if (existingSet != null) {
                    templateData.put("name", (Object)setname);
                    templateData.put("publishingset", (Object)AddPublishingSetAction.convertPublishingSet(generatedSet));
                    templateData.put("show_form", true);
                    templateData.put("message", (Object)"A set of this name already exists. Please choose another name.");
                } else if (parameters.get("save") != null) {
                    if (setname.length() == 0) {
                        templateData.put("publishingset", (Object)AddPublishingSetAction.convertPublishingSet(generatedSet));
                        templateData.put("show_form", true);
                        templateData.put("message", (Object)"Invalid name for publishing set. Please choose another name.");
                    } else {
                        boolean success = uai.addPublishingSet(generatedSet);
                        if (success) {
                            templateData.put("show_confirmation", true);
                        } else {
                            templateData.put("show_error", true);
                            templateData.put("message", (Object)"Error saving publishing sets. Please check the server log for details.");
                        }
                    }
                }
            } else {
                PublishingSet ps = new PublishingSet("");
                if (parameters.get("viewerPath") != null) {
                    ps.viewerpath = new PublishingSet.ValueType();
                    ps.viewerpath.value = (String)parameters.get("viewerPath");
                }
                templateData.put("publishingset", (Object)AddPublishingSetAction.convertPublishingSet(ps));
                templateData.put("show_form", true);
            }
            status = 200;
        }
        return status;
    }
}

