/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions.publishingsets;

import com.neptunelabs.fsiserver.authentication.PublishingSet;
import com.neptunelabs.fsiserver.fsiadministrator.actions.publishingsets.PublishingSetAction;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.util.Map;
import javax.servlet.ServletContext;

public class EditPublishingSetAction
extends PublishingSetAction {
    public EditPublishingSetAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/editpublishingset.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else {
            UserAuthenticationInterface uai = this.getUserAuthenticationInterface();
            String setname = ((String)parameters.get("name")).trim();
            if (parameters.get("save") != null) {
                PublishingSet generatedSet = this.createPublishingSetFromParameters(parameters);
                if (parameters.get("save") != null) {
                    templateData.put("publishingset", (Object)EditPublishingSetAction.convertPublishingSet(generatedSet));
                    if (setname.length() == 0) {
                        templateData.put("show_form", true);
                        templateData.put("message", (Object)"Invalid name for property set. Please choose another name.");
                    } else {
                        boolean success = uai.addPublishingSet(generatedSet);
                        if (success) {
                            templateData.put("show_confirmation", true);
                        } else {
                            templateData.put("show_error", true);
                            templateData.put("message", (Object)"Error saving property sets. Please check the server log for details.");
                        }
                    }
                }
            } else {
                PublishingSet existingSet = uai.getPublishingSets().get(setname);
                templateData.put("publishingset", (Object)EditPublishingSetAction.convertPublishingSet(existingSet));
                templateData.put("show_form", true);
            }
            status = 200;
        }
        return status;
    }
}

