/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions.skins;

import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.utils.ServletUtils;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import javax.servlet.ServletContext;

public class DeleteSkinAction
extends Action {
    public DeleteSkinAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/deleteskin.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else {
            String tempname;
            Path viewerDir;
            if (parameters.containsKey("user")) {
                String user = ((String)parameters.get("user")).trim();
                templateData.put("user", (Object)user);
                Path userdir = ServletUtils.getRealPath(this.sourceManagerSettings.getServletContext(), "/users").resolve(user);
                viewerDir = userdir.resolve("viewer");
            } else {
                viewerDir = ServletUtils.getRealPath(this.sourceManagerSettings.getServletContext(), "/viewer");
            }
            Path skinDir = viewerDir.resolve("skins");
            Path pagesSkinDir = skinDir.resolve("pages");
            String skinname = null;
            if (parameters.containsKey("skinname") && parameters.get("skinname") instanceof String && !(tempname = (String)parameters.get("skinname")).contains("/") && !tempname.contains("\\")) {
                skinname = tempname;
            }
            if (skinname == null) {
                templateData.put("show_error", true);
                templateData.put("message", (Object)"Invalid skin name.");
            } else {
                Path skinFile = skinDir.resolve(skinname + ".swf");
                Path introFile = skinDir.resolve("intro_" + skinname + ".swf");
                Path pagesSkinFile = pagesSkinDir.resolve(skinname + ".swf");
                if (!(Files.exists(skinFile, new LinkOption[0]) || Files.exists(introFile, new LinkOption[0]) || Files.exists(pagesSkinFile, new LinkOption[0]))) {
                    templateData.put("show_error", true);
                    templateData.put("message", (Object)"Skin not found.");
                } else {
                    templateData.put("skinname", (Object)skinname);
                    if (parameters.containsKey("confirmed")) {
                        boolean allDeleted = true;
                        try {
                            if (Files.exists(skinFile, new LinkOption[0])) {
                                allDeleted &= Files.deleteIfExists(skinFile);
                            }
                            if (Files.exists(introFile, new LinkOption[0])) {
                                allDeleted &= Files.deleteIfExists(introFile);
                            }
                            if (Files.exists(pagesSkinFile, new LinkOption[0])) {
                                allDeleted &= Files.deleteIfExists(pagesSkinFile);
                            }
                        }
                        catch (IOException e) {
                            allDeleted = false;
                        }
                        templateData.put("all_deleted", allDeleted);
                        templateData.put("show_confirmation", true);
                    } else {
                        templateData.put("request_confirmation", true);
                    }
                }
            }
            status = 200;
        }
        return status;
    }
}

