/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions.skins;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.interfacewebservice.UploadFile;
import com.neptunelabs.fsiservletframework.utils.ServletUtils;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import javax.activation.DataHandler;
import javax.servlet.ServletContext;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class UploadSkinAction
extends Action {
    public UploadSkinAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/uploadskin.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else {
            String tmpname;
            Path viewerDir;
            if (parameters.containsKey("user")) {
                String user = ((String)parameters.get("user")).trim();
                templateData.put("user", (Object)user);
                Path userdir = ServletUtils.getRealPath(this.sourceManagerSettings.getServletContext(), "users").resolve(user);
                viewerDir = userdir.resolve("viewer");
            } else {
                viewerDir = ServletUtils.getRealPath(this.sourceManagerSettings.getServletContext(), "viewer");
            }
            Path workDir = this.sourceManagerSettings.getWorkDirectory();
            if (parameters.containsKey("confirmed")) {
                tmpname = ((String)parameters.get("tmpname")).trim();
                Path uploadDir = workDir.resolve("skinupload").resolve(tmpname);
                this.moveUnzippedFiles(viewerDir, uploadDir);
                templateData.put("show_confirmation", true);
            } else {
                tmpname = String.valueOf(System.currentTimeMillis());
                templateData.put("tmpname", (Object)tmpname);
                Path uploadDir = workDir.resolve("skinupload").resolve(tmpname);
                if (!Files.exists(uploadDir, new LinkOption[0])) {
                    try {
                        Files.createDirectories(uploadDir, new FileAttribute[0]);
                    }
                    catch (IOException ioe) {
                        templateData.put("show_error", true);
                        templateData.put("message", (Object)"Could not create upload directory.");
                    }
                }
                Path savedfile = this.saveUploadedFile(files, uploadDir, templateData);
                this.unzipSkins(savedfile, uploadDir, templateData);
                try {
                    Files.deleteIfExists(savedfile);
                }
                catch (IOException e) {
                    templateData.put("show_error", true);
                    templateData.put("message", (Object)("Temporary " + savedfile.toString() + " files could not be deleted."));
                }
            }
            status = 200;
        }
        return status;
    }

    private void unzipSkins(Path savedfile, Path uploadDir, SimpleHash templateData) {
        if (savedfile != null && Files.exists(savedfile, new LinkOption[0])) {
            Path unzipDir = uploadDir.resolve("unzipped");
            this.sourceManagerLogger.log(5012, unzipDir);
            ArrayList<Object> unzippedfiles = new ArrayList<Object>();
            ArrayList<String> filenames = new ArrayList<String>();
            boolean zipBomb = false;
            boolean invalidFiles = false;
            try {
                ZipFile zipFile = new ZipFile(savedfile.toFile());
                Enumeration entries = zipFile.getEntries();
                while (entries.hasMoreElements() && !zipBomb) {
                    ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                    Path destination = unzipDir.resolve(entry.getName());
                    Path path = destination.getParent();
                    try {
                        Files.createDirectories(path, new FileAttribute[0]);
                    }
                    catch (IOException ioe) {
                        this.sourceManagerLogger.log(3199, path.toString());
                    }
                    if (entry.isDirectory()) {
                        try {
                            Files.createDirectory(destination, new FileAttribute[0]);
                        }
                        catch (IOException ioe) {
                            this.sourceManagerLogger.log(3199, destination.toString());
                        }
                        continue;
                    }
                    if (!entry.getName().startsWith("licence")) {
                        filenames.add(entry.getName());
                    }
                    if (entry.getCompressedSize() < entry.getSize() / 15L) {
                        zipBomb = true;
                        break;
                    }
                    BufferedInputStream is = new BufferedInputStream(zipFile.getInputStream(entry));
                    byte[] data = new byte[4096];
                    try (BufferedOutputStream fos = new BufferedOutputStream(Files.newOutputStream(destination, new OpenOption[0]), 4096);){
                        int currentByte;
                        while ((currentByte = is.read(data, 0, 4096)) != -1) {
                            ((OutputStream)fos).write(data, 0, currentByte);
                        }
                    }
                    is.close();
                    FileOperations.setSafeLastModified(destination, entry.getTime());
                    unzippedfiles.add(destination);
                }
                zipFile.close();
                if (zipBomb) {
                    templateData.put("show_error", true);
                    templateData.put("message", (Object)"Invalid files in zip");
                    boolean allDeleted = true;
                    for (Path path : unzippedfiles) {
                        allDeleted &= Files.deleteIfExists(path);
                    }
                    if (!allDeleted) {
                        this.sourceManagerLogger.log(3235, unzipDir);
                    }
                } else {
                    templateData.put("filelist", filenames);
                    Path licenceFile = unzipDir.resolve("licence.html");
                    if (Files.exists(licenceFile, new LinkOption[0])) {
                        String html = FileOperations.getTextFileContent(licenceFile, FileOperations.charsetUTF8);
                        templateData.put("licenceHTML", (Object)html);
                    } else {
                        licenceFile = unzipDir.resolve("licence.txt");
                        if (Files.exists(licenceFile, new LinkOption[0])) {
                            String text = FileOperations.getTextFileContent(licenceFile, FileOperations.charsetUTF8);
                            templateData.put("licenceTXT", (Object)text);
                        }
                    }
                    templateData.put("request_confirmation", true);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                templateData.put("show_error", true);
                templateData.put("message", (Object)"The uploaded file could not be unzipped, please check zipfile integrity.");
            }
        }
    }

    private void moveUnzippedFiles(Path viewerDir, Path uploadDir) {
        Path tmpSkins;
        Path unzipDir = uploadDir.resolve("unzipped");
        Path skinsDir = viewerDir.resolve("skins");
        this.sourceManagerLogger.log(5013, unzipDir, skinsDir);
        Path unzipSkinsBase = unzipDir.resolve("viewer");
        if (!Files.exists(unzipSkinsBase, new LinkOption[0])) {
            unzipSkinsBase = unzipDir;
        }
        if (Files.exists(tmpSkins = unzipSkinsBase.resolve("skins"), new LinkOption[0])) {
            unzipSkinsBase = tmpSkins;
        }
        Path licencehtmlFile = unzipSkinsBase.resolve("licence.html");
        try {
            Files.deleteIfExists(licencehtmlFile);
        }
        catch (IOException e) {
            this.sourceManagerLogger.log(3200, licencehtmlFile);
        }
        Path licencetxtFile = unzipSkinsBase.resolve("licence.txt");
        try {
            Files.deleteIfExists(licencetxtFile);
        }
        catch (IOException ioe) {
            this.sourceManagerLogger.log(3200, licencetxtFile);
        }
        FileOperations.copyDirectory(this.sourceManagerLogger, unzipSkinsBase, skinsDir);
        try {
            FileOperations.deleteDir(unzipDir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Path saveUploadedFile(ListOfFiles files, Path uploadDir, SimpleHash templateData) {
        Path savedfile = null;
        UploadFile[] fileslist = files.getEntry();
        if (fileslist == null || fileslist.length != 1) {
            templateData.put("show_error", true);
            templateData.put("message", (Object)"invalid upload data");
        } else {
            UploadFile uf = fileslist[0];
            DataHandler dh = uf.getData();
            savedfile = uploadDir.resolve(uf.getName());
            this.sourceManagerLogger.log(5011, savedfile);
            try {
                FileOperations.saveStreamToFile(savedfile, dh.getInputStream());
            }
            catch (IOException ioe) {
                templateData.put("show_error", true);
                templateData.put("message", (Object)("Error saving file. " + ioe.getLocalizedMessage()));
            }
        }
        return savedfile;
    }
}

