/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions.users;

import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.util.Map;
import javax.servlet.ServletContext;

public class ChangePasswordAction
extends Action {
    public ChangePasswordAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/changepassword.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else {
            if (parameters.get("username") == null || ((String)parameters.get("username")).trim().length() == 0) {
                templateData.put("show_error", true);
                templateData.put("message", (Object)"Error: No user selected.");
            } else {
                UserAuthenticationInterface uai = this.getUserAuthenticationInterface();
                String username = ((String)parameters.get("username")).trim();
                templateData.put("username", (Object)username);
                if (!uai.getUsers().contains(username)) {
                    templateData.put("show_error", true);
                    templateData.put("message", (Object)"Error: Unknown user.");
                } else if (uai.isKerberosAuthenticationEnabled()) {
                    templateData.put("show_kerberosmessage", true);
                } else if (parameters.containsKey("pwd1")) {
                    String pwd1 = ((String)parameters.get("pwd1")).trim();
                    String pwd2 = ((String)parameters.get("pwd2")).trim();
                    if (pwd1.length() == 0 || !pwd1.equals(pwd2)) {
                        templateData.put("show_form", true);
                        templateData.put("message", (Object)"The passwords did not match. Please try again.");
                    } else if (uai.setUserPassword(username, pwd1)) {
                        templateData.put("show_confirmation", true);
                    } else {
                        templateData.put("show_error", true);
                        templateData.put("message", (Object)"Error saving the new password.");
                    }
                } else {
                    templateData.put("show_form", true);
                }
            }
            status = 200;
        }
        return status;
    }
}

