/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.fsiadministrator.actions.users;

import com.neptunelabs.fsiserver.authentication.Group;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.fsiadministrator.actions.Action;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.webinterface.AuthorizationLevel;
import freemarker.template.SimpleHash;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;

public class DeleteUserAction
extends Action {
    public DeleteUserAction(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public String getTemplateName() {
        return "actions/deleteuser.ftl";
    }

    @Override
    public int perform(Map<String, Object> parameters, Map<String, String> sessionData, ListOfFiles files, Map<String, String> responseHeaders, Map<String, String> responseSessionData, SimpleHash templateData) {
        int status = 500;
        if (sessionData.get("authorization") == null || Integer.parseInt(sessionData.get("authorization_int")) < AuthorizationLevel.AppAdmin.ordinal()) {
            status = 403;
        } else {
            UserAuthenticationInterface uai = this.getUserAuthenticationInterface();
            String username = ((String)parameters.get("username")).trim();
            if (uai.getUsers().contains(username)) {
                if (parameters.containsKey("confirmed")) {
                    boolean userGroupAssignmentDeleted = uai.removeUserGroupAssignment("authenticated", username);
                    boolean userDeleted = uai.deleteUser(username);
                    boolean requestedGroupsDeleted = false;
                    boolean requestedConnectorsDeleted = false;
                    if (parameters.containsKey("deletegroupsandconnectors") && parameters.get("deletegroupsandconnectors").equals("true")) {
                        templateData.put("restart_required", true);
                        Set<String> staleGroups = this.getStaleGroups(username);
                        Set<String> staleConnectors = this.getStaleSourceConnectors(staleGroups);
                        TreeSet<String> notDeletedGroups = new TreeSet<String>();
                        for (String group : staleGroups) {
                            if (uai.deleteGroup(group)) continue;
                            notDeletedGroups.add(group);
                        }
                        if (notDeletedGroups.size() == 0) {
                            requestedGroupsDeleted = true;
                        }
                        TreeSet<String> notDeletedConnectors = new TreeSet<String>();
                        for (String connectorName : staleConnectors) {
                            Path f = this.sourceManagerSettings.getSourceConnectorPath().resolve(connectorName + ".xml");
                            try {
                                Files.delete(f);
                            }
                            catch (IOException ioe) {
                                notDeletedConnectors.add(connectorName);
                            }
                        }
                        if (notDeletedConnectors.size() == 0) {
                            requestedConnectorsDeleted = true;
                        }
                    } else {
                        requestedGroupsDeleted = true;
                        requestedConnectorsDeleted = true;
                    }
                    if (!(userGroupAssignmentDeleted && userDeleted && requestedGroupsDeleted && requestedConnectorsDeleted)) {
                        templateData.put("message", (Object)"Not all groups or connectors could be deleted, please check the configuration files manually.");
                        templateData.put("show_error", true);
                    } else {
                        templateData.put("show_confirmation", true);
                    }
                } else {
                    Set<String> staleGroups = this.getStaleGroups(username);
                    Set<String> staleSourceConnectors = this.getStaleSourceConnectors(staleGroups);
                    templateData.put("stale_groups", staleGroups);
                    templateData.put("stale_sourceconnectors", staleSourceConnectors);
                    templateData.put("request_confirmation", true);
                }
                templateData.put("username", (Object)username);
                status = 200;
            } else {
                status = 404;
            }
        }
        return status;
    }

    private Set<String> getStaleGroups(String username) {
        UserAuthenticationInterface uai = this.getUserAuthenticationInterface();
        TreeSet<String> staleGroups = new TreeSet<String>();
        for (Map.Entry<String, Group> entry : uai.getGroups().entrySet()) {
            Group g = entry.getValue();
            Set<String> groupUsers = g.getUsers();
            if (groupUsers.size() != 1 || !groupUsers.contains(username)) continue;
            staleGroups.add(entry.getKey());
        }
        return staleGroups;
    }

    private Set<String> getStaleSourceConnectors(Set<String> staleGroups) {
        TreeSet<String> staleConnectors = new TreeSet<String>();
        Map<String, SourceConnectorReader> allConnectors = this.sourceManagerSettings.getAllConnectors();
        for (Map.Entry<String, SourceConnectorReader> ipentry : allConnectors.entrySet()) {
            Map<Group, PermissionSet> pm = ipentry.getValue().getAccessPermissions();
            if (pm.size() > 2) continue;
            String gname = null;
            for (Group g : pm.keySet()) {
                if (g.getName().equalsIgnoreCase("public")) continue;
                gname = g.getName();
            }
            if (gname == null || !staleGroups.contains(gname)) continue;
            staleConnectors.add(ipentry.getKey());
        }
        return staleConnectors;
    }
}

