/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imageloader;

import com.neptunelabs.fsiframework.cache.CacheKey;
import com.neptunelabs.fsiframework.cache.CacheLoad;
import com.neptunelabs.fsiframework.cache.CacheType;
import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiserver.imageloader.ImageBuilderConfigs;
import com.neptunelabs.fsiserver.imageloader.ImageBuilderMultiResolution;
import com.neptunelabs.fsiserver.imageloader.ImageBuilderPrivateEIS;
import com.neptunelabs.fsiserver.imageloader.ImageBuilderStatic;
import com.neptunelabs.fsiserver.imageloader.ImageBuilderV1001;
import com.neptunelabs.fsiserver.imageloader.ImageBuilderV1002;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.EISReader;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.NotImportedException;
import com.neptunelabs.fsiserver.utils.PoolList;
import com.neptunelabs.fsiserver.utils.PoolListSummary;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.custommetadata.CustomMetaDataFileReader;
import com.neptunelabs.fsiserver.utils.metadata.DirectoryMetaData;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import com.neptunelabs.imagemanipulator.helper.FSIInterpolation;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import com.neptunelabs.imagereader.pyramidreader.FlatImageException;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpSession;

public class ImageBuilder {
    private final ImageBuilderV1001 builder1001;
    private final ImageBuilderV1002 builder1002;
    private final ImageBuilderMultiResolution builderMultiRes;
    private final ImageBuilderStatic builderStatic;
    private final ImageBuilderPrivateEIS builderPrivate;
    private final ImageBuilderConfigs builderConfigs;
    private final FSIServerSettings settings;

    public ImageBuilder(FSIServerSettings settings, SwapPool swapPool, CopyOnWriteArrayList<String> tileProcessList, Path storageLocation) {
        this.settings = settings;
        this.builder1001 = new ImageBuilderV1001(settings, swapPool, tileProcessList, storageLocation);
        this.builder1002 = new ImageBuilderV1002(settings, swapPool, tileProcessList);
        this.builderMultiRes = new ImageBuilderMultiResolution(settings, swapPool, tileProcessList);
        this.builderStatic = new ImageBuilderStatic(settings, swapPool);
        this.builderPrivate = new ImageBuilderPrivateEIS(settings, swapPool, tileProcessList);
        this.builderConfigs = new ImageBuilderConfigs(settings, swapPool);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MetaData getImageMetaData(SourceConnectorReader connector, String assetURLPath, int readFlags, boolean closeReader, HttpSession session) throws NoSuchFileException, IOException, NotConfiguredException {
        MetaData result = null;
        boolean useCacheAndCustomMetadata = !assetURLPath.startsWith("_configs") && !assetURLPath.startsWith("_viewers");
        CacheKey cacheKey = null;
        if (useCacheAndCustomMetadata) {
            cacheKey = CacheKey.getInstance(assetURLPath, 'A', "ImageMetaData-" + readFlags);
            CacheLoad cl = this.settings.getCacheManager().get(cacheKey, CacheType.METADATA);
            if (cl != null) {
                result = cl.requestedL1Object != null ? (MetaData)cl.requestedL1Object : MetaData.unpack(cl.data);
            }
            if (result != null) {
                result.setAssetURLPath(assetURLPath);
            }
        }
        if (result == null) {
            if (connector == null) {
                result = this.builderPrivate.getImageMetaData(assetURLPath);
                result.setAssetURLPath(assetURLPath);
            } else if (connector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE || connector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGEAPI) {
                try {
                    ImageMetaData imd = this.builder1002.getImageMetaData(assetURLPath, readFlags, closeReader);
                    if (this.settings.isMigrationModeEnabled() && imd != null && imd.getImportStatus() != 1) {
                        imd = this.builder1001.getImageMetaData(assetURLPath, readFlags);
                        result = imd;
                    }
                    if (result == null) {
                        result = imd;
                    }
                }
                catch (NoSuchFileException e) {
                    if (!this.settings.isMigrationModeEnabled()) throw e;
                    result = this.builder1001.getImageMetaData(assetURLPath, readFlags);
                }
            } else if (connector.getMountType() == SourceConnectorReader.SourceConnectorType.MULTIRESOLUTION) {
                boolean deepScan = true;
                result = this.builderMultiRes.getImageMetaData(connector.getSourceFileFromAssetURLPath(assetURLPath), true);
                result.setAssetURLPath(assetURLPath);
            } else if (connector.getMountType() == SourceConnectorReader.SourceConnectorType.STATIC) {
                result = assetURLPath.startsWith("_configs") || assetURLPath.startsWith("_viewers") ? this.builderConfigs.getImageMetaData(assetURLPath, session) : this.builderStatic.getImageMetaData(connector.getSourceFileFromAssetURLPath(assetURLPath));
                result.setAssetURLPath(assetURLPath);
            }
            if (useCacheAndCustomMetadata) {
                this.settings.getCacheManager().put(cacheKey, result, true);
            }
        }
        if (!useCacheAndCustomMetadata) return result;
        if (result == null) return result;
        if (readFlags == 0) return result;
        Path cmdFile = this.settings.getMetaDataLocation().resolve(assetURLPath + ".meta");
        if (!Files.exists(cmdFile, new LinkOption[0])) return result;
        try {
            CustomMetaDataFileReader reader = new CustomMetaDataFileReader(this.settings, cmdFile);
            Map<String, String> customMetaData = reader.getDataSet();
            result.setCustomMetaData(customMetaData);
            return result;
        }
        catch (NoSuchFileException reader) {
            return result;
        }
        catch (IOException e) {
            this.settings.getFSILogger().logException(e, 3253, cmdFile);
        }
        return result;
    }

    public DirectoryMetaData getDirectoryMetaData(String assetURLPath) {
        return this.builder1002.getDummyDirectoryMetaData(assetURLPath);
    }

    public DirectoryMetaData getDirectoryMetaData(SourceConnectorReader connector, String assetURLPath, PathCached sourceFile, int readFlags) throws NoSuchFileException, IOException, NotConfiguredException {
        Path cmdFile;
        DirectoryMetaData result = null;
        if (connector == null || connector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE || connector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGEAPI) {
            try {
                result = this.builder1002.getDirectoryMetaData(assetURLPath);
            }
            catch (NoSuchFileException e) {
                if (this.settings.isMigrationModeEnabled()) {
                    result = this.builder1001.getDirectoryMetaData(assetURLPath);
                }
                throw e;
            }
        } else {
            result = new DirectoryMetaData();
            result.setAssetURLPath(assetURLPath);
            result.setLastModified(sourceFile.lastModified());
            int fileCounter = 0;
            int dirCounter = 0;
            try (DirectoryStream<Path> stream2 = Files.newDirectoryStream(sourceFile.getPath());){
                for (Path entry : stream2) {
                    if (Files.isDirectory(entry, new LinkOption[0])) {
                        ++dirCounter;
                        continue;
                    }
                    ++fileCounter;
                }
            }
            catch (DirectoryIteratorException stream2) {
                // empty catch block
            }
            result.setFiles(fileCounter);
            result.setSubdirectories(dirCounter);
        }
        if (result != null && readFlags != 0 && Files.exists(cmdFile = this.settings.getMetaDataLocation().resolve(assetURLPath + ".meta"), new LinkOption[0])) {
            try {
                CustomMetaDataFileReader reader = new CustomMetaDataFileReader(this.settings, cmdFile);
                Map<String, String> customMetaData = reader.getDataSet();
                result.setCustomMetaData(customMetaData);
            }
            catch (NoSuchFileException reader) {
            }
            catch (IOException e) {
                this.settings.getFSILogger().logException(e, 3253, cmdFile);
            }
        }
        return result;
    }

    public PoolListSummary getPoolListSummary(SourceConnectorReader connector, String assetURLPath, HttpSession session) throws NoSuchFileException, IOException, NotConfiguredException {
        PoolListSummary result = null;
        if (connector != null && connector.getMountType() == SourceConnectorReader.SourceConnectorType.MULTIRESOLUTION) {
            result = this.builderMultiRes.getPoolListSummary(connector.getSourceFileFromAssetURLPath(assetURLPath));
        } else if (connector != null && connector.getMountType() == SourceConnectorReader.SourceConnectorType.STATIC) {
            if (assetURLPath.startsWith("_configs") || assetURLPath.startsWith("_viewers")) {
                PoolList pl = this.builderConfigs.getPoolList(assetURLPath, session);
                result = new PoolListSummary(pl.lastmodified, pl.getFileCount(), pl.getDirectoryCount());
            } else {
                result = this.builderStatic.getPoolListSummary(connector.getSourceFileFromAssetURLPath(assetURLPath));
            }
        } else if (connector == null || connector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE || connector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGEAPI) {
            PoolList pl = null;
            try {
                pl = this.builder1002.getPoolList(assetURLPath);
            }
            catch (NoSuchFileException e) {
                pl = this.builder1002.getPoolList(assetURLPath);
            }
            if (pl != null) {
                result = pl.getSummary();
            }
        }
        return result;
    }

    public PoolList getPoolList(SourceConnectorReader connector, String assetURLPath, HttpSession session) throws NoSuchFileException, IOException, NotConfiguredException {
        if (connector != null && connector.getMountType() == SourceConnectorReader.SourceConnectorType.MULTIRESOLUTION) {
            return this.builderMultiRes.getPoolList(assetURLPath, connector.getSourceFileFromAssetURLPath(assetURLPath).getPath());
        }
        if (connector != null && connector.getMountType() == SourceConnectorReader.SourceConnectorType.STATIC) {
            if (assetURLPath.startsWith("_configs") || assetURLPath.startsWith("_viewers")) {
                return this.builderConfigs.getPoolList(assetURLPath, session);
            }
            return this.builderStatic.getPoolList(connector.getSourceFileFromAssetURLPath(assetURLPath).getPath(), assetURLPath);
        }
        if (connector == null || connector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE || connector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGEAPI) {
            try {
                return this.builder1002.getPoolList(assetURLPath);
            }
            catch (NoSuchFileException e) {
                if (this.settings.isMigrationModeEnabled()) {
                    return this.builder1001.getPoolList(assetURLPath);
                }
                throw e;
            }
        }
        return null;
    }

    public FSIImageLimited getImagePixelBased(EISReader preUsedReader, SourceConnectorReader connector, int priority, String assetURLPath, int referenceWidth, int referenceHeight, int leftPix, int topPix, int rangeWidthPix, int rangeHeightPix, boolean keepAspectRatio, FSIInterpolation interpolation) throws NoSuchFileException, IOException, IllegalArgumentException, NotImportedException, NotConfiguredException, FlatImageException, ProcessingException {
        if (connector == null) {
            return this.builderPrivate.getImagePixelBased(priority, assetURLPath, referenceWidth, referenceHeight, leftPix, topPix, rangeWidthPix, rangeHeightPix, keepAspectRatio, interpolation);
        }
        if (connector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE || connector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGEAPI) {
            return this.builder1002.getImagePixelBased(preUsedReader, priority, assetURLPath, referenceWidth, referenceHeight, leftPix, topPix, rangeWidthPix, rangeHeightPix, interpolation);
        }
        if (connector.getMountType() == SourceConnectorReader.SourceConnectorType.MULTIRESOLUTION) {
            return this.builderMultiRes.getImagePixelBased(priority, connector.getSourceFileFromAssetURLPath(assetURLPath), assetURLPath, referenceWidth, referenceHeight, leftPix, topPix, rangeWidthPix, rangeHeightPix, interpolation);
        }
        if (connector.getMountType() == SourceConnectorReader.SourceConnectorType.STATIC) {
            throw new IllegalArgumentException("Image retrieval not supported for static source connectors.");
        }
        return null;
    }

    public FSIImageLimited getImage(EISReader preUsedReader, SourceConnectorReader connector, int priority, String assetURLPath, Pair<Integer, Boolean> targetWidth, Pair<Integer, Boolean> targetHeight, double left, double top, double rangeWidth, double rangeHeight, boolean keepAspectRatio, FSIInterpolation interpolation) throws NoSuchFileException, IOException, IllegalArgumentException, NotImportedException, NotConfiguredException, FlatImageException, ProcessingException, InterruptedException {
        if (connector == null) {
            return this.builderPrivate.getImage(priority, assetURLPath, targetWidth, targetHeight, left, top, rangeWidth, rangeHeight, keepAspectRatio, interpolation);
        }
        if (connector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGE || connector.getMountType() == SourceConnectorReader.SourceConnectorType.STORAGEAPI) {
            try {
                return this.builder1002.getImage(preUsedReader, priority, assetURLPath, targetWidth, targetHeight, left, top, rangeWidth, rangeHeight, keepAspectRatio, interpolation);
            }
            catch (NotImportedException e) {
                return this.builder1001.getImage(priority, assetURLPath, targetWidth, targetHeight, left, top, rangeWidth, rangeHeight, keepAspectRatio, interpolation);
            }
            catch (NoSuchFileException e) {
                return this.builder1001.getImage(priority, assetURLPath, targetWidth, targetHeight, left, top, rangeWidth, rangeHeight, keepAspectRatio, interpolation);
            }
        }
        if (connector.getMountType() == SourceConnectorReader.SourceConnectorType.MULTIRESOLUTION) {
            return this.builderMultiRes.getImage(priority, connector.getSourceFileFromAssetURLPath(assetURLPath), assetURLPath, targetWidth, targetHeight, left, top, rangeWidth, rangeHeight, keepAspectRatio, interpolation);
        }
        if (connector.getMountType() == SourceConnectorReader.SourceConnectorType.STATIC) {
            throw new IllegalArgumentException("Image retrieval not supported for static source connectors.");
        }
        return null;
    }
}

