/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imageloader;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.StorageHelperV1002;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.Level;
import com.neptunelabs.imagemanipulator.area.scale.UniScaler;
import com.neptunelabs.imagemanipulator.helper.FSIInterpolation;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import com.neptunelabs.imagereader.metareader.FSIMetaData;
import com.neptunelabs.imagereader.metareader.FSISubImageMetaData;

abstract class ImageBuilderAbstract {
    final FSIServerSettings settings;
    final StorageHelperV1002 storageHelper;
    final SwapPool swapPool;

    public ImageBuilderAbstract(FSIServerSettings serverSettings, SwapPool swapPool) {
        this.settings = serverSettings;
        this.storageHelper = this.settings.getStorageHelper();
        this.swapPool = swapPool;
    }

    String ensureCorrectPath(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.trim().length() == 0) {
            path = "/";
        }
        return path;
    }

    FSIImageLimited scaleImage(int priority, FSIInterpolation interpolation, int targetWidth, int targetHeight, double kernelShiftX, double kernelShiftY, double kernelShiftW, double kernelShiftH, FSIImageLimited imageToScale, Object storageFilename, long timeAss) throws ProcessingException {
        long startScale = 0L;
        if (this.settings.getFSILogger().isDebugEnabled()) {
            startScale = System.currentTimeMillis();
        }
        UniScaler scaler = new UniScaler(this.settings.getFSILogger(), this.settings.getExecutorPool());
        imageToScale = interpolation == FSIInterpolation.LANCZOS ? (FSIImageLimited)scaler.transform(priority, ExecutorPool.Type.RENDERER_CPU, UniScaler.Interpolation.LANCZOS, 3.0, imageToScale, targetWidth, targetHeight, kernelShiftX, kernelShiftY, kernelShiftW, kernelShiftH, false) : (FSIImageLimited)scaler.transform(priority, ExecutorPool.Type.RENDERER_CPU, UniScaler.Interpolation.NEAREST, 0.0, imageToScale, targetWidth, targetHeight, kernelShiftX, kernelShiftY, kernelShiftW, kernelShiftH, false);
        if (this.settings.getFSILogger().isDebugEnabled()) {
            long timeScale = System.currentTimeMillis() - startScale;
            this.settings.getFSILogger().log(3550, priority, storageFilename, timeAss, timeScale);
        }
        return imageToScale;
    }

    Pair<Double, Double> calcScaleFactor(int targetWidth, int targetHeight, int srcWidth, int srcHeight, double rangeWidth, double rangeHeight) {
        double verticalScaleFactor;
        double horizontalScaleFactor;
        if (targetWidth != -1 && targetHeight != -1) {
            horizontalScaleFactor = (double)targetWidth / ((double)srcWidth * rangeWidth);
            verticalScaleFactor = (double)targetHeight / ((double)srcHeight * rangeHeight);
        } else if (targetHeight == -1) {
            verticalScaleFactor = horizontalScaleFactor = (double)targetWidth / ((double)srcWidth * rangeWidth);
        } else {
            horizontalScaleFactor = verticalScaleFactor = (double)targetHeight / ((double)srcHeight * rangeHeight);
        }
        return new Pair<Double, Double>(horizontalScaleFactor, verticalScaleFactor);
    }

    static double[] getZoomLevels(Level[] levels, int orgWidth) {
        double[] zoomlevels = new double[levels.length];
        for (int l = 0; l < levels.length; ++l) {
            zoomlevels[l] = (double)levels[l].width / (double)orgWidth;
        }
        return zoomlevels;
    }

    int getZoomLevelIndex(double scaleFactor, double[] availableZoomlevels) {
        int result = 0;
        int index = 0;
        while (index < availableZoomlevels.length && scaleFactor < availableZoomlevels[index]) {
            result = index++;
        }
        return result;
    }

    int getZoomLevelIndex(double scaleFactor, FSIMetaData metaData) {
        double sf;
        int index = 0;
        FSISubImageMetaData imm = metaData.getLargestImage();
        index = imm.index;
        int baseWidth = imm.width;
        while ((imm = metaData.getLowerImage(imm)) != null && !(scaleFactor > (sf = (double)imm.width / (double)baseWidth))) {
            index = imm.index;
        }
        return index;
    }

    LoadingParameters calculateLoadingParameters(double left, double top, double rangeWidth, double rangeHeight, Pair<Integer, Boolean> targetWidthPair, Pair<Integer, Boolean> targetHeightPair, ImageMetaData metadata, boolean keepAspectRatio) {
        LoadingParameters loadingParams = new LoadingParameters();
        double d = left < 0.0 ? 0.0 : (loadingParams.left = left > 1.0 ? 1.0 : left);
        double d2 = top < 0.0 ? 0.0 : (loadingParams.top = top > 1.0 ? 1.0 : top);
        double d3 = rangeWidth < 0.0 ? 1.0 - left : (loadingParams.rangeWidth = rangeWidth + left > 1.0 ? 1.0 - left : rangeWidth);
        loadingParams.rangeHeight = rangeHeight < 0.0 ? 1.0 - top : (rangeHeight + top > 1.0 ? 1.0 - top : rangeHeight);
        loadingParams.targetWidth = targetWidthPair.getItem1();
        boolean useDefaultWidth = targetWidthPair.getItem2();
        loadingParams.targetHeight = targetHeightPair.getItem1();
        boolean useDefaultHeight = targetHeightPair.getItem2();
        if (!useDefaultWidth && useDefaultHeight) {
            loadingParams.targetHeight = -1;
        } else if (useDefaultWidth && !useDefaultHeight) {
            loadingParams.targetWidth = -1;
        }
        Pair<Double, Double> scaleFactors = this.calcScaleFactor(loadingParams.targetWidth, loadingParams.targetHeight, metadata.getWidth(), metadata.getHeight(), rangeWidth, rangeHeight);
        loadingParams.scaleFactorX = scaleFactors.getItem1();
        loadingParams.scaleFactorY = scaleFactors.getItem2();
        if (loadingParams.targetWidth == -1 || loadingParams.targetHeight == -1) {
            double scaleFactor = Math.min(loadingParams.scaleFactorX, loadingParams.scaleFactorY);
            if (loadingParams.targetWidth == -1) {
                loadingParams.targetWidth = (int)Math.round((double)metadata.getWidth() * rangeWidth * scaleFactor);
            } else if (loadingParams.targetHeight == -1) {
                loadingParams.targetHeight = (int)Math.round((double)metadata.getHeight() * rangeHeight * scaleFactor);
            }
            loadingParams.scaleFactorX = scaleFactor;
            loadingParams.scaleFactorY = scaleFactor;
        }
        if (keepAspectRatio && Math.abs(loadingParams.scaleFactorX - loadingParams.scaleFactorY) > 1.0E-7) {
            if (loadingParams.scaleFactorX > loadingParams.scaleFactorY) {
                double preciseTargetWidth = (double)loadingParams.targetHeight * (double)metadata.getWidth() * rangeWidth / ((double)metadata.getHeight() * rangeHeight);
                loadingParams.scaleFactorX = preciseTargetWidth / (double)metadata.getWidth();
                loadingParams.targetWidth = (int)Math.round(preciseTargetWidth);
            } else {
                double preciseTargetHeight = (double)loadingParams.targetWidth * (double)metadata.getHeight() * rangeHeight / ((double)metadata.getWidth() * rangeWidth);
                loadingParams.scaleFactorY = preciseTargetHeight / (double)metadata.getHeight();
                loadingParams.targetHeight = (int)Math.round(preciseTargetHeight);
            }
        }
        loadingParams.targetWidth = loadingParams.targetWidth == 0 ? 1 : loadingParams.targetWidth;
        loadingParams.targetHeight = loadingParams.targetHeight == 0 ? 1 : loadingParams.targetHeight;
        return loadingParams;
    }

    static class LoadingParameters {
        double left;
        double top;
        double rangeWidth;
        double rangeHeight;
        int targetWidth;
        int targetHeight;
        double scaleFactorX;
        double scaleFactorY;

        LoadingParameters() {
        }
    }
}

