/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imageloader;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiserver.authentication.PublishingSet;
import com.neptunelabs.fsiserver.imageloader.ImageBuilderAbstract;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.PoolDirectoryEntry;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.PoolList;
import com.neptunelabs.fsiserver.utils.PoolListSummary;
import com.neptunelabs.fsiserver.utils.comparators.PoolFileEntryComparator;
import com.neptunelabs.fsiserver.utils.metadata.DirectoryMetaData;
import com.neptunelabs.fsiserver.utils.metadata.FileMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import com.neptunelabs.fsiservletframework.utils.ServletUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;

class ImageBuilderConfigs
extends ImageBuilderAbstract {
    public ImageBuilderConfigs(FSIServerSettings settings, SwapPool swapPool) {
        super(settings, swapPool);
    }

    public MetaData getImageMetaData(String assetURLPath, HttpSession session) throws NoSuchFileException, IOException, NotConfiguredException {
        MetaData assetMetaData;
        Map<String, PublishingSet> pSetMap = this.settings.getUserAuthenticationInterface().getUserPublishingSets(session);
        if (assetURLPath.equals("_configs") || assetURLPath.equals("_viewers")) {
            DirectoryMetaData dmd = new DirectoryMetaData();
            dmd.setAssetURLPath(assetURLPath);
            dmd.setFiles(0L);
            dmd.setSubdirectories(pSetMap.size());
            dmd.setLastModified(System.currentTimeMillis());
            return dmd;
        }
        Path target = this.getViewerConfigAssetFromAssetURLPath(assetURLPath, pSetMap);
        if (Files.isDirectory(target, new LinkOption[0])) {
            DirectoryMetaData dirMetaData = new DirectoryMetaData();
            PoolListSummary pls = this.getPoolListSummary(target);
            dirMetaData.setSubdirectories(pls.getDirectoryCount());
            dirMetaData.setFiles(pls.getFileCount());
            dirMetaData.setLastModified(pls.lastmodified);
            assetMetaData = dirMetaData;
        } else {
            FileMetaData fileMetaData = new FileMetaData();
            fileMetaData.setSourceFileSize(Files.size(target));
            assetMetaData = fileMetaData;
        }
        assetMetaData.setAssetURLPath(assetURLPath);
        return assetMetaData;
    }

    public PoolList getFileList(String assetURLPath, int offset, int count, PoolFileEntryComparator entryComparator, HttpSession session) throws IOException, NotConfiguredException {
        PoolList result = new PoolList(null, assetURLPath);
        PoolList pl = this.getPoolList(assetURLPath, session);
        List<PoolFileEntry> aList = pl.getFilesAsList();
        if (entryComparator != null && aList.size() > 0) {
            Collections.sort(aList, entryComparator);
        }
        if (count == -1) {
            count = aList.size();
        }
        int mmax = Math.min(offset + count, aList.size());
        for (int i = offset; i < mmax; ++i) {
            result.addImageInitial(aList.get(i));
        }
        return result;
    }

    public PoolListSummary getPoolListSummary(Path path) throws NoSuchFileException, IOException {
        if (Files.exists(path, new LinkOption[0])) {
            Pair<Long, Long> res = FileOperations.countDirFiles(path);
            return new PoolListSummary(FileOperations.getSafeLastModified(path), res.getItem2(), res.getItem1());
        }
        throw new NoSuchFileException(path.toString());
    }

    public PoolList getPoolList(String assetURLPath, HttpSession session) throws NoSuchFileException, IOException, NotConfiguredException {
        return this.getPoolList(assetURLPath, session, true, true);
    }

    private PoolList getPoolList(String assetURLPath, HttpSession session, boolean includeFiles, boolean includeDirectories) throws NoSuchFileException, IOException, NotConfiguredException {
        PoolList list = new PoolList(null, assetURLPath);
        Map<String, PublishingSet> pSetMap = this.settings.getUserAuthenticationInterface().getUserPublishingSets(session);
        if ((assetURLPath.equals("_configs") || assetURLPath.equals("_viewers")) && includeDirectories) {
            for (String setname : pSetMap.keySet()) {
                try {
                    Path viewerConfigDir = this.getViewerConfigAssetFromAssetURLPath(assetURLPath + "/" + setname, pSetMap);
                    PoolListSummary pls = this.getPoolListSummary(viewerConfigDir);
                    list.addDirectory(new PoolDirectoryEntry(setname, pls.lastmodified, pls.getFileCount(), pls.getDirectoryCount()));
                }
                catch (NoSuchFileException noSuchFileException) {}
            }
        } else {
            Path targetDir = this.getViewerConfigAssetFromAssetURLPath(assetURLPath, pSetMap);
            list.lastmodified = Files.getLastModifiedTime(targetDir, new LinkOption[0]).toMillis();
            List<PathCached> files = FileOperations.listAllFiles(targetDir);
            for (PathCached f : files) {
                if (f.isDirectory() && includeDirectories) {
                    PoolListSummary pls = this.getPoolListSummary(f.getPath());
                    list.addDirectory(new PoolDirectoryEntry(f.getFileName(), pls.lastmodified, pls.getFileCount(), pls.getDirectoryCount()));
                    continue;
                }
                if (!includeFiles) continue;
                PoolFileEntry pe = new PoolFileEntry(f.getFileName(), f.lastModified(), f.size(), -1, -1, 0);
                list.addImage(pe);
            }
        }
        return list;
    }

    private Path getViewerConfigAssetFromAssetURLPath(String assetURLPath, Map<String, PublishingSet> publishingSetMap) throws NoSuchFileException {
        Path viewerPath;
        PublishingSet pSet;
        String restPath;
        if (!assetURLPath.startsWith("_configs") && !assetURLPath.startsWith("_viewers")) {
            throw new NoSuchFileException(assetURLPath);
        }
        String setname = assetURLPath.substring(9);
        int slashPosition = setname.indexOf("/");
        if (slashPosition > 0) {
            setname = setname.substring(0, slashPosition);
        }
        if ((restPath = assetURLPath.startsWith("_configs") ? assetURLPath.substring(9 + setname.length()) : assetURLPath.substring(9 + setname.length())).startsWith("/")) {
            restPath = restPath.substring(1);
        }
        if ((pSet = publishingSetMap.get(setname)) == null || pSet.viewerpath == null || pSet.viewerpath.value == null) {
            throw new NoSuchFileException(setname);
        }
        Path basePath = viewerPath = ServletUtils.getRealPath(this.settings.getServletContext(), pSet.viewerpath.value);
        if (assetURLPath.startsWith("_configs")) {
            basePath = viewerPath.resolve("config");
        }
        if (Files.notExists(basePath, new LinkOption[0])) {
            throw new NoSuchFileException(basePath.toString());
        }
        Path target = basePath;
        if (restPath.length() > 0) {
            target = basePath.resolve(restPath);
        }
        if (Files.notExists(target, new LinkOption[0])) {
            throw new NoSuchFileException(target.toString());
        }
        return target;
    }

    public PoolList getDirectoryList(String assetURLPath, HttpSession session) throws NoSuchFileException, IOException, NotConfiguredException {
        return this.getPoolList(assetURLPath, session, false, true);
    }
}

