/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imageloader;

import com.neptunelabs.fsiframework.cache.CacheKey;
import com.neptunelabs.fsiframework.cache.CacheLoad;
import com.neptunelabs.fsiframework.cache.CacheType;
import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.MemoryManager;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiserver.imageloader.ImageBuilderAbstract;
import com.neptunelabs.fsiserver.utils.Defines;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.ImageListFileReader;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.PoolDirectoryEntry;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.PoolList;
import com.neptunelabs.fsiserver.utils.PoolListSummary;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.Level;
import com.neptunelabs.imagemanipulator.helper.FSIInterpolation;
import com.neptunelabs.imagereader.ImageFormat;
import com.neptunelabs.imagereader.ImageFormatScanner;
import com.neptunelabs.imagereader.MetaScanner;
import com.neptunelabs.imagereader.converter.BufferedImageConverterThreaded;
import com.neptunelabs.imagereader.converter.ColorConverterCache;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.imagereader.helper.ICCDefaultReader;
import com.neptunelabs.imagereader.helper.RangeRelative;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import com.neptunelabs.imagereader.metareader.FSIMetaData;
import com.neptunelabs.imagereader.metareader.FSISubImageMetaData;
import com.neptunelabs.imagereader.pyramidreader.FlatImageException;
import com.neptunelabs.imagereader.pyramidreader.PyramidImageReaderAbstract;
import com.neptunelabs.imagereader.pyramidreader.PyramidImageReaderFPX;
import com.neptunelabs.imagereader.pyramidreader.PyramidImageReaderTIFF;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

class ImageBuilderMultiResolution
extends ImageBuilderAbstract {
    private final ImageListFileReader imageListFileReader;
    private ICCProfileWrap defaultCMYKICC = null;
    private ICCProfileWrap defaultRGBICC = null;
    private ICCProfileWrap defaultGrayICC = null;
    private boolean fallbackICCConversion = true;
    private final ColorConverterCache colorConverterCache;
    private final BufferedImageConverterThreaded converter;
    private final Map<String, String> mimeMapping;

    public ImageBuilderMultiResolution(FSIServerSettings settings, SwapPool swapPool, CopyOnWriteArrayList<String> tileProcessList) {
        super(settings, swapPool);
        this.imageListFileReader = new ImageListFileReader(settings, settings.getIOController(), null, false);
        this.setupDefaultICCProfiles();
        Object o = settings.getServletContext().getAttribute("com.neptunelabs.imagereader.ColorConverterCache");
        if (o != null && o instanceof ColorConverterCache) {
            this.colorConverterCache = (ColorConverterCache)o;
        } else {
            long maxMem = MemoryManager.getFreeHeapSpace();
            int maxProfileCaches = (int)Math.ceil((float)(maxMem - 0x9600000L) / 1048592.0f);
            if (maxProfileCaches < 2) {
                maxProfileCaches = 2;
            } else if (maxProfileCaches > 20) {
                maxProfileCaches = 20;
            }
            this.colorConverterCache = new ColorConverterCache(maxProfileCaches);
        }
        this.converter = new BufferedImageConverterThreaded(settings.getFSILogger(), settings.getExecutorPool(), this.colorConverterCache);
        this.mimeMapping = new HashMap<String, String>();
        Map<String, String> internalMimeMapping = settings.getMimeTypes();
        for (Map.Entry<String, String> entry : internalMimeMapping.entrySet()) {
            String suffix = entry.getKey();
            String mime = entry.getKey();
            if (!mime.equals("image/tiff") && !mime.equals("image/vnd.fpx")) continue;
            this.mimeMapping.put(suffix, mime);
        }
    }

    public ImageMetaData getImageMetaData(PathCached sourceFile, boolean deepScan) throws NoSuchFileException, IOException {
        if (sourceFile.notExists()) {
            throw new NoSuchFileException(sourceFile.toString());
        }
        MetaScanner metaScanner = new MetaScanner(this.settings.getFSILogger(), this.settings.getIOController());
        FSIMetaData metaData = metaScanner.scanImage(sourceFile, deepScan);
        System.err.println("GIMD 1");
        ImageMetaData imageMetaData = ImageMetaData.getInstance(metaData);
        System.err.println("GIMD 2:" + imageMetaData);
        if (!metaScanner.hasError()) {
            if (metaData.imageCount == 1 && (metaData.getWidth() > 1024 || metaData.getHeight() > 1024)) {
                imageMetaData.setImportStatus((byte)5);
            } else {
                imageMetaData.setImportStatus((byte)1);
            }
        } else {
            imageMetaData.setImportStatus((byte)3);
            System.err.println("Metascanner says " + sourceFile.getAbsolutePath() + " is broken");
        }
        return imageMetaData;
    }

    public PoolListSummary getPoolListSummary(Path path) throws IOException {
        Pair<Long, Long> dirFiles = FileOperations.countDirFiles(path);
        return new PoolListSummary(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis(), dirFiles.getItem2(), dirFiles.getItem1());
    }

    public PoolListSummary getPoolListSummary(PathCached path) throws IOException {
        Pair<Long, Long> dirFiles = FileOperations.countDirFiles(path.getPath());
        return new PoolListSummary(path.lastModified(), dirFiles.getItem2(), dirFiles.getItem1());
    }

    public PoolList getPoolList(String assetURLPath, Path path) throws IOException, NotConfiguredException {
        List<PathCached> files = FileOperations.listAllFiles(path);
        if (files == null) {
            throw new NoSuchFileException("Directory: " + path.toFile().getAbsolutePath());
        }
        Path dirlistFile = this.storageHelper.getDirectoryFile(assetURLPath);
        PoolList list = new PoolList(dirlistFile, assetURLPath);
        list.lastmodified = FileOperations.getSafeLastModified(path);
        try {
            PoolList pl = null;
            try {
                pl = this.imageListFileReader.getListFileContents(dirlistFile, assetURLPath);
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
            for (PathCached f : files) {
                if (f.isDirectory()) {
                    PoolListSummary pls = this.getPoolListSummary(f);
                    list.addDirectory(new PoolDirectoryEntry(f.getFileName(), pls.lastmodified, pls.getFileCount(), pls.getDirectoryCount()));
                    continue;
                }
                if (!f.isRegularFile()) continue;
                String filename = f.getFileName();
                PoolFileEntry poolFileEntry = null;
                if (pl != null) {
                    poolFileEntry = pl.getImage(filename);
                }
                if (poolFileEntry == null && this.isImageFile(filename)) {
                    poolFileEntry = new PoolFileEntry(filename, f.lastModified(), f.size(), -1, -1, 2);
                }
                if (poolFileEntry == null) continue;
                list.addImage(poolFileEntry);
            }
        }
        catch (Exception e) {
            this.settings.getFSILogger().logException(e, 3249, dirlistFile, assetURLPath);
        }
        return list;
    }

    private boolean isImageFile(String filename) {
        String lowerFilename = filename.toLowerCase();
        for (String suffix : this.mimeMapping.keySet()) {
            if (!lowerFilename.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public FSIImageLimited getImagePixelBased(int priority, PathCached fp, String assetURLPath, int referenceWidth, int referenceHeight, int leftPix, int topPix, int rangeWidthPix, int rangeHeightPix, FSIInterpolation interpolation) throws IOException, ProcessingException {
        if (referenceWidth == -1 || referenceHeight == -1) {
            FSIMetaData metaData = this.getFSIMetaData(fp, assetURLPath);
            int srcWidth = metaData.getWidth();
            int srcHeight = metaData.getHeight();
            if (referenceWidth == -1 && referenceHeight == -1) {
                referenceWidth = srcWidth;
                referenceHeight = srcHeight;
            } else if (referenceWidth == -1) {
                referenceWidth = (int)Math.ceil((double)(referenceHeight * srcWidth) / (double)srcHeight);
            } else if (referenceHeight == -1) {
                referenceHeight = (int)Math.ceil((double)(referenceWidth * srcHeight) / (double)srcWidth);
            }
        }
        double left = (double)leftPix / (double)referenceWidth;
        double top = (double)topPix / (double)referenceHeight;
        double rangeWidth = (double)rangeWidthPix / (double)referenceWidth;
        double rangeHeight = (double)rangeHeightPix / (double)referenceHeight;
        Pair<Integer, Boolean> targetWidthPair = new Pair<Integer, Boolean>(rangeWidthPix, false);
        Pair<Integer, Boolean> targetHeightPair = new Pair<Integer, Boolean>(rangeHeightPix, false);
        return this.getImage(priority, fp, assetURLPath, targetWidthPair, targetHeightPair, left, top, rangeWidth, rangeHeight, false, interpolation);
    }

    private FSIMetaData getFSIMetaData(PathCached sourceFile, String assetURLPath) throws IOException {
        CacheKey cacheKey = CacheKey.getInstance(assetURLPath, 'A', "ImageMetaData");
        CacheLoad cl = this.settings.getCacheManager().get(cacheKey, CacheType.METADATA);
        FSIMetaData metaData = cl != null ? (cl.requestedL1Object != null ? (FSIMetaData)cl.requestedL1Object : FSIMetaData.unpack(cl.data)) : null;
        if (metaData == null) {
            MetaScanner metaScanner = new MetaScanner(this.settings.getFSILogger(), this.settings.getIOController());
            metaData = metaScanner.scanImage(sourceFile, true);
            this.settings.getCacheManager().put(cacheKey, metaData, true);
        }
        return metaData;
    }

    public FSIImageLimited getImage(int priority, PathCached fp, String assetURLPath, Pair<Integer, Boolean> targetWidthPair, Pair<Integer, Boolean> targetHeightPair, double left, double top, double rangeWidth, double rangeHeight, boolean keepAspectRatio, FSIInterpolation interpolation) throws NoSuchFileException, IOException, IllegalArgumentException, FlatImageException, ProcessingException {
        ImageFormatScanner ifs = ImageFormatScanner.getInstance();
        ImageFormat sourceFormat = ifs.scanFile(fp);
        Defines.MULTIRESOLUTION_FORMATS format = null;
        if (sourceFormat.type == ImageFormat.Type.TIF) {
            format = Defines.MULTIRESOLUTION_FORMATS.TIFF;
        } else if (sourceFormat.type == ImageFormat.Type.FPX) {
            format = Defines.MULTIRESOLUTION_FORMATS.FPX;
        } else if (sourceFormat.type == ImageFormat.Type.EIS) {
            format = Defines.MULTIRESOLUTION_FORMATS.EIS;
        }
        if (format == null) {
            throw new IllegalArgumentException("Unsupported Image Format");
        }
        FSIMetaData metaData = this.getFSIMetaData(fp, assetURLPath);
        int pyrImages = metaData.imageCount;
        if (pyrImages == 1 && (metaData.getWidth() > 1024 || metaData.getHeight() > 1024)) {
            throw new FlatImageException();
        }
        int[] zoomWidth = new int[pyrImages];
        int[] zoomHeight = new int[pyrImages];
        Level[] zoomLevels = new Level[pyrImages];
        FSISubImageMetaData metaImage = metaData.getLargestImage();
        zoomWidth[metaImage.index] = metaImage.width;
        zoomHeight[metaImage.index] = metaImage.height;
        zoomLevels[metaImage.index] = new Level();
        zoomLevels[metaImage.index].tileSizeX = metaImage.tileWidth;
        zoomLevels[metaImage.index].tileSizeY = metaImage.tileHeight;
        zoomLevels[metaImage.index].width = metaImage.width;
        zoomLevels[metaImage.index].height = metaImage.height;
        while ((metaImage = metaData.getLowerImage(metaImage)) != null) {
            zoomWidth[metaImage.index] = metaImage.width;
            zoomHeight[metaImage.index] = metaImage.height;
            zoomLevels[metaImage.index] = new Level();
            zoomLevels[metaImage.index].tileSizeX = metaImage.tileWidth;
            zoomLevels[metaImage.index].tileSizeY = metaImage.tileHeight;
            zoomLevels[metaImage.index].width = metaImage.width;
            zoomLevels[metaImage.index].height = metaImage.height;
        }
        ImageMetaData eisMetaData = new ImageMetaData();
        eisMetaData.setZoomLevels(zoomLevels);
        eisMetaData.setWidth(metaData.getWidth());
        eisMetaData.setHeight(metaData.getHeight());
        ImageBuilderAbstract.LoadingParameters loadingParams = this.calculateLoadingParameters(left, top, rangeWidth, rangeHeight, targetWidthPair, targetHeightPair, eisMetaData, keepAspectRatio);
        FSIImageLimited result = null;
        long startAss = 0L;
        if (this.settings.getFSILogger().isDebugEnabled()) {
            startAss = System.currentTimeMillis();
        }
        int zoomlevelIndex = this.getZoomLevelIndex(Math.max(loadingParams.scaleFactorX, loadingParams.scaleFactorY), metaData);
        eisMetaData.setICC(metaData.getICC());
        eisMetaData.setColorType(metaData.colorType);
        PyramidImageReaderAbstract rir = null;
        if (format == Defines.MULTIRESOLUTION_FORMATS.TIFF) {
            rir = new PyramidImageReaderTIFF(this.settings.getFSILogger(), this.settings.getExecutorPool(), this.swapPool, this.converter, this.settings.getPluginLoader(), this.settings.getCacheManager(), this.settings.getByteOrder(), false, 0x2000000L, 1024);
        } else if (format == Defines.MULTIRESOLUTION_FORMATS.FPX) {
            rir = new PyramidImageReaderFPX(this.settings.getFSILogger(), this.settings.getExecutorPool(), this.swapPool, this.converter, this.settings.getPluginLoader(), this.settings.getCacheManager(), this.settings.getByteOrder(), false, 0x2000000L, 1024);
        } else if (format == Defines.MULTIRESOLUTION_FORMATS.EIS) {
            // empty if block
        }
        if (rir != null) {
            rir.setIOController(this.settings.getIOController());
            rir.setDefaultICCProfiles(this.defaultCMYKICC, this.defaultRGBICC, this.defaultGrayICC);
            rir.setUseFallbackICCConversion(this.fallbackICCConversion);
            RangeRelative range = new RangeRelative(loadingParams.left, loadingParams.top, loadingParams.rangeWidth, loadingParams.rangeHeight);
            rir.readImage(metaData, assetURLPath, priority, zoomlevelIndex, range, zoomWidth[zoomlevelIndex], zoomHeight[zoomlevelIndex]);
            result = (FSIImageLimited)rir.getImage();
        }
        long timeAss = 0L;
        if (this.settings.getFSILogger().isDebugEnabled()) {
            timeAss = System.currentTimeMillis() - startAss;
        }
        double levelLeftPixDouble = left * (double)zoomWidth[zoomlevelIndex];
        int levelLeftPix = (int)Math.floor(levelLeftPixDouble);
        double levelTopPixDouble = top * (double)zoomHeight[zoomlevelIndex];
        int levelTopPix = (int)Math.floor(levelTopPixDouble);
        double levelRangeWidthPixDouble = rangeWidth * (double)zoomWidth[zoomlevelIndex];
        int levelRangeWidthPix = (int)Math.ceil(levelRangeWidthPixDouble);
        double levelRangeHeightPixDouble = rangeHeight * (double)zoomHeight[zoomlevelIndex];
        int levelRangeHeightPix = (int)Math.ceil(levelRangeHeightPixDouble);
        double kernelShiftX = levelLeftPixDouble - (double)levelLeftPix;
        double kernelShiftY = levelTopPixDouble - (double)levelTopPix;
        double kernelShiftW = levelRangeWidthPixDouble - (double)levelRangeWidthPix;
        double kernelShiftH = levelRangeHeightPixDouble - (double)levelRangeHeightPix;
        if (result != null) {
            result = this.scaleImage(priority, interpolation, loadingParams.targetWidth, loadingParams.targetHeight, kernelShiftX, kernelShiftY, kernelShiftW, kernelShiftH, result, fp, timeAss);
        }
        if (rir != null) {
            rir.destroy();
        }
        return result;
    }

    public ImageListFileReader getImageListFileReader() {
        return this.imageListFileReader;
    }

    private void setupDefaultICCProfiles() {
        this.setupDefaultCMYKProfile();
        this.setupDefaultRGBProfile();
        this.setupDefaultGrayProfile();
        this.fallbackICCConversion = this.settings.getPrefsBoolean("colormanagementsystem", "fallbackICCConversion");
    }

    private void setupDefaultGrayProfile() {
        try {
            ICC_Profile profile;
            Path testFile = this.getProfileFile("DefaultGrayProfile");
            ICC_Profile iCC_Profile = profile = testFile == null ? ICCDefaultReader.getDefaultICCProfile("gray") : ICC_Profile.getInstance(FileOperations.readFile(testFile));
            if (profile != null) {
                this.defaultGrayICC = new ICCProfileWrap(profile.getData());
            }
        }
        catch (IOException e) {
            this.settings.getFSILogger().logException(e, 2030, "GRAY:" + e.getLocalizedMessage());
        }
    }

    private void setupDefaultRGBProfile() {
        try {
            ICC_Profile profile;
            Path testFile = this.getProfileFile("DefaultRGBProfile");
            ICC_Profile iCC_Profile = profile = testFile == null ? ICCDefaultReader.getDefaultICCProfile("rgb") : ICC_Profile.getInstance(FileOperations.readFile(testFile));
            if (profile != null) {
                this.defaultRGBICC = new ICCProfileWrap(profile.getData());
            }
        }
        catch (IOException e) {
            this.settings.getFSILogger().logException(e, 2030, "RGB:" + e.getLocalizedMessage());
        }
    }

    private void setupDefaultCMYKProfile() {
        try {
            ICC_Profile profile;
            Path testFile = this.getProfileFile("DefaultCMYKProfile");
            ICC_Profile iCC_Profile = profile = testFile == null ? ICCDefaultReader.getDefaultICCProfile("cmyk") : ICC_Profile.getInstance(FileOperations.readFile(testFile));
            if (profile != null) {
                this.defaultCMYKICC = new ICCProfileWrap(profile.getData());
            }
        }
        catch (IOException e) {
            this.settings.getFSILogger().logException(e, 2030, "CMYK:" + e.getLocalizedMessage());
        }
    }

    private Path getProfileFile(String profileIdentifier) {
        String profile = this.settings.getPrefsString("colormanagementsystem", profileIdentifier);
        if (profile != null && !profile.equals("auto")) {
            Path profilePath = Paths.get(profile, new String[0]);
            return !profilePath.isAbsolute() ? this.settings.getWebInfPath().resolve(profile) : profilePath;
        }
        return null;
    }
}

