/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imageloader;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiserver.imageloader.ImageBuilderAbstract;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.EISReader;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.NotImportedException;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.imagemanipulator.helper.FSIInterpolation;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.concurrent.CopyOnWriteArrayList;

class ImageBuilderPrivateEIS
extends ImageBuilderAbstract {
    public ImageBuilderPrivateEIS(FSIServerSettings settings, SwapPool swapPool, CopyOnWriteArrayList<String> tileProcessList) {
        super(settings, swapPool);
    }

    public ImageMetaData getImageMetaData(String assetURLPath) throws NoSuchFileException, IOException {
        if (assetURLPath.startsWith("/")) {
            assetURLPath = assetURLPath.substring(1);
        }
        Path eisFile = this.settings.getWebInfPath().resolve("internal/private_images").resolve(assetURLPath);
        ImageMetaData result = null;
        try (EISReader eisReader = new EISReader(assetURLPath, eisFile, this.settings, this.swapPool, this.settings.getExecutorPool(), true);){
            result = eisReader.getImageMetaData();
            result.setAssetURLPath(assetURLPath);
        }
        return result;
    }

    public FSIImageLimited getImagePixelBased(int priority, String assetURLPath, int referenceWidth, int referenceHeight, int leftPix, int topPix, int rangeWidthPix, int rangeHeightPix, boolean keepAspectRatio, FSIInterpolation interpolation) throws NoSuchFileException, IOException, IllegalArgumentException, NotImportedException, NotConfiguredException, ProcessingException {
        Path eisFile = this.settings.getWebInfPath().resolve("internal/private_images").resolve(assetURLPath);
        FSIImageLimited result = null;
        try (EISReader eisReader = new EISReader(assetURLPath, eisFile, this.settings, this.swapPool, this.settings.getExecutorPool(), true);){
            ImageMetaData meta = eisReader.getImageMetaData();
            short importStatus = meta.getImportStatus();
            if (importStatus != 1 && importStatus != 4) {
                throw new NotImportedException(meta);
            }
            int srcWidth = meta.getWidth();
            int srcHeight = meta.getHeight();
            if (rangeWidthPix == -1) {
                rangeWidthPix = srcWidth - leftPix;
            }
            if (rangeHeightPix == -1) {
                rangeHeightPix = srcHeight - topPix;
            }
            if (referenceWidth == -1 && referenceHeight == -1) {
                referenceWidth = srcWidth;
                referenceHeight = srcHeight;
            } else if (referenceWidth == -1) {
                referenceWidth = (int)Math.ceil((double)(referenceHeight * srcWidth) / (double)srcHeight);
            } else if (referenceHeight == -1) {
                referenceHeight = (int)Math.ceil((double)(referenceWidth * srcHeight) / (double)srcWidth);
            }
            if (leftPix < 0 || leftPix >= referenceWidth || topPix < 0 || topPix >= referenceHeight) {
                throw new IllegalArgumentException("Invalid range value");
            }
            Pair<Double, Double> scaleFactors = this.calcScaleFactor(referenceWidth, referenceHeight, srcWidth, srcHeight, 1.0, 1.0);
            double[] zoomlevels = ImageBuilderPrivateEIS.getZoomLevels(meta.getZoomLevels(), meta.getWidth());
            int zoomlevelIndex = this.getZoomLevelIndex(Math.max(scaleFactors.getItem1(), scaleFactors.getItem2()), zoomlevels);
            long startAss = 0L;
            if (this.settings.getFSILogger().isDebugEnabled()) {
                startAss = System.currentTimeMillis();
            }
            this.settings.getFSILogger().log(3551, priority, eisReader.getEISFile());
            double levelLeftPixDouble = (double)(leftPix * srcWidth) * zoomlevels[zoomlevelIndex] / (double)referenceWidth;
            int levelLeftPix = (int)Math.floor(levelLeftPixDouble);
            double levelTopPixDouble = (double)(topPix * srcHeight) * zoomlevels[zoomlevelIndex] / (double)referenceHeight;
            int levelTopPix = (int)Math.floor(levelTopPixDouble);
            double levelRangeWidthPixDouble = (double)(rangeWidthPix * srcWidth) * zoomlevels[zoomlevelIndex] / (double)referenceWidth;
            int levelRangeWidthPix = (int)Math.ceil(levelRangeWidthPixDouble);
            double levelRangeHeightPixDouble = (double)(rangeHeightPix * srcHeight) * zoomlevels[zoomlevelIndex] / (double)referenceHeight;
            int levelRangeHeightPix = (int)Math.ceil(levelRangeHeightPixDouble);
            double kernelShiftX = levelLeftPixDouble - (double)levelLeftPix;
            double kernelShiftY = levelTopPixDouble - (double)levelTopPix;
            double kernelShiftW = levelRangeWidthPixDouble - (double)levelRangeWidthPix;
            double kernelShiftH = levelRangeHeightPixDouble - (double)levelRangeHeightPix;
            result = (FSIImageLimited)eisReader.getImage(zoomlevelIndex, levelLeftPix, levelTopPix, levelRangeWidthPix, levelRangeHeightPix, priority);
            long timeAss = 0L;
            if (this.settings.getFSILogger().isDebugEnabled()) {
                timeAss = System.currentTimeMillis() - startAss;
            }
            result = this.scaleImage(priority, interpolation, rangeWidthPix, rangeHeightPix, kernelShiftX, kernelShiftY, kernelShiftW, kernelShiftH, result, eisReader.getEISFile(), timeAss);
        }
        catch (ProcessingException e) {
            if (result != null) {
                result.dispose();
            }
            throw e;
        }
        return result;
    }

    public FSIImageLimited getImage(int priority, String assetURLPath, Pair<Integer, Boolean> targetWidth, Pair<Integer, Boolean> targetHeight, double left, double top, double rangeWidth, double rangeHeight, boolean keepAspectRatio, FSIInterpolation interpolation) throws NoSuchFileException, IOException, IllegalArgumentException, NotImportedException, ProcessingException {
        FSIImageLimited result = null;
        if (assetURLPath.indexOf(47) == 0) {
            assetURLPath = assetURLPath.substring(1);
        }
        Path eisFile = this.settings.getWebInfPath().resolve("internal/private_images").resolve(assetURLPath);
        try (EISReader eisReader = new EISReader(assetURLPath, eisFile, this.settings, this.swapPool, this.settings.getExecutorPool(), true);){
            ImageMetaData meta = eisReader.getImageMetaData();
            if (meta.getImportStatus() != 1) {
                throw new NotImportedException(meta);
            }
            boolean useSource = false;
            result = this.getImage(priority, eisReader, meta, targetWidth, targetHeight, left, top, rangeWidth, rangeHeight, keepAspectRatio, useSource, interpolation);
        }
        return result;
    }

    private FSIImageLimited getImage(int priority, EISReader eisReader, ImageMetaData metadata, Pair<Integer, Boolean> targetWidthPair, Pair<Integer, Boolean> targetHeightPair, double left, double top, double rangeWidth, double rangeHeight, boolean keepAspectRatio, boolean useSource, FSIInterpolation interpolation) throws NoSuchFileException, IOException, IllegalArgumentException, ProcessingException {
        ImageBuilderAbstract.LoadingParameters loadingParams = this.calculateLoadingParameters(left, top, rangeWidth, rangeHeight, targetWidthPair, targetHeightPair, metadata, keepAspectRatio);
        FSIImageLimited result = null;
        long startAss = 0L;
        if (this.settings.getFSILogger().isDebugEnabled()) {
            startAss = System.currentTimeMillis();
        }
        if (useSource) {
            throw new NoSuchFileException(eisReader.toString());
        }
        double[] zoomlevels = ImageBuilderPrivateEIS.getZoomLevels(metadata.getZoomLevels(), metadata.getWidth());
        int zoomlevelIndex = this.getZoomLevelIndex(Math.max(loadingParams.scaleFactorX, loadingParams.scaleFactorY), zoomlevels);
        this.settings.getFSILogger().log(3551, priority, eisReader.getEISFile());
        try {
            result = (FSIImageLimited)eisReader.getImage(zoomlevelIndex, loadingParams.left, loadingParams.top, loadingParams.rangeWidth, loadingParams.rangeHeight, priority);
            long timeAss = 0L;
            if (this.settings.getFSILogger().isDebugEnabled()) {
                timeAss = System.currentTimeMillis() - startAss;
            }
            double levelLeftPixDouble = left * (double)metadata.getZoomLevels()[zoomlevelIndex].width;
            int levelLeftPix = (int)Math.floor(levelLeftPixDouble);
            double levelTopPixDouble = top * (double)metadata.getZoomLevels()[zoomlevelIndex].height;
            int levelTopPix = (int)Math.floor(levelTopPixDouble);
            double levelRangeWidthPixDouble = rangeWidth * (double)metadata.getZoomLevels()[zoomlevelIndex].width;
            int levelRangeWidthPix = (int)Math.ceil(levelRangeWidthPixDouble);
            double levelRangeHeightPixDouble = rangeHeight * (double)metadata.getZoomLevels()[zoomlevelIndex].height;
            int levelRangeHeightPix = (int)Math.ceil(levelRangeHeightPixDouble);
            double kernelShiftX = levelLeftPixDouble - (double)levelLeftPix;
            double kernelShiftY = levelTopPixDouble - (double)levelTopPix;
            double kernelShiftW = levelRangeWidthPixDouble - (double)levelRangeWidthPix;
            double kernelShiftH = levelRangeHeightPixDouble - (double)levelRangeHeightPix;
            result = this.scaleImage(priority, interpolation, loadingParams.targetWidth, loadingParams.targetHeight, kernelShiftX, kernelShiftY, kernelShiftW, kernelShiftH, result, eisReader.getEISFile(), timeAss);
        }
        catch (ProcessingException e) {
            if (result != null) {
                result.dispose();
            }
            throw e;
        }
        return result;
    }
}

