/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imageloader;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiserver.imageloader.ImageBuilderAbstract;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.PoolDirectoryEntry;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.PoolList;
import com.neptunelabs.fsiserver.utils.PoolListSummary;
import com.neptunelabs.fsiserver.utils.comparators.PoolFileEntryComparator;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;

class ImageBuilderStatic
extends ImageBuilderAbstract {
    public ImageBuilderStatic(FSIServerSettings settings, SwapPool swapPool) {
        super(settings, swapPool);
    }

    public ImageMetaData getImageMetaData(PathCached sourceFile) throws NoSuchFileException, IOException {
        if (sourceFile.notExists()) {
            throw new NoSuchFileException(sourceFile.toString());
        }
        ImageMetaData result = new ImageMetaData();
        result.setSourceFileSize(sourceFile.size());
        result.setLastModified(sourceFile.lastModified());
        result.setAssetURLPath(sourceFile.getAbsoluteName());
        return result;
    }

    public PoolList getFileList(Path path, String assetURLPath, int offset, int count, PoolFileEntryComparator entryComparator) throws IOException, NotConfiguredException {
        Path dirlistFile = this.settings.getStorageHelper().getDirectoryFile(assetURLPath);
        PoolList list = new PoolList(dirlistFile, assetURLPath);
        list.lastmodified = FileOperations.getSafeLastModified(path);
        ArrayList<PoolFileEntry> fileList = new ArrayList<PoolFileEntry>();
        for (PathCached f : FileOperations.listFiles(path)) {
            PoolFileEntry pe = new PoolFileEntry(f.getFileName(), f.lastModified(), f.size(), -1, -1, 0);
            fileList.add(pe);
        }
        if (entryComparator != null && fileList.size() > 0) {
            Collections.sort(fileList, entryComparator);
        }
        if (count == -1) {
            count = fileList.size();
        }
        int mmax = Math.min(offset + count, fileList.size());
        for (int i = offset; i < mmax; ++i) {
            list.addImageInitial((PoolFileEntry)fileList.get(i));
        }
        return list;
    }

    public PoolListSummary getPoolListSummary(Path path) throws NoSuchFileException, IOException {
        if (path != null && Files.exists(path, new LinkOption[0])) {
            Pair<Long, Long> res = FileOperations.countDirFiles(path);
            return new PoolListSummary(FileOperations.getSafeLastModified(path), res.getItem2(), res.getItem1());
        }
        throw path == null ? new NoSuchFileException(null) : new NoSuchFileException(path.toString());
    }

    public PoolListSummary getPoolListSummary(PathCached path) throws NoSuchFileException, IOException {
        if (path != null && path.isDirectory()) {
            Pair<Long, Long> res = FileOperations.countDirFiles(path.getPath());
            return new PoolListSummary(path.lastModified(), res.getItem2(), res.getItem1());
        }
        throw path == null ? new NoSuchFileException(null) : new NoSuchFileException(path.toString());
    }

    public PoolList getPoolList(Path path, String assetURLPath) throws NoSuchFileException, IOException, NotConfiguredException {
        Path dirlistFile = this.settings.getStorageHelper().getDirectoryFile(assetURLPath);
        PoolList list = new PoolList(dirlistFile, assetURLPath);
        if (path != null && Files.exists(path, new LinkOption[0])) {
            list.lastmodified = FileOperations.getSafeLastModified(path);
            for (PathCached f : FileOperations.listAllFiles(path)) {
                if (f.isDirectory()) {
                    PoolListSummary pls = this.getPoolListSummary(f);
                    list.addDirectory(new PoolDirectoryEntry(f.getFileName(), pls.lastmodified, pls.getFileCount(), pls.getDirectoryCount()));
                    continue;
                }
                if (!f.isRegularFile()) continue;
                PoolFileEntry pe = new PoolFileEntry(f.getFileName(), f.lastModified(), f.size(), -1, -1, 0);
                list.addImage(pe);
            }
        } else {
            throw path == null ? new NoSuchFileException(null) : new NoSuchFileException(path.toString());
        }
        return list;
    }

    public PoolList getDirectoryList(Path path, String assetURLPath) throws NoSuchFileException, IOException, NotConfiguredException {
        Path dirlistFile = this.settings.getStorageHelper().getDirectoryFile(assetURLPath);
        PoolList list = new PoolList(dirlistFile, assetURLPath);
        list.lastmodified = FileOperations.getSafeLastModified(path);
        for (PathCached f : FileOperations.listDirectories(path)) {
            PoolListSummary pls = this.getPoolListSummary(f);
            list.addDirectory(new PoolDirectoryEntry(f.getFileName(), pls.lastmodified, pls.getFileCount(), pls.getDirectoryCount()));
        }
        return list;
    }
}

