/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imageloader;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiserver.imageloader.ImageBuilderAbstract;
import com.neptunelabs.fsiserver.imageloader.MultiThreadedImageAssemblerV1001;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.ImageListFileReader;
import com.neptunelabs.fsiserver.utils.MetaDataFileReader;
import com.neptunelabs.fsiserver.utils.NotImportedException;
import com.neptunelabs.fsiserver.utils.PoolList;
import com.neptunelabs.fsiserver.utils.StorageHelperV1001;
import com.neptunelabs.fsiserver.utils.metadata.DirectoryMetaData;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.imagemanipulator.area.Crop;
import com.neptunelabs.imagemanipulator.helper.FSIInterpolation;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CopyOnWriteArrayList;

class ImageBuilderV1001
extends ImageBuilderAbstract {
    private final Path storageLocation;
    private final MultiThreadedImageAssemblerV1001 imageAssembler;
    private final MetaDataFileReader metaDataFileReader;
    private final ImageListFileReader imageListFileReader;

    public ImageBuilderV1001(FSIServerSettings settings, SwapPool swapPool, CopyOnWriteArrayList<String> tileProcessList, Path storageLocation) {
        super(settings, swapPool);
        this.storageLocation = storageLocation;
        this.imageAssembler = new MultiThreadedImageAssemblerV1001(settings, this, settings.getExecutorPool(), tileProcessList);
        this.metaDataFileReader = new MetaDataFileReader(settings, settings.getIOController());
        this.imageListFileReader = new ImageListFileReader(settings, settings.getIOController(), null, false);
    }

    public SwapPool getSwapPool() {
        return this.swapPool;
    }

    public ImageMetaData getImageMetaData(String assetURLPath, int readFlags) throws NoSuchFileException, IOException {
        if (assetURLPath.startsWith("/")) {
            assetURLPath = assetURLPath.substring(1);
        }
        String storageFilename = StorageHelperV1001.getStoragePrefix(assetURLPath) + assetURLPath;
        return this.metaDataFileReader.getMetaData(this.storageLocation.resolve(storageFilename).resolve("info.spm"), readFlags);
    }

    public DirectoryMetaData getDirectoryMetaData(String assetURLPath) throws NoSuchFileException, IOException {
        String storageFilename = StorageHelperV1001.getStoragePrefix(assetURLPath) + assetURLPath + "dirlist";
        PoolList pl = this.imageListFileReader.getListFileContents(Paths.get(storageFilename, new String[0]), assetURLPath);
        DirectoryMetaData result = new DirectoryMetaData();
        result.setAssetURLPath(assetURLPath);
        result.setLastModified(pl.lastmodified);
        return result;
    }

    public PoolList getPoolList(String assetURLPath) throws NoSuchFileException, IOException {
        assetURLPath = this.ensureCorrectPath(assetURLPath);
        String storageFilename = StorageHelperV1001.getStoragePrefix(assetURLPath) + assetURLPath + "dirlist";
        return this.imageListFileReader.getListFileContents(this.storageLocation.resolve(storageFilename), assetURLPath);
    }

    public FSIImageLimited getImage(int priority, String assetURLPath, Pair<Integer, Boolean> targetWidth, Pair<Integer, Boolean> targetHeight, double left, double top, double rangeWidth, double rangeHeight, boolean keepAspectRatio, FSIInterpolation interpolation) throws NoSuchFileException, IOException, IllegalArgumentException, NotImportedException, ProcessingException, InterruptedException {
        String storageFilename;
        ImageMetaData meta;
        FSIImageLimited result = null;
        if (assetURLPath.indexOf(47) == 0) {
            assetURLPath = assetURLPath.substring(1);
        }
        if ((meta = this.metaDataFileReader.getMetaData(this.storageLocation.resolve(storageFilename = StorageHelperV1001.getStoragePrefix(assetURLPath) + assetURLPath).resolve("info.spm"), 0)).getImportStatus() != 1) {
            this.settings.getFSILogger().log(3139, this.storageLocation.toString() + storageFilename);
        } else {
            result = this.getImage(priority, storageFilename, meta, targetWidth, targetHeight, left, top, rangeWidth, rangeHeight, keepAspectRatio, interpolation);
        }
        return result;
    }

    private FSIImageLimited getImage(int priority, String storageFilename, ImageMetaData metadata, Pair<Integer, Boolean> targetWidthPair, Pair<Integer, Boolean> targetHeightPair, double left, double top, double rangeWidth, double rangeHeight, boolean keepAspectRatio, FSIInterpolation interpolation) throws NoSuchFileException, IOException, IllegalArgumentException, ProcessingException, InterruptedException {
        ImageBuilderAbstract.LoadingParameters loadingParams = this.calculateLoadingParameters(left, top, rangeWidth, rangeHeight, targetWidthPair, targetHeightPair, metadata, keepAspectRatio);
        long startAss = 0L;
        if (this.settings.getFSILogger().isDebugEnabled()) {
            startAss = System.currentTimeMillis();
        }
        double[] zoomlevels = metadata.getZoomFactors();
        int zoomlevelIndex = this.getZoomLevelIndex(Math.max(loadingParams.scaleFactorX, loadingParams.scaleFactorY), zoomlevels);
        FSIImageLimited result = this.assembleSPIImage(priority, storageFilename, metadata.getWidth(), metadata.getHeight(), metadata.getByteOrder(), loadingParams.left, loadingParams.top, loadingParams.rangeWidth, loadingParams.rangeHeight, zoomlevels[zoomlevelIndex], zoomlevelIndex, metadata.getTileSize(), metadata.getTileFormat());
        long timeAss = 0L;
        if (this.settings.getFSILogger().isDebugEnabled()) {
            timeAss = System.currentTimeMillis() - startAss;
        }
        double levelLeftPixDouble = left * (double)metadata.getZoomLevels()[zoomlevelIndex].width;
        int levelLeftPix = (int)Math.floor(levelLeftPixDouble);
        double levelTopPixDouble = top * (double)metadata.getZoomLevels()[zoomlevelIndex].height;
        int levelTopPix = (int)Math.floor(levelTopPixDouble);
        double levelRangeWidthPixDouble = rangeWidth * (double)metadata.getZoomLevels()[zoomlevelIndex].width;
        int levelRangeWidthPix = (int)Math.ceil(levelRangeWidthPixDouble);
        double levelRangeHeightPixDouble = rangeHeight * (double)metadata.getZoomLevels()[zoomlevelIndex].height;
        int levelRangeHeightPix = (int)Math.ceil(levelRangeHeightPixDouble);
        double kernelShiftX = levelLeftPixDouble - (double)levelLeftPix;
        double kernelShiftY = levelTopPixDouble - (double)levelTopPix;
        double kernelShiftW = levelRangeWidthPixDouble - (double)levelRangeWidthPix;
        double kernelShiftH = levelRangeHeightPixDouble - (double)levelRangeHeightPix;
        result = this.scaleImage(priority, interpolation, loadingParams.targetWidth, loadingParams.targetHeight, kernelShiftX, kernelShiftY, kernelShiftW, kernelShiftH, result, Paths.get(storageFilename, new String[0]), timeAss);
        return result;
    }

    private FSIImageLimited assembleSPIImage(int priority, String filename, int srcWidth, int srcHeight, ByteOrder byteOrder, double left, double top, double rangeWidth, double rangeHeight, double scaleFactor, int zoomlevelIndex, int tileSize, byte format) throws NoSuchFileException, IOException, ProcessingException, InterruptedException {
        int maxRowIndex;
        this.settings.getFSILogger().log(3551, priority, filename);
        int zoomLevelWidth = (int)Math.round((double)srcWidth * scaleFactor);
        int zoomLevelHeight = (int)Math.round((double)srcHeight * scaleFactor);
        int leftPix = (int)Math.floor((double)zoomLevelWidth * left);
        int rangeWidthPix = (int)Math.floor((double)zoomLevelWidth * rangeWidth);
        int firstColumn = (int)Math.floor((double)leftPix / (double)tileSize);
        int lastColumn = (int)Math.ceil((double)(leftPix + rangeWidthPix) / (double)tileSize);
        int maxColumnIndex = (int)Math.ceil((double)srcWidth * scaleFactor / (double)tileSize) - 1;
        if (lastColumn > maxColumnIndex) {
            lastColumn = maxColumnIndex;
        }
        int topPix = (int)Math.floor((double)zoomLevelHeight * top);
        int rangeHeightPix = (int)Math.floor((double)zoomLevelHeight * rangeHeight);
        int firstRow = (int)Math.floor((double)topPix / (double)tileSize);
        int lastRow = (int)Math.ceil((double)(topPix + rangeHeightPix) / (double)tileSize);
        if (lastRow > (maxRowIndex = (int)Math.ceil((double)srcHeight * scaleFactor / (double)tileSize) - 1)) {
            lastRow = maxRowIndex;
        }
        FSIImageLimited result = this.imageAssembler.assembleImageInPlace(priority, this.storageLocation, filename, firstColumn, lastColumn, firstRow, lastRow, zoomlevelIndex, format, byteOrder, tileSize);
        double currentRangeX = (double)(firstColumn * tileSize) / (double)zoomLevelWidth;
        double currentRangeY = (double)(firstRow * tileSize) / (double)zoomLevelHeight;
        int cleft = (int)Math.round((double)zoomLevelWidth * (left - currentRangeX));
        int ctop = (int)Math.round((double)zoomLevelHeight * (top - currentRangeY));
        int cwidth = (int)Math.round((double)zoomLevelWidth * rangeWidth);
        int cheight = (int)Math.round((double)zoomLevelHeight * rangeHeight);
        if (cleft + cwidth > result.getWidth()) {
            --cwidth;
        }
        if (ctop + cheight > result.getHeight()) {
            --cheight;
        }
        if (left > 0.0 || top > 0.0 || rangeWidth < 1.0 || rangeHeight < 1.0) {
            result = (FSIImageLimited)Crop.transform(result, cleft, ctop, cwidth, cheight, 0, null, 0.0f, 0.0f);
        }
        return result;
    }
}

