/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imageloader;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiserver.imageloader.ImageBuilderAbstract;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.EISReader;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.ImageListFileReader;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.NotImportedException;
import com.neptunelabs.fsiserver.utils.PoolList;
import com.neptunelabs.fsiserver.utils.metadata.DirectoryMetaData;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.imagemanipulator.helper.FSIInterpolation;
import com.neptunelabs.imagereader.converter.FastMath;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.imagereader.helper.Selection;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import com.neptunelabs.imagereader.metrics.Histogram;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.concurrent.CopyOnWriteArrayList;

class ImageBuilderV1002
extends ImageBuilderAbstract {
    private final ImageListFileReader imageListFileReader;

    public ImageBuilderV1002(FSIServerSettings settings, SwapPool swapPool, CopyOnWriteArrayList<String> tileProcessList) {
        super(settings, swapPool);
        this.imageListFileReader = new ImageListFileReader(settings, settings.getIOController(), null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageMetaData getImageMetaData(String assetURLPath, int readFlags, boolean closeReader) throws NoSuchFileException, IOException, NotConfiguredException {
        if (assetURLPath.startsWith("/")) {
            assetURLPath = assetURLPath.substring(1);
        }
        Path eisFile = this.storageHelper.getEisFile(assetURLPath);
        ImageMetaData result = null;
        EISReader eisReader = null;
        try {
            eisReader = new EISReader(assetURLPath, eisFile, this.settings, this.swapPool, this.settings.getExecutorPool(), true);
            result = eisReader.getImageMetaData();
            if (result != null) {
                byte[] iccBytes;
                if (!closeReader) {
                    result.setEISReaderHook(eisReader);
                }
                result.setAssetURLPath(assetURLPath);
                if ((readFlags & 4) > 0) {
                    result.addIPTCData(eisReader.getIPTCData());
                }
                if ((readFlags & 8) > 0) {
                    result.setEXIF(eisReader.getExifData());
                }
                if ((readFlags & 2) > 0 && (iccBytes = eisReader.getICCData()) != null) {
                    if (result.getICC() == null) {
                        result.setICC(new ICCProfileWrap(iccBytes));
                    } else {
                        String iccName = result.getICC().getName();
                        ICCProfileWrap profileWrap = new ICCProfileWrap(iccBytes);
                        if (iccName != null) {
                            profileWrap.overwriteName(iccName);
                        }
                        result.setICC(profileWrap);
                    }
                }
                if ((readFlags & 0x10) > 0) {
                    result.setXMP(eisReader.getXMPData());
                }
                if ((readFlags & 0x40) > 0) {
                    result.setSelections(eisReader.getSelectionsData());
                    result.setAlphaNames(eisReader.getAlphaNames());
                }
                if ((readFlags & 0x20) > 0) {
                    Histogram h = eisReader.getHistogram();
                    result.setHistogram(h);
                }
            }
        }
        finally {
            if (closeReader && eisReader != null) {
                eisReader.close();
            }
        }
        return result;
    }

    public DirectoryMetaData getDirectoryMetaData(String assetURLPath) throws NotConfiguredException, NoSuchFileException, IOException {
        Path dirlistFile = this.storageHelper.getDirectoryFile(assetURLPath);
        PoolList pl = this.imageListFileReader.getListFileContents(dirlistFile, assetURLPath);
        if (pl != null) {
            DirectoryMetaData result = new DirectoryMetaData();
            result.setAssetURLPath(assetURLPath);
            result.setLastModified(pl.lastmodified);
            result.setFiles(pl.getFileCount());
            result.setSubdirectories(pl.getDirectoryCount());
            return result;
        }
        return null;
    }

    public DirectoryMetaData getDummyDirectoryMetaData(String assetURLPath) {
        DirectoryMetaData result = new DirectoryMetaData();
        result.setAssetURLPath(assetURLPath);
        result.setLastModified(System.currentTimeMillis());
        result.setFiles(0L);
        result.setSubdirectories(0L);
        return result;
    }

    public PoolList getPoolList(String assetURLPath) throws NoSuchFileException, IOException, NotConfiguredException {
        assetURLPath = this.ensureCorrectPath(assetURLPath);
        Path dirlistfile = this.storageHelper.getDirectoryFile(assetURLPath);
        return this.imageListFileReader.getListFileContents(dirlistfile, assetURLPath);
    }

    public FSIImageLimited getImagePixelBased(EISReader preUsedReader, int priority, String assetURLPath, int referenceWidth, int referenceHeight, int leftPix, int topPix, int rangeWidthPix, int rangeHeightPix, FSIInterpolation interpolation) throws NoSuchFileException, IOException, IllegalArgumentException, NotImportedException, NotConfiguredException, ProcessingException {
        EISReader eisReader;
        if (preUsedReader != null) {
            eisReader = preUsedReader;
        } else {
            Path eisFile = this.storageHelper.getEisFile(assetURLPath);
            eisReader = new EISReader(assetURLPath, eisFile, this.settings, this.swapPool, this.settings.getExecutorPool(), true);
        }
        FSIImageLimited result = null;
        try {
            ImageMetaData meta = eisReader.getImageMetaData();
            short importStatus = meta.getImportStatus();
            if (importStatus != 1 && importStatus != 4) {
                throw new NotImportedException(meta);
            }
            int srcWidth = meta.getWidth();
            int srcHeight = meta.getHeight();
            if (rangeWidthPix == -1) {
                rangeWidthPix = srcWidth - leftPix;
            }
            if (rangeHeightPix == -1) {
                rangeHeightPix = srcHeight - topPix;
            }
            if (referenceWidth == -1 && referenceHeight == -1) {
                referenceWidth = srcWidth;
                referenceHeight = srcHeight;
            } else if (referenceWidth == -1) {
                referenceWidth = (int)Math.ceil((double)(referenceHeight * srcWidth) / (double)srcHeight);
            } else if (referenceHeight == -1) {
                referenceHeight = (int)Math.ceil((double)(referenceWidth * srcHeight) / (double)srcWidth);
            }
            if (leftPix < 0 || leftPix + rangeWidthPix > referenceWidth || topPix < 0 || topPix + rangeHeightPix > referenceHeight) {
                throw new IllegalArgumentException("Invalid range value");
            }
            Pair<Double, Double> scaleFactors = this.calcScaleFactor(referenceWidth, referenceHeight, srcWidth, srcHeight, 1.0, 1.0);
            double[] zoomlevels = ImageBuilderV1002.getZoomLevels(meta.getZoomLevels(), srcWidth);
            int zoomlevelIndex = this.getZoomLevelIndex(Math.max(scaleFactors.getItem1(), scaleFactors.getItem2()), zoomlevels);
            long startAss = 0L;
            if (this.settings.getFSILogger().isDebugEnabled()) {
                startAss = System.currentTimeMillis();
            }
            this.settings.getFSILogger().log(3551, priority, eisReader.getEISFile());
            double levelLeftPixDouble = (double)(leftPix * srcWidth) * zoomlevels[zoomlevelIndex] / (double)referenceWidth;
            int levelLeftPix = FastMath.floor(levelLeftPixDouble);
            double levelTopPixDouble = (double)(topPix * srcHeight) * zoomlevels[zoomlevelIndex] / (double)referenceHeight;
            int levelTopPix = FastMath.floor(levelTopPixDouble);
            double levelRangeWidthPixDouble = (double)(rangeWidthPix * srcWidth) * zoomlevels[zoomlevelIndex] / (double)referenceWidth;
            int levelRangeWidthPix = FastMath.floor(levelRangeWidthPixDouble);
            double levelRangeHeightPixDouble = (double)(rangeHeightPix * srcHeight) * zoomlevels[zoomlevelIndex] / (double)referenceHeight;
            int levelRangeHeightPix = FastMath.floor(levelRangeHeightPixDouble);
            double kernelShiftX = levelLeftPixDouble - (double)levelLeftPix;
            double kernelShiftY = levelTopPixDouble - (double)levelTopPix;
            double kernelShiftW = levelRangeWidthPixDouble - (double)levelRangeWidthPix;
            double kernelShiftH = levelRangeHeightPixDouble - (double)levelRangeHeightPix;
            result = (FSIImageLimited)eisReader.getImage(zoomlevelIndex, levelLeftPix, levelTopPix, levelRangeWidthPix, levelRangeHeightPix, priority);
            long timeAss = 0L;
            if (this.settings.getFSILogger().isDebugEnabled()) {
                timeAss = System.currentTimeMillis() - startAss;
            }
            result = this.scaleImage(priority, interpolation, rangeWidthPix, rangeHeightPix, kernelShiftX, kernelShiftY, kernelShiftW, kernelShiftH, result, eisReader.getEISFile(), timeAss);
        }
        catch (ProcessingException e) {
            if (result != null) {
                result.dispose();
            }
            throw e;
        }
        finally {
            eisReader.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSIImageLimited getImage(EISReader preUsedReader, int priority, String assetURLPath, Pair<Integer, Boolean> targetWidth, Pair<Integer, Boolean> targetHeight, double left, double top, double rangeWidth, double rangeHeight, boolean keepAspectRatio, FSIInterpolation interpolation) throws NoSuchFileException, IOException, IllegalArgumentException, NotImportedException, NotConfiguredException, ProcessingException {
        FSIImageLimited result = null;
        if (assetURLPath.indexOf(47) == 0) {
            assetURLPath = assetURLPath.substring(1);
        }
        try (EISReader eisReader = preUsedReader != null && !preUsedReader.isClosed() ? preUsedReader : new EISReader(assetURLPath, this.storageHelper.getEisFile(assetURLPath), this.settings, this.swapPool, this.settings.getExecutorPool(), true);){
            ImageMetaData meta = eisReader.getImageMetaData();
            if (meta.getImportStatus() != 1 && meta.getImportStatus() != 4 || meta.getImportStatus() == 4 && meta.getWidth() == 0 && meta.getHeight() == 0) {
                throw new NotImportedException(meta);
            }
            boolean useSource = false;
            result = this.getImage(priority, eisReader, meta, targetWidth, targetHeight, left, top, rangeWidth, rangeHeight, keepAspectRatio, useSource, interpolation);
        }
        return result;
    }

    private FSIImageLimited getImage(int priority, EISReader eisReader, ImageMetaData metadata, Pair<Integer, Boolean> targetWidthPair, Pair<Integer, Boolean> targetHeightPair, double left, double top, double rangeWidth, double rangeHeight, boolean keepAspectRatio, boolean useSource, FSIInterpolation interpolation) throws NoSuchFileException, IOException, IllegalArgumentException, ProcessingException {
        ImageBuilderAbstract.LoadingParameters loadingParams = this.calculateLoadingParameters(left, top, rangeWidth, rangeHeight, targetWidthPair, targetHeightPair, metadata, keepAspectRatio);
        if (useSource) {
            throw new NoSuchFileException(eisReader.toString());
        }
        long startAss = 0L;
        if (this.settings.getFSILogger().isDebugEnabled()) {
            startAss = System.currentTimeMillis();
        }
        double[] zoomlevels = ImageBuilderV1002.getZoomLevels(metadata.getZoomLevels(), metadata.getWidth());
        int zoomlevelIndex = this.getZoomLevelIndex(Math.max(loadingParams.scaleFactorX, loadingParams.scaleFactorY), zoomlevels);
        this.settings.getFSILogger().log(3551, priority, eisReader.getEISFile());
        FSIImageLimited result = (FSIImageLimited)eisReader.getImage(zoomlevelIndex, left, top, rangeWidth, rangeHeight, priority);
        long timeAss = 0L;
        if (this.settings.getFSILogger().isDebugEnabled()) {
            timeAss = System.currentTimeMillis() - startAss;
        }
        double levelLeftPixDouble = left * (double)metadata.getZoomLevels()[zoomlevelIndex].width;
        int levelLeftPix = FastMath.floor(levelLeftPixDouble);
        double levelTopPixDouble = top * (double)metadata.getZoomLevels()[zoomlevelIndex].height;
        int levelTopPix = FastMath.floor(levelTopPixDouble);
        double levelRangeWidthPixDouble = rangeWidth * (double)metadata.getZoomLevels()[zoomlevelIndex].width;
        int levelRangeWidthPix = (int)Math.ceil(levelRangeWidthPixDouble);
        double levelRangeHeightPixDouble = rangeHeight * (double)metadata.getZoomLevels()[zoomlevelIndex].height;
        int levelRangeHeightPix = (int)Math.ceil(levelRangeHeightPixDouble);
        double kernelShiftX = levelLeftPixDouble - (double)levelLeftPix;
        double kernelShiftY = levelTopPixDouble - (double)levelTopPix;
        double kernelShiftW = levelRangeWidthPixDouble - (double)levelRangeWidthPix;
        double kernelShiftH = levelRangeHeightPixDouble - (double)levelRangeHeightPix;
        result = this.scaleImage(priority, interpolation, loadingParams.targetWidth, loadingParams.targetHeight, kernelShiftX, kernelShiftY, kernelShiftW, kernelShiftH, result, eisReader.getEISFile(), timeAss);
        if (metadata.hasAlpha() && metadata.getExtraAlphaCount() > 0) {
            Selection selection = new Selection();
            for (int i = 0; i < metadata.getExtraAlphaCount(); ++i) {
                if (metadata.getAlphaTypes()[i] != 1) continue;
                byte[] alphaChannel = new byte[result.getWidth() * result.getHeight()];
                result.setPositionExtraAlpha(i, 0L);
                result.getSamplesExtraAlpha(i, alphaChannel, 0, alphaChannel.length);
                selection.addSelection(new Selection(alphaChannel));
            }
            byte[] newAlpha = selection.getAlphaSelection();
            if (newAlpha != null) {
                result.addAlpha();
                for (int x = 0; x < newAlpha.length; ++x) {
                    result.setSample(x, result.getSample(x) & 0xFFFFFF | newAlpha[x] << 24);
                }
            }
        }
        return result;
    }
}

