/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imageloader;

import com.neptunelabs.fsiframework.cache.CacheKey;
import com.neptunelabs.fsiframework.cache.CacheLoad;
import com.neptunelabs.fsiframework.cache.CacheType;
import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiserver.imageloader.TileFileV1001;
import com.neptunelabs.fsiserver.sourcemanager.storage.utils.TileCompression;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.SPXEnvironment;
import com.neptunelabs.fsiserver.utils.cache.CacheableBytes;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.reader.ImageIOHelper;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;

final class ImageLoaderV1001 {
    private final FSIServerSettings settings;
    private final CopyOnWriteArrayList<String> tileProcessList;

    protected ImageLoaderV1001(FSIServerSettings settings, CopyOnWriteArrayList<String> tileProcessList) {
        this.settings = settings;
        this.tileProcessList = tileProcessList;
    }

    protected Pair<Integer, Integer> loadTileDimensions(String cachePrefix, Path tileFile) throws NoSuchFileException, IOException {
        int imageWidth = -1;
        int imageHeight = -1;
        CacheKey cacheKey = CacheKey.getInstance(cachePrefix, 'A', "tiles/" + tileFile.getFileName().toString());
        if (this.tileProcessList.contains(cacheKey)) {
            int waitCountDown = 2000;
            while (this.tileProcessList.contains(cacheKey)) {
                try {
                    if (waitCountDown-- == 0) {
                        this.tileProcessList.remove(cacheKey);
                        break;
                    }
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            this.tileProcessList.add(cacheKey.get());
        }
        CacheLoad cl = this.settings.getCacheManager().get(cacheKey, CacheType.BLOB);
        byte[] data = cl != null ? (cl.requestedL1Object != null ? ((CacheableBytes)cl.requestedL1Object).getData() : cl.data) : null;
        if (data == null) {
            data = FileOperations.readFile(this.settings.getFSILogger(), tileFile);
            this.settings.getCacheManager().put(cacheKey, new CacheableBytes(data), true);
        }
        this.tileProcessList.remove(cacheKey);
        if (data != null) {
            ByteBuffer mmb = ByteBuffer.wrap(data);
            byte[] magicNumber = new byte[8];
            mmb.get(magicNumber);
            this.checkMagicNumber(magicNumber);
            ByteOrder bo = mmb.get() == 0 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
            mmb.order(bo);
            mmb.getShort();
            int tagCounter = 0;
            boolean endReached = false;
            while (!endReached && tagCounter < 50) {
                ++tagCounter;
                int tag = -1;
                try {
                    tag = mmb.getShort();
                }
                catch (BufferUnderflowException e) {
                    endReached = true;
                }
                if (endReached) continue;
                try {
                    int tagContentLength = mmb.getInt();
                    switch (tag) {
                        case 14: {
                            imageWidth = mmb.getShort();
                            break;
                        }
                        case 15: {
                            imageHeight = mmb.getShort();
                            break;
                        }
                        default: {
                            mmb.position(mmb.position() + tagContentLength);
                        }
                    }
                    if (imageHeight == -1 || imageWidth == -1) continue;
                    endReached = true;
                }
                catch (BufferUnderflowException e) {
                    endReached = true;
                }
            }
        } else {
            throw new NoSuchFileException(tileFile.toString());
        }
        return new Pair<Integer, Integer>(imageWidth, imageHeight);
    }

    protected Path loadImage(long priority, String cachePrefix, TileFileV1001 tileFile, byte tileFormat, FSIImage target, int tileSize) throws NoSuchFileException, IOException {
        long startWaitTime = System.nanoTime();
        CacheKey cacheKey = CacheKey.getInstance(cachePrefix, 'A', "tiles/" + tileFile.file.getFileName().toString());
        CacheKey cacheKeyTile = CacheKey.getInstance(cachePrefix, 'A', "tiles/" + tileFile.file.getFileName().toString() + "/Image");
        CacheLoad cl = this.settings.getCacheManager().get(cacheKeyTile, CacheType.BLOB);
        byte[] imageData = cl != null ? (cl.requestedL1Object != null ? ((CacheableBytes)cl.requestedL1Object).getData() : cl.data) : null;
        float msWaitTime = (float)(System.nanoTime() - startWaitTime) / 1000000.0f;
        if (imageData == null) {
            imageData = this.loadImageData(tileFile, cacheKey, priority, msWaitTime);
            this.settings.getCacheManager().put(cacheKeyTile, new CacheableBytes(imageData), true);
        } else {
            this.settings.getFSILogger().log(3553, priority, cacheKey, Float.valueOf(msWaitTime));
        }
        int x = tileFile.offsetX;
        int y = tileFile.offsetY;
        int tWidth = target.getWidth();
        for (int p = 0; p < imageData.length; p += 4) {
            target.setSample(x, y, (imageData[p] & 0xFF) << 24 | (imageData[p + 1] & 0xFF) << 16 | (imageData[p + 2] & 0xFF) << 8 | imageData[p + 3] & 0xFF);
            if (++x % tileSize != 0 && x != tWidth) continue;
            x = tileFile.offsetX;
            ++y;
        }
        return tileFile.file;
    }

    private byte[] transferRasterData(byte[] imageExtraAlpha, int imageWidth, int imageHeight, Raster raster) {
        DataBuffer db = raster.getDataBuffer();
        int dblen = db.getSize();
        byte[] imageData = new byte[imageWidth * imageHeight * 4];
        int i = 0;
        int a = 0;
        while (i < dblen) {
            imageData[i] = imageExtraAlpha != null ? imageExtraAlpha[a] : -1;
            imageData[i + 1] = (byte)db.getElem(0, i);
            imageData[i + 2] = (byte)db.getElem(0, i + 1);
            imageData[i + 3] = (byte)db.getElem(0, i + 2);
            i += 4;
            ++a;
        }
        return imageData;
    }

    private Raster getRasterFromJPEGData(byte[] imageData) throws IOException {
        Raster result = null;
        ImageReader imageReader = ImageIOHelper.getReader("com.sun", "jpeg");
        if (imageReader != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(imageData);
            MemoryCacheImageInputStream mciis = new MemoryCacheImageInputStream(bais);
            imageReader.setInput(mciis);
            result = imageReader.readRaster(0, null);
            mciis.close();
            bais.close();
            imageReader.dispose();
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    private byte[] unpackDeflate(byte[] data, int maxlen) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void filterRevSub4(byte[] data, int width) {
        int len = data.length;
        int width4 = width * 4;
        int rows = len / width4;
        for (int r = 0; r < rows; ++r) {
            int pos = r * width4 + width4 - 1;
            for (int c = 0; c < width4; c += 4) {
                int n = pos;
                data[n] = (byte)(data[n] + data[pos + 4]);
                int n2 = pos - 1;
                data[n2] = (byte)(data[n2] + data[pos + 5]);
                int n3 = pos - 2;
                data[n3] = (byte)(data[n3] + data[pos + 6]);
                int n4 = pos - 3;
                data[n4] = (byte)(data[n4] + data[pos + 7]);
                pos += 4;
            }
        }
    }

    private void checkMagicNumber(byte[] magicNumber) throws IOException {
        if (!Arrays.equals(magicNumber, SPXEnvironment.SPI_MAGIC)) {
            throw new IOException("Invalid Image File in storage");
        }
    }

    private void checkMagicNumber(ByteBuffer reader) throws IOException {
        byte[] magicNumber = new byte[8];
        reader.get(magicNumber);
        this.checkMagicNumber(magicNumber);
    }

    private byte[] loadImageData(TileFileV1001 tileFile, CacheKey cacheKey, long priority, float msWaitTime) throws IOException {
        Raster raster;
        long startTimeMS = 0L;
        long startReadTime = 0L;
        if (this.settings.getFSILogger().isDebugEnabled()) {
            startReadTime = startTimeMS = System.nanoTime();
        }
        TileFileContents tileData = this.readTileFile(cacheKey, tileFile);
        byte[] imageData = tileData.imageData;
        byte[] imageExtraAlpha = tileData.imageExtraAlpha;
        float msReadTime = 0.0f;
        float msTransferTime = 0.0f;
        long startDecoderMS = 0L;
        if (this.settings.getFSILogger().isDebugEnabled()) {
            msReadTime = (float)(System.nanoTime() - startReadTime) / 1000000.0f;
            msTransferTime = 0.0f;
            startDecoderMS = System.nanoTime();
        }
        if (tileData.dataFormat == TileCompression.LOSSLESS.ordinal()) {
            if (tileData.dataCompression == 2) {
                imageData = this.unpackDeflate(imageData, tileData.imageWidth * tileData.imageHeight * 4);
            }
            if (tileData.dataFilter == 1) {
                this.filterRevSub4(imageData, tileData.imageWidth);
            }
        } else if (tileData.dataFormat == TileCompression.JPEG.ordinal() && (raster = this.getRasterFromJPEGData(imageData)) != null) {
            long startTransfer = 0L;
            if (this.settings.getFSILogger().isDebugEnabled()) {
                startTransfer = System.nanoTime();
            }
            imageData = this.transferRasterData(imageExtraAlpha, tileData.imageWidth, tileData.imageHeight, raster);
            if (this.settings.getFSILogger().isDebugEnabled()) {
                msTransferTime = (float)(System.nanoTime() - startTransfer) / 1000000.0f;
            }
        }
        float msDecoderTime = 0.0f;
        if (this.settings.getFSILogger().isDebugEnabled()) {
            msDecoderTime = (float)(System.nanoTime() - startDecoderMS) / 1000000.0f;
        }
        if (this.settings.getFSILogger().isDebugEnabled()) {
            float msTotalTime = (float)(System.nanoTime() - startTimeMS) / 1000000.0f;
            this.settings.getFSILogger().log(3554, priority, tileFile.file, Float.valueOf(msWaitTime), Float.valueOf(msReadTime), Float.valueOf(msDecoderTime), Float.valueOf(msTransferTime), Float.valueOf(msTotalTime));
        }
        return imageData;
    }

    private TileFileContents readTileFile(CacheKey cacheKey, TileFileV1001 tileFile) throws IOException {
        TileFileContents result = new TileFileContents();
        if (this.tileProcessList.contains(cacheKey)) {
            int waitCountDown = 2000;
            while (this.tileProcessList.contains(cacheKey)) {
                try {
                    if (waitCountDown-- == 0) {
                        this.tileProcessList.remove(cacheKey);
                        break;
                    }
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            this.tileProcessList.add(cacheKey.get());
        }
        ByteBuffer reader = null;
        CacheLoad cl = this.settings.getCacheManager().get(cacheKey, CacheType.BLOB);
        if (cl != null) {
            if (cl.requestedL1Object != null) {
                byte[] imageData = ((CacheableBytes)cl.requestedL1Object).getData();
                if (imageData != null) {
                    reader = ByteBuffer.wrap(imageData);
                }
            } else if (cl.data != null) {
                reader = ByteBuffer.wrap(cl.data);
            }
            this.settings.getFSILogger().log(3518, tileFile.file);
        }
        if (reader == null) {
            byte[] bytes = FileOperations.readFile(tileFile.file);
            reader = ByteBuffer.wrap(bytes);
            this.checkMagicNumber(reader);
            reader.order(reader.get() == 0 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            reader.getShort();
            int tagCounter = 0;
            boolean endReached = false;
            while (!endReached && tagCounter < 50) {
                ++tagCounter;
                int tag = -1;
                try {
                    tag = reader.getShort();
                }
                catch (BufferUnderflowException e) {
                    endReached = true;
                }
                if (!endReached && tag != 3854) {
                    try {
                        int tagContentLength = reader.getInt();
                        switch (tag) {
                            case 14: {
                                result.imageWidth = reader.getShort();
                                break;
                            }
                            case 15: {
                                result.imageHeight = reader.getShort();
                                break;
                            }
                            case 101: {
                                result.dataFormat = reader.get();
                                break;
                            }
                            case 103: {
                                result.dataFilter = reader.get();
                                break;
                            }
                            case 104: {
                                reader.get();
                                break;
                            }
                            case 102: {
                                result.dataCompression = reader.get();
                                break;
                            }
                            case 200: {
                                result.imageData = new byte[tagContentLength];
                                reader.get(result.imageData);
                                break;
                            }
                            case 201: {
                                result.imageExtraAlpha = new byte[tagContentLength];
                                reader.get(result.imageExtraAlpha);
                                result.imageExtraAlpha = this.unpackDeflate(result.imageExtraAlpha, result.imageWidth * result.imageHeight);
                                break;
                            }
                            case 3854: {
                                endReached = true;
                                break;
                            }
                            default: {
                                reader.position(reader.position() + tagContentLength);
                                break;
                            }
                        }
                    }
                    catch (BufferUnderflowException e) {
                        endReached = true;
                    }
                    continue;
                }
                endReached = true;
            }
            this.settings.getCacheManager().put(cacheKey, new CacheableBytes(bytes), true);
        }
        this.tileProcessList.remove(cacheKey);
        reader = null;
        return result;
    }

    private static class TileFileContents {
        byte[] imageData;
        byte[] imageExtraAlpha;
        int imageWidth = -1;
        int imageHeight = -1;
        byte dataFormat = (byte)-1;
        byte dataCompression = (byte)-1;
        byte dataFilter = (byte)-1;
    }
}

