/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imageloader;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.concurrent.PriorityExecutor;
import com.neptunelabs.fsiframework.concurrent.PriorityExecutorCompletionService;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.imageloader.ImageBuilderV1001;
import com.neptunelabs.fsiserver.imageloader.ImageLoaderV1001;
import com.neptunelabs.fsiserver.imageloader.TileFileV1001;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import com.neptunelabs.imagereader.image.FSIImageMode;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

final class MultiThreadedImageAssemblerV1001 {
    private final ImageBuilderV1001 builder;
    private final ExecutorPool executorPool;
    final FSIServerSettings settings;
    final ImageLoaderV1001 loader;

    public MultiThreadedImageAssemblerV1001(FSIServerSettings settings, ImageBuilderV1001 builder, ExecutorPool executorPool, CopyOnWriteArrayList<String> tileProcessList) {
        this.builder = builder;
        this.settings = settings;
        this.executorPool = executorPool;
        this.loader = new ImageLoaderV1001(settings, tileProcessList);
    }

    FSIImageLimited assembleImageInPlace(int priority, Path storageLocation, String filename, int firstCol, int lastCol, int firstRow, int lastRow, int zoomlevelIndex, byte format, ByteOrder byteOrder, int tileSize) throws IOException, ProcessingException, InterruptedException {
        FSIImageMode mode;
        switch (format) {
            case 3: {
                mode = FSIImageMode.GRAY;
                break;
            }
            case 4: {
                mode = FSIImageMode.AGRAY;
                break;
            }
            case 1: {
                mode = FSIImageMode.RGB;
                break;
            }
            default: {
                mode = FSIImageMode.ARGB;
            }
        }
        int horizontalTiles = lastCol - firstCol;
        int verticalTiles = lastRow - firstRow;
        Path tileDirectory = storageLocation.resolve(filename).resolve("tiles");
        Path brTileFile = tileDirectory.resolve(zoomlevelIndex + "_" + lastCol + "-" + lastRow + ".spi");
        Pair<Integer, Integer> dims = this.loader.loadTileDimensions(filename, brTileFile);
        int lastTileWidth = dims.getItem1();
        int lastTileHeight = dims.getItem2();
        int width = horizontalTiles * tileSize + lastTileWidth;
        int height = verticalTiles * tileSize + lastTileHeight;
        FSIImageLimited target = new FSIImageLimited(this.settings.getFSILogger(), this.builder.getSwapPool(), byteOrder, width, height, null, mode);
        ExecutorPool.Type type = ExecutorPool.Type.RENDERER_IO;
        PriorityExecutorCompletionService<Path> completionService = new PriorityExecutorCompletionService<Path>(this.executorPool.getExecutorService(type));
        ArrayList<Future<Path>> futures = new ArrayList<Future<Path>>();
        for (int i = 0; i <= horizontalTiles; ++i) {
            for (int j = 0; j <= verticalTiles; ++j) {
                Path file;
                TileFileV1001 tf = new TileFileV1001();
                tf.file = file = tileDirectory.resolve(zoomlevelIndex + "_" + (firstCol + i) + "-" + (firstRow + j) + ".spi");
                tf.offsetX = i * tileSize;
                tf.offsetY = j * tileSize;
                futures.add(completionService.submit(new LoaderCaller(priority, filename, tf, format, target, tileSize)));
            }
        }
        try {
            for (int c = 0; c < completionService.count(); ++c) {
                completionService.take().get();
            }
        }
        catch (ExecutionException e) {
            throw new ProcessingException(e.getCause());
        }
        finally {
            for (Future future : futures) {
                future.cancel(true);
            }
        }
        return target;
    }

    private final class LoaderCaller
    implements Callable<Path>,
    PriorityExecutor.Important {
        final int priority;
        final String cachePrefix;
        final TileFileV1001 tileFile;
        final byte format;
        final FSIImage image;
        final int tileSize;

        LoaderCaller(int priority, String cachePrefix, TileFileV1001 tileFile, byte format, FSIImage image, int tileSize) {
            this.priority = priority;
            this.cachePrefix = cachePrefix;
            this.tileFile = tileFile;
            this.format = format;
            this.image = image;
            this.tileSize = tileSize;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public Path call() {
            Path result = null;
            try {
                result = MultiThreadedImageAssemblerV1001.this.loader.loadImage(this.priority, this.cachePrefix, this.tileFile, this.format, this.image, this.tileSize);
            }
            catch (IOException e) {
                MultiThreadedImageAssemblerV1001.this.settings.getFSILogger().log(3192, e.getClass().getName() + ": " + e.getLocalizedMessage());
            }
            return result;
        }
    }
}

