/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.mbeans;

import com.neptunelabs.fsiserver.mbeans.FSIRequestProcessorLicenceMBean;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;

public final class FSIRequestProcessorLicence
implements FSIRequestProcessorLicenceMBean {
    private final RequestProcessorSettings settings;

    public FSIRequestProcessorLicence(RequestProcessorSettings settings) {
        this.settings = settings;
    }

    @Override
    public String getEdition() {
        return this.settings.getLicence().getEdition();
    }

    @Override
    public boolean getExpired() {
        boolean pass = true;
        long expireDate = this.settings.getLicence().getExpireTime();
        if (expireDate > 0L && System.currentTimeMillis() > expireDate) {
            pass = false;
        }
        return !pass;
    }

    @Override
    public long getMaxImages() {
        long mI = this.settings.getLicence().getMaxImages();
        if (mI == -1L) {
            return 0L;
        }
        return mI;
    }

    @Override
    public boolean getLicensed() {
        return this.settings.getLicence().hasLicence();
    }

    @Override
    public int getMaxGroups() {
        int mI = this.settings.getLicence().getMaxUserGroups();
        if (mI == -1) {
            return 0;
        }
        return mI;
    }

    @Override
    public int getMaxConnectors() {
        int mI = this.settings.getLicence().getMaxConnectors();
        if (mI == -1) {
            return 0;
        }
        return mI;
    }

    @Override
    public boolean getStagingLicence() {
        return this.settings.getLicence().isStagingLicence();
    }

    @Override
    public boolean getBatchProcessing() {
        return this.settings.getLicence().isBatchProcessingEnabled();
    }

    @Override
    public boolean getMirrorLicence() {
        return this.settings.getLicence().isMirrorLicence();
    }

    @Override
    public boolean getTrialLicence() {
        return this.settings.getLicence().isTrialLicence();
    }

    @Override
    public String getMinVersion() {
        return this.settings.getLicence().getNiceMinVersion();
    }

    @Override
    public String getMaxVersion() {
        return this.settings.getLicence().getNiceMaxVersion();
    }
}

