/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.mbeans;

import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.licensing.Licence;
import com.neptunelabs.imagereader.converter.FastMath;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.nio.file.FileStore;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class SystemMonitor
extends Thread {
    private final AtomicLong[] accumulators;
    private int lastSlowCheck = 60;
    private final AtomicLong ttfb10 = new AtomicLong(0L);
    private final AtomicLong ttfb25 = new AtomicLong(0L);
    private final AtomicLong ttfb50 = new AtomicLong(0L);
    private final AtomicLong ttfb100 = new AtomicLong(0L);
    private final AtomicLong ttfb250 = new AtomicLong(0L);
    private final AtomicLong ttfb500 = new AtomicLong(0L);
    private final AtomicLong ttfb1000 = new AtomicLong(0L);
    private final AtomicLong ttfb2500 = new AtomicLong(0L);
    private final AtomicLong ttfb5000 = new AtomicLong(0L);
    private final AtomicLong ttfb5000plus = new AtomicLong(0L);
    AtomicLong[] ttfb60Sec = new AtomicLong[60];
    AtomicInteger[] ttfb60Hits = new AtomicInteger[60];
    int ttfb60Pos = 0;
    private final AtomicLong ttlb10 = new AtomicLong(0L);
    private final AtomicLong ttlb25 = new AtomicLong(0L);
    private final AtomicLong ttlb50 = new AtomicLong(0L);
    private final AtomicLong ttlb100 = new AtomicLong(0L);
    private final AtomicLong ttlb250 = new AtomicLong(0L);
    private final AtomicLong ttlb500 = new AtomicLong(0L);
    private final AtomicLong ttlb1000 = new AtomicLong(0L);
    private final AtomicLong ttlb2500 = new AtomicLong(0L);
    private final AtomicLong ttlb5000 = new AtomicLong(0L);
    private final AtomicLong ttlb5000plus = new AtomicLong(0L);
    AtomicLong[] ttlb60Sec = new AtomicLong[60];
    AtomicInteger[] ttlb60Hits = new AtomicInteger[60];
    int ttlb60Pos = 0;
    AtomicInteger concurrentRequests = new AtomicInteger(0);
    AtomicInteger[] concurrentRequests60Sec = new AtomicInteger[60];
    int concurrentRequests60Pos = 0;
    AtomicInteger concurrentProcessing = new AtomicInteger(0);
    AtomicInteger[] concurrentProcessing60Sec = new AtomicInteger[60];
    int concurrentProcessing60Pos = 0;
    AtomicInteger activeCPUThreads = new AtomicInteger(0);
    AtomicInteger[] activeCPUThreads60Sec = new AtomicInteger[60];
    int activeCPUThreads60Pos = 0;
    AtomicInteger activeIOThreads = new AtomicInteger(0);
    AtomicInteger[] activeIOThreads60Sec = new AtomicInteger[60];
    int activeIOThreads60Pos = 0;
    AtomicLong taskCPUThreads = new AtomicLong(0L);
    AtomicLong[] taskCPUThreads60Sec = new AtomicLong[60];
    int taskCPUThreads60Pos = 0;
    AtomicLong taskIOThreads = new AtomicLong(0L);
    AtomicLong[] taskIOThreads60Sec = new AtomicLong[60];
    int taskIOThreads60Pos = 0;
    private volatile boolean runDaemon = true;
    private static final long sleep = 1000L;
    private final Path pool;
    private final ExecutorPool executorPool;
    private final int CPUs;
    private final ThreadMXBean tmb;
    private final RuntimeMXBean rmb;
    private long totalSpace = 0L;
    private long usedSpace = 0L;
    private long usableSpace = 0L;
    private long uptime = 0L;
    private int cpuLoad = 0;
    private final boolean imageCounted = false;
    private long imageCount = 0L;
    private long imageSize = 0L;
    private int groupCount = 0;
    private int connectorCount = 0;
    private long maxImageCount = 0L;
    private long expiresEndTime = 0L;
    private long prevUpTime;
    private Map<Long, Long> prevThreadCpuTime = null;
    private int serverInstances = 1;
    private long processingImages = 0L;
    private long processingSwapImages = 0L;
    private long lastScannerTime = 0L;
    private Timer monitorRing = null;

    public SystemMonitor(Licence licence, Path storageDir, ExecutorPool executorPool) {
        this.setPriority(1);
        this.setDaemon(true);
        this.setName("System Monitor");
        this.accumulators = new AtomicLong[Accumulators.values().length];
        this.pool = storageDir;
        this.executorPool = executorPool;
        this.CPUs = Runtime.getRuntime().availableProcessors();
        this.tmb = ManagementFactory.getThreadMXBean();
        this.rmb = ManagementFactory.getRuntimeMXBean();
        this.prevUpTime = this.rmb.getUptime();
        this.setLicence(licence);
        this.setupAccumulators();
        this.setupRingbufferTimer();
    }

    public void setLicence(Licence licence) {
        this.maxImageCount = licence.getMaxImages();
        this.expiresEndTime = licence.getExpireTime();
    }

    private void setupRingbufferTimer() {
        RingBuffer rb = new RingBuffer();
        this.monitorRing = new Timer("SystemMonitor Ring");
        this.monitorRing.scheduleAtFixedRate((TimerTask)rb, 0L, 1000L);
    }

    private void setupAccumulators() {
        int l;
        for (Accumulators key : Accumulators.values()) {
            this.accumulators[key.ordinal()] = new AtomicLong(0L);
        }
        for (l = 0; l < this.ttfb60Sec.length; ++l) {
            this.ttfb60Sec[l] = new AtomicLong(0L);
        }
        for (l = 0; l < this.ttfb60Hits.length; ++l) {
            this.ttfb60Hits[l] = new AtomicInteger(0);
        }
        for (l = 0; l < this.ttlb60Sec.length; ++l) {
            this.ttlb60Sec[l] = new AtomicLong(0L);
        }
        for (l = 0; l < this.ttlb60Hits.length; ++l) {
            this.ttlb60Hits[l] = new AtomicInteger(0);
        }
        for (l = 0; l < this.concurrentRequests60Sec.length; ++l) {
            this.concurrentRequests60Sec[l] = new AtomicInteger(0);
        }
        for (l = 0; l < this.concurrentProcessing60Sec.length; ++l) {
            this.concurrentProcessing60Sec[l] = new AtomicInteger(0);
        }
        for (l = 0; l < this.activeCPUThreads60Sec.length; ++l) {
            this.activeCPUThreads60Sec[l] = new AtomicInteger(0);
        }
        for (l = 0; l < this.activeIOThreads60Sec.length; ++l) {
            this.activeIOThreads60Sec[l] = new AtomicInteger(0);
        }
        for (l = 0; l < this.taskCPUThreads60Sec.length; ++l) {
            this.taskCPUThreads60Sec[l] = new AtomicLong(0L);
        }
        for (l = 0; l < this.taskIOThreads60Sec.length; ++l) {
            this.taskIOThreads60Sec[l] = new AtomicLong(0L);
        }
    }

    @Override
    public void run() {
        while (this.runDaemon) {
            try {
                Thread.sleep(1000L);
                this.uptime = this.rmb.getUptime();
                if (++this.lastSlowCheck >= 60) {
                    this.lastSlowCheck = 0;
                    this.measurePoolSpace();
                }
                this.measureCPULoad();
                this.measureExecutorPool();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void halt() {
        this.runDaemon = false;
        this.interrupt();
        if (this.monitorRing != null) {
            this.monitorRing.cancel();
            this.monitorRing.purge();
        }
    }

    public long increaseAccumulator(Accumulators accu) {
        return this.accumulators[accu.ordinal()].incrementAndGet();
    }

    public long increaseAccumulator(Accumulators accu, long amount) {
        return this.accumulators[accu.ordinal()].addAndGet(amount);
    }

    public long getAccumulator(Accumulators accu) {
        return this.accumulators[accu.ordinal()].get();
    }

    public void setTTFB(long time) {
        if (time <= 10L) {
            this.ttfb10.getAndIncrement();
        } else if (time <= 25L) {
            this.ttfb25.getAndIncrement();
        } else if (time <= 50L) {
            this.ttfb50.getAndIncrement();
        } else if (time <= 100L) {
            this.ttfb100.getAndIncrement();
        } else if (time <= 250L) {
            this.ttfb250.getAndIncrement();
        } else if (time <= 500L) {
            this.ttfb500.getAndIncrement();
        } else if (time <= 1000L) {
            this.ttfb1000.getAndIncrement();
        } else if (time <= 2500L) {
            this.ttfb2500.getAndIncrement();
        } else if (time <= 5000L) {
            this.ttfb5000.getAndIncrement();
        } else {
            this.ttfb5000plus.getAndIncrement();
        }
        this.ttfb60Sec[this.ttfb60Pos].addAndGet(time);
        this.ttfb60Hits[this.ttfb60Pos].incrementAndGet();
    }

    public int getAvgTTFB60() {
        return (int)SystemMonitor.calcBufferAVG(this.ttfb60Sec, this.ttfb60Hits);
    }

    public long getTTFB(int timeRange) {
        if (timeRange <= 10) {
            return this.ttfb10.get();
        }
        if (timeRange <= 25) {
            return this.ttfb25.get();
        }
        if (timeRange <= 50) {
            return this.ttfb50.get();
        }
        if (timeRange <= 100) {
            return this.ttfb100.get();
        }
        if (timeRange <= 250) {
            return this.ttfb250.get();
        }
        if (timeRange <= 500) {
            return this.ttfb500.get();
        }
        if (timeRange <= 1000) {
            return this.ttfb1000.get();
        }
        if (timeRange <= 2500) {
            return this.ttfb2500.get();
        }
        if (timeRange <= 5000) {
            return this.ttfb5000.get();
        }
        return this.ttfb5000plus.get();
    }

    public void setTTLB(long time) {
        if (time <= 10L) {
            this.ttlb10.getAndIncrement();
        } else if (time <= 25L) {
            this.ttlb25.getAndIncrement();
        } else if (time <= 50L) {
            this.ttlb50.getAndIncrement();
        } else if (time <= 100L) {
            this.ttlb100.getAndIncrement();
        } else if (time <= 250L) {
            this.ttlb250.getAndIncrement();
        } else if (time <= 500L) {
            this.ttlb500.getAndIncrement();
        } else if (time <= 1000L) {
            this.ttlb1000.getAndIncrement();
        } else if (time <= 2500L) {
            this.ttlb2500.getAndIncrement();
        } else if (time <= 5000L) {
            this.ttlb5000.getAndIncrement();
        } else {
            this.ttlb5000plus.getAndIncrement();
        }
        this.ttlb60Sec[this.ttlb60Pos].addAndGet(time);
        this.ttlb60Hits[this.ttlb60Pos].incrementAndGet();
    }

    public int getAvgTTLB60() {
        return (int)SystemMonitor.calcBufferAVG(this.ttlb60Sec, this.ttlb60Hits);
    }

    public long getTTLB(int timeRange) {
        if (timeRange <= 10) {
            return this.ttlb10.get();
        }
        if (timeRange <= 25) {
            return this.ttlb25.get();
        }
        if (timeRange <= 50) {
            return this.ttlb50.get();
        }
        if (timeRange <= 100) {
            return this.ttlb100.get();
        }
        if (timeRange <= 250) {
            return this.ttlb250.get();
        }
        if (timeRange <= 500) {
            return this.ttlb500.get();
        }
        if (timeRange <= 1000) {
            return this.ttlb1000.get();
        }
        if (timeRange <= 2500) {
            return this.ttlb2500.get();
        }
        if (timeRange <= 5000) {
            return this.ttlb5000.get();
        }
        return this.ttlb5000plus.get();
    }

    public void setConcurrentProcessing(int c) {
        this.concurrentProcessing.set(c);
        this.concurrentProcessing60Sec[this.concurrentProcessing60Pos].set(c);
    }

    public int getConcurrentProcessing() {
        return this.concurrentProcessing.get();
    }

    public int getConcurrentProcessingMax() {
        return SystemMonitor.calcBufferMax(this.concurrentProcessing60Sec);
    }

    public void setConcurrentRequests(int c) {
        this.concurrentRequests.set(c);
        this.concurrentRequests60Sec[this.concurrentRequests60Pos].set(c);
    }

    public int getConcurrentRequests() {
        return this.concurrentRequests.get();
    }

    public int getConcurrentRequestsMax() {
        return SystemMonitor.calcBufferMax(this.concurrentRequests60Sec);
    }

    public int getActiveCPUThreads() {
        return this.activeCPUThreads.get();
    }

    public int getActiveCPUThreadsMax() {
        return SystemMonitor.calcBufferMax(this.activeCPUThreads60Sec);
    }

    public int getActiveIOThreads() {
        return this.activeIOThreads.get();
    }

    public int getActiveIOThreadsMax() {
        return SystemMonitor.calcBufferMax(this.activeIOThreads60Sec);
    }

    public long getTaskCPUThreads() {
        return this.taskCPUThreads.get();
    }

    public long getTaskCPUThreadsMax() {
        return SystemMonitor.calcBufferMax(this.taskCPUThreads60Sec);
    }

    public long getTaskIOThreads() {
        return this.taskIOThreads.get();
    }

    public long getTaskIOThreadsMax() {
        return SystemMonitor.calcBufferMax(this.taskIOThreads60Sec);
    }

    public long getUptimeSec() {
        return this.uptime / 1000L;
    }

    public long getTotalStorageSpace() {
        return this.totalSpace;
    }

    public long getFreeStorageSpace() {
        return this.usableSpace;
    }

    public long getUsedStorageSpace() {
        return this.usedSpace;
    }

    public int getCPULoad() {
        return this.cpuLoad;
    }

    public void setScannerTime(long value) {
        this.lastScannerTime = value;
    }

    public long getScannerTime() {
        return this.lastScannerTime;
    }

    public long getAssetSize() {
        return this.imageSize;
    }

    public void setAssetSize(long value) {
        this.imageSize = value;
    }

    public long getAssetCount() {
        return this.imageCount;
    }

    public void setAssetCount(long value) {
        this.imageCount = value;
    }

    public int getGroupCount() {
        return this.groupCount;
    }

    public void setGroupCount(int value) {
        this.groupCount = value;
    }

    public int getConnectorCount() {
        return this.connectorCount;
    }

    public void setConnectorCount(int value) {
        this.connectorCount = value;
    }

    public long getProcessingImages() {
        return this.processingImages;
    }

    public void setProcessingImages(long value) {
        this.processingImages = value;
    }

    public long getProcessingSwapImages() {
        return this.processingSwapImages;
    }

    public void setProcessingSwapImages(long value) {
        this.processingSwapImages = value;
    }

    public int getServerInstances() {
        return this.serverInstances;
    }

    public void setServerInstances(int value) {
        this.serverInstances = value;
    }

    public long getMaxImages() {
        return this.maxImageCount;
    }

    public long getExpireRestTime() {
        if (this.expiresEndTime > 0L) {
            return this.expiresEndTime - System.currentTimeMillis();
        }
        return 0L;
    }

    public boolean isImageCounted() {
        return false;
    }

    private void measurePoolSpace() {
        this.totalSpace = 0L;
        this.usableSpace = 0L;
        Iterable<FileStore> iterable = this.pool.getFileSystem().getFileStores();
        for (FileStore fs : iterable) {
            try {
                this.totalSpace += fs.getTotalSpace();
                this.usableSpace += fs.getUsableSpace();
            }
            catch (IOException iOException) {}
        }
        this.usedSpace = this.totalSpace - this.usableSpace;
    }

    private void measureCPULoad() {
        if (this.tmb.isThreadCpuTimeEnabled()) {
            long elapsedTime = this.uptime - this.prevUpTime;
            long[] threadIdRaws = this.tmb.getAllThreadIds();
            HashMap<Long, Long> cpuTime = new HashMap<Long, Long>(threadIdRaws.length);
            float totalUsage = 0.0f;
            for (long threadIdRaw : threadIdRaws) {
                if (threadIdRaw == -1L) continue;
                long time = this.tmb.getThreadCpuTime(threadIdRaw);
                cpuTime.put(threadIdRaw, time);
                if (this.prevThreadCpuTime == null || !this.prevThreadCpuTime.containsKey(threadIdRaw)) continue;
                long elapsedCpu = time - this.prevThreadCpuTime.get(threadIdRaw);
                float cpuUsage = Math.min(99.0f, (float)elapsedCpu / ((float)elapsedTime * 1000000.0f * (float)this.CPUs));
                totalUsage += cpuUsage;
            }
            this.cpuLoad = FastMath.round((totalUsage *= 100.0f) > 100.0f ? 100.0f : totalUsage);
            this.prevUpTime = this.uptime;
            this.prevThreadCpuTime = cpuTime;
        }
    }

    private void measureExecutorPool() {
        int activeCPUCount = this.executorPool.getActiveCount(ExecutorPool.Type.CONVERTER_CPU);
        this.activeCPUThreads.set(activeCPUCount);
        this.activeCPUThreads60Sec[this.activeCPUThreads60Pos].set(activeCPUCount);
        int activeIOCount = this.executorPool.getActiveCount(ExecutorPool.Type.CONVERTER_IO);
        this.activeIOThreads.set(activeIOCount);
        this.activeIOThreads60Sec[this.activeIOThreads60Pos].set(activeIOCount);
        long taskCPUCount = this.executorPool.getQueueSize(ExecutorPool.Type.CONVERTER_CPU);
        this.taskCPUThreads.set(taskCPUCount);
        this.taskCPUThreads60Sec[this.taskCPUThreads60Pos].set(taskCPUCount);
        long taskIOCount = this.executorPool.getQueueSize(ExecutorPool.Type.CONVERTER_IO);
        this.taskIOThreads.set(taskIOCount);
        this.taskIOThreads60Sec[this.taskIOThreads60Pos].set(taskIOCount);
    }

    private static long calcBufferAVG(AtomicLong[] timeBuffer, AtomicInteger[] hitBuffer) {
        int countUnNull = 0;
        float sum = 0.0f;
        for (int c = 0; c < timeBuffer.length; ++c) {
            long time = timeBuffer[c].get();
            if (time == 0L) continue;
            countUnNull += hitBuffer[c].get();
            sum += (float)time;
        }
        return (long)(sum / (float)countUnNull);
    }

    private static int calcBufferMax(AtomicInteger[] timeBuffer) {
        int max = 0;
        for (int c = 0; c < timeBuffer.length; ++c) {
            int time = timeBuffer[c].get();
            if (time <= max) continue;
            max = time;
        }
        return max;
    }

    private static long calcBufferMax(AtomicLong[] timeBuffer) {
        long max = 0L;
        for (int c = 0; c < timeBuffer.length; ++c) {
            long time = timeBuffer[c].get();
            if (time <= max) continue;
            max = time;
        }
        return max;
    }

    private class RingBuffer
    extends TimerTask {
        RingBuffer() {
        }

        @Override
        public void run() {
            SystemMonitor.this.ttfb60Sec[SystemMonitor.this.ttfb60Pos].set(0L);
            SystemMonitor.this.ttfb60Hits[SystemMonitor.this.ttfb60Pos].set(0);
            if (++SystemMonitor.this.ttfb60Pos == 60) {
                SystemMonitor.this.ttfb60Pos = 0;
            }
            SystemMonitor.this.ttlb60Sec[SystemMonitor.this.ttlb60Pos].set(0L);
            SystemMonitor.this.ttlb60Hits[SystemMonitor.this.ttlb60Pos].set(0);
            if (++SystemMonitor.this.ttlb60Pos == 60) {
                SystemMonitor.this.ttlb60Pos = 0;
            }
            SystemMonitor.this.concurrentRequests60Sec[SystemMonitor.this.concurrentRequests60Pos].set(0);
            if (++SystemMonitor.this.concurrentRequests60Pos == 60) {
                SystemMonitor.this.concurrentRequests60Pos = 0;
            }
            SystemMonitor.this.concurrentProcessing60Sec[SystemMonitor.this.concurrentProcessing60Pos].set(0);
            if (++SystemMonitor.this.concurrentProcessing60Pos == 60) {
                SystemMonitor.this.concurrentProcessing60Pos = 0;
            }
            if (++SystemMonitor.this.activeCPUThreads60Pos == 60) {
                SystemMonitor.this.activeCPUThreads60Pos = 0;
            }
            if (++SystemMonitor.this.taskCPUThreads60Pos == 60) {
                SystemMonitor.this.taskCPUThreads60Pos = 0;
            }
            if (++SystemMonitor.this.activeIOThreads60Pos == 60) {
                SystemMonitor.this.activeIOThreads60Pos = 0;
            }
            if (++SystemMonitor.this.taskIOThreads60Pos == 60) {
                SystemMonitor.this.taskIOThreads60Pos = 0;
            }
        }
    }

    public static enum Accumulators {
        RP_HITS_ALL,
        RP_TRAFFIC_ALL,
        RP_HITS_STATIC,
        RP_TRAFFIC_STATIC,
        RP_HITS_MULTIRESOLUTION,
        RP_TRAFFIC_MULTIRESOLUTION,
        RP_HITS_STORAGE,
        RP_TRAFFIC_STORAGE,
        RP_HITS_IMAGE,
        RP_TRAFFIC_IMAGE,
        RP_HITS_INFO,
        RP_TRAFFIC_INFO,
        RP_HITS_LIST,
        RP_TRAFFIC_LIST,
        RP_HITS_SEARCH,
        RP_TRAFFIC_SEARCH,
        RP_HITS_CACHE,
        RP_TRAFFIC_CACHE,
        RP_HTTP_200,
        RP_HTTP_302,
        RP_HTTP_304,
        RP_HTTP_400,
        RP_HTTP_403,
        RP_HTTP_404,
        RP_HTTP_500,
        RP_HTTP_503,
        RP_METHOD_GET,
        RP_METHOD_HEAD,
        RP_METHOD_POST,
        RP_PIXEL_ALL,
        RP_PIXEL_MULTIRESOLUTION,
        RP_PIXEL_STORAGE,
        SM_IMPORTED_IMAGES,
        SM_PIXEL,
        SM_SWAP_CONVERSIONS,
        SM_IMPORTED_SUCCESS,
        SM_IMPORTED_SM_FAILED,
        SM_SCANTIME;

    }
}

