/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.migration;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiserver.authentication.Group;
import com.neptunelabs.fsiserver.authentication.Groups;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.authentication.Users;
import com.neptunelabs.fsiserver.migration.OldGroupsConfig;
import com.neptunelabs.fsiserver.migration.OldImporterProfile;
import com.neptunelabs.fsiserver.migration.OldPermissionSet;
import com.neptunelabs.fsiserver.migration.OldPermissionSets;
import com.neptunelabs.fsiserver.migration.OldUsersConfig;
import com.neptunelabs.fsiserver.migration.XMLSettings;
import com.neptunelabs.fsiserver.utils.SourceConnector;
import com.neptunelabs.fsiservletframework.settings.Section;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXB;

@WebServlet(name="Migrator", loadOnStartup=2, initParams={@WebInitParam(name="autorestart", value="true")})
public class Migrator
extends GenericServlet {
    private static final long serialVersionUID = 1611263353585839606L;
    private Path servletBaseDir = null;
    private Path defaultViewerDir = null;
    private Path backupViewerDir = null;
    private Path migrationDir = null;
    private Path migrationBackup = null;
    private Path usersDir = null;
    private Path configDirectory = null;
    final List<String> viewer5DistributionSkins = Arrays.asList("black.skn", "silver.skn", "plain.skn", "dialogs.skn");

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.initPaths(config);
        if (!Files.exists(this.migrationDir, new LinkOption[0]) || !Files.isDirectory(this.migrationDir, new LinkOption[0])) {
            return;
        }
        boolean success = this.quickCheckMigrationDirectory();
        if (success) {
            success &= this.backupDefaultViewer();
        }
        if (success) {
            System.err.println("INFO: Starting test... ");
            success &= this.migrate(true);
            System.err.println("INFO: Finished test... ");
        }
        if (success) {
            System.err.println("INFO: Starting migration... ");
            success &= this.migrate(false);
            System.err.println("INFO: Finished migration... ");
        }
        if (success) {
            System.err.println("INFO: Migration completed without errors.");
            try {
                if (Files.exists(this.migrationBackup, new LinkOption[0])) {
                    FileOperations.deleteDir(this.migrationBackup);
                }
                Files.move(this.migrationDir, this.migrationBackup, new CopyOption[0]);
                System.err.println("INFO: Moved migration files to " + this.migrationBackup.toFile().getAbsolutePath());
            }
            catch (IOException ioe) {
                System.err.println("ERROR: Could not delete backup of old migration. " + this.migrationBackup.toFile().getAbsolutePath() + ". Please remove migration directory manually");
            }
        } else {
            System.err.println("ERROR: Errors occured during migration.");
        }
    }

    private boolean updateViewer(Path oldViewerDir, Path newViewerDir) {
        boolean success = true;
        if (!Files.exists(newViewerDir, new LinkOption[0])) {
            success &= FileOperations.copyDirectory(null, this.backupViewerDir, newViewerDir);
        }
        try {
            success &= FileOperations.copy(oldViewerDir.resolve("_default.fsi"), newViewerDir.resolve("_default.xml"));
            if (!Files.exists(newViewerDir.resolve("config_backup"), new LinkOption[0])) {
                Files.move(newViewerDir.resolve("config"), newViewerDir.resolve("config_backup"), StandardCopyOption.REPLACE_EXISTING);
            }
            success &= FileOperations.copyDirectory(null, oldViewerDir.resolve("config"), newViewerDir.resolve("config"));
            success &= this.renameFSIFiles(newViewerDir.resolve("config"));
            success &= this.copyFSIViewerSkins(oldViewerDir.resolve("skins"), newViewerDir.resolve("skins"));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.err.println("ERROR: Encountered Exception updating FSI Viewer instance: " + ioe.getLocalizedMessage());
            success = false;
        }
        return success;
    }

    private boolean copyFSIViewerSkins(Path oldSkinDirectory, Path newSkinDirectory) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(oldSkinDirectory);){
            for (Path file : stream) {
                if (Files.isDirectory(file, new LinkOption[0])) {
                    String dirname = file.getFileName().toString();
                    this.copyFSIViewerSkins(file, newSkinDirectory.resolve(dirname));
                    continue;
                }
                String filename = file.getFileName().toString();
                if (this.viewer5DistributionSkins.contains(filename)) continue;
                if (filename.endsWith(".skn")) {
                    filename = filename.substring(0, filename.length() - 3) + "swf";
                }
                Path newFile = file.getParent().resolve(filename);
                Files.copy(file, newFile, new CopyOption[0]);
            }
        }
        catch (IOException | DirectoryIteratorException x) {
            System.err.println("ERROR: Error renaming fsi-files. " + x.getLocalizedMessage());
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean renameFSIFiles(Path path) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
            Iterator<Path> iterator = stream.iterator();
            while (iterator.hasNext()) {
                Path file = iterator.next();
                if (Files.isDirectory(file, new LinkOption[0])) {
                    if (this.renameFSIFiles(file)) continue;
                    boolean bl = false;
                    return bl;
                }
                String filename = file.getFileName().toString();
                if (!filename.endsWith(".fsi")) continue;
                String newFilename = filename.substring(0, filename.length() - 3) + "xml";
                Path newFile = file.getParent().resolve(newFilename);
                Files.move(file, newFile, StandardCopyOption.REPLACE_EXISTING);
            }
            return true;
        }
        catch (IOException | DirectoryIteratorException x) {
            System.err.println("ERROR: Error renaming fsi-files. " + x.getLocalizedMessage());
            return false;
        }
    }

    private void initPaths(ServletConfig config) {
        this.servletBaseDir = Paths.get(config.getServletContext().getRealPath(""), new String[0]);
        this.defaultViewerDir = this.servletBaseDir.resolve("viewer");
        this.usersDir = this.servletBaseDir.resolve("users");
        Path webinf = this.servletBaseDir.resolve("WEB-INF");
        this.migrationDir = webinf.resolve("migration");
        this.migrationBackup = webinf.resolve("migration_backup");
        this.backupViewerDir = webinf.resolve("viewer_dist");
        String configHomeStr = System.getProperty("com.neptunelabs.fsiserver.config.home");
        this.configDirectory = configHomeStr == null ? webinf.resolve("config") : Paths.get(configHomeStr, new String[0]);
    }

    private boolean backupDefaultViewer() {
        if (!Files.exists(this.backupViewerDir, new LinkOption[0])) {
            System.err.println("Backing up distribution viewer directory to " + this.backupViewerDir.toFile().getAbsolutePath());
            if (!FileOperations.copyDirectory(null, this.defaultViewerDir, this.backupViewerDir)) {
                System.err.println("Could not create backup of distribution viewer directory.");
                return false;
            }
        } else {
            System.err.println("INFO: Backup of distribution viewer directory already exists. Skipping...");
        }
        return true;
    }

    private boolean migrate(boolean dryRun) {
        boolean result = this.migrateDefaultViewer(dryRun);
        if (result) {
            result &= this.migrateUserViewers(dryRun);
        }
        if (result) {
            result &= this.migrateSourceManagerSettings(dryRun);
        }
        if (result) {
            result &= this.migrateRequestProcessorSettings(dryRun);
        }
        if (result) {
            result &= this.migrateUsers(dryRun);
        }
        if (result) {
            result &= this.migrateGroups(dryRun);
        }
        if (result) {
            result &= this.migrateSourceConnectors(dryRun);
        }
        return result;
    }

    private boolean migrateDefaultViewer(boolean dryRun) {
        boolean success;
        Path oldViewerDir = this.migrationDir.resolve("viewer");
        if (Files.exists(oldViewerDir, new LinkOption[0])) {
            if (dryRun) {
                success = Files.isWritable(this.defaultViewerDir);
                if (!success) {
                    System.err.println("ERROR: Aborting migration. Default Viewer directory is not writable: " + this.defaultViewerDir.toString());
                }
            } else {
                success = this.updateViewer(this.migrationDir.resolve("viewer"), this.defaultViewerDir);
            }
        } else {
            System.err.println("INFO: Skipping viewer migration. No viewer dir found.");
            success = true;
        }
        return success;
    }

    private boolean migrateUserViewers(boolean dryrun) {
        boolean success = true;
        if (dryrun) {
            success = Files.exists(this.usersDir, new LinkOption[0]) ? Files.isWritable(this.usersDir) : Files.isWritable(this.servletBaseDir);
            if (!success) {
                System.err.println("ERROR: Aborting migration. User Viewer directory can't be created or is not writable: " + this.usersDir.toString());
            }
        } else {
            Path oldUsersDir = this.migrationDir.resolve("users");
            if (Files.exists(oldUsersDir, new LinkOption[0])) {
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(oldUsersDir);){
                    for (Path file : stream) {
                        Path newUserDir = this.usersDir.resolve(file.getFileName().toString());
                        Files.createDirectories(newUserDir, new FileAttribute[0]);
                        success &= this.updateViewer(file.resolve("viewer"), newUserDir.resolve("viewer"));
                    }
                }
                catch (IOException ioe) {
                    System.err.println("ERROR: Error migrating user viewers: " + ioe.getLocalizedMessage());
                    success = false;
                }
            }
        }
        return success;
    }

    private boolean migrateSourceManagerSettings(boolean dryRun) {
        Path importerSettingsFile = this.migrationDir.resolve("config").resolve("importer.xml");
        if (!Files.exists(importerSettingsFile, new LinkOption[0])) {
            System.err.println("INFO: No Importer configuration found for migration... Skipping.");
            return true;
        }
        XMLSettings importerSettings = new XMLSettings();
        importerSettings.setSettingsFile(importerSettingsFile);
        if (!importerSettings.evalutateSettings()) {
            System.err.println("ERROR: Aborting migration. Error reading FSI Server 2 importer settings from " + importerSettingsFile.toString());
            return false;
        }
        System.err.println("INFO: FSI Server 2 importer settings read successfully.");
        Path sourceManagerSettingsFile = this.configDirectory.resolve("sourcemanager.xml");
        XMLSettings sourceManagerSettings = new XMLSettings();
        sourceManagerSettings.setSettingsFile(sourceManagerSettingsFile);
        if (!sourceManagerSettings.evalutateSettings()) {
            System.err.println("ERROR: Aborting migration. Error reading FSI Server 3 sourcemanager settings from " + sourceManagerSettingsFile.toString());
            return false;
        }
        System.err.println("INFO: FSI Server 3 source manager settings read successfully.");
        String storageLocation = importerSettings.getPrefsString("application", "storage");
        sourceManagerSettings.setPrefs("application", Section.SectionTypes.valueNames, "storage", storageLocation);
        String importstrategy = importerSettings.getPrefsString("application", "importstrategy");
        sourceManagerSettings.setPrefs("application", Section.SectionTypes.valueNames, "importstrategy", importstrategy);
        String maxCPU = importerSettings.getPrefsString("application", "maxcpu");
        sourceManagerSettings.setPrefs("application", Section.SectionTypes.valueNames, "maxcpu", maxCPU);
        String imageThreads = importerSettings.getPrefsString("application", "imagethreads");
        sourceManagerSettings.setPrefs("application", Section.SectionTypes.valueNames, "imagethreads", imageThreads);
        String parallelread = importerSettings.getPrefsString("application", "parallelread");
        sourceManagerSettings.setPrefs("application", Section.SectionTypes.valueNames, "parallelread", parallelread);
        String parallelwrite = importerSettings.getPrefsString("application", "parallelwrite");
        sourceManagerSettings.setPrefs("application", Section.SectionTypes.valueNames, "parallelwrite", parallelwrite);
        String parallelreadwrite = importerSettings.getPrefsString("application", "parallelreadwrite");
        sourceManagerSettings.setPrefs("application", Section.SectionTypes.valueNames, "parallelread", parallelreadwrite);
        if (importerSettings.hasSectionEnabled("search")) {
            System.err.println("WARNING: Found enabled search settings in old configuration. The search can not be automatically migrated. Please configure search manually after the migration has completed.");
        }
        System.err.println("INFO: FSI Server importer settings transferred.");
        if (!Files.isWritable(sourceManagerSettingsFile)) {
            System.err.println("ERROR: Aborting migration. Error writing FSI Server 3 sourcemanager settings to " + sourceManagerSettingsFile.toString());
            return false;
        }
        if (!dryRun && !sourceManagerSettings.saveSettingsFile()) {
            System.err.println("ERROR: Aborting migration. Error writing FSI Server 3 sourcemanager settings to " + sourceManagerSettingsFile.toString());
            return false;
        }
        System.err.println("INFO: FSI Server 3 source manager settings written successfully.");
        return true;
    }

    private boolean migrateRequestProcessorSettings(boolean dryRun) {
        Path coreSettingsFile = this.migrationDir.resolve("config").resolve("settings.xml");
        if (!Files.exists(coreSettingsFile, new LinkOption[0])) {
            System.err.println("INFO: No core configuration found for migration... Skipping.");
            return true;
        }
        XMLSettings coreSettings = new XMLSettings();
        coreSettings.setSettingsFile(coreSettingsFile);
        if (!coreSettings.evalutateSettings()) {
            System.err.println("ERROR: Aborting migration. Error reading FSI Server 2 core settings from " + coreSettingsFile.toString());
            return false;
        }
        System.err.println("INFO: FSI Server 2 core settings read successfully.");
        Path requestProcessorSettingsFile = this.configDirectory.resolve("requestprocessor.xml");
        XMLSettings requestProcessorSettings = new XMLSettings();
        requestProcessorSettings.setSettingsFile(requestProcessorSettingsFile);
        if (!requestProcessorSettings.evalutateSettings()) {
            System.err.println("ERROR: Aborting migration. Error reading FSI Server 3 requestprocessor settings from " + requestProcessorSettingsFile.toString());
            return false;
        }
        System.err.println("INFO: FSI Server 3 requestprocessor settings read successfully.");
        String storageLocation = coreSettings.getPrefsString("application", "storage");
        requestProcessorSettings.setPrefs("application", Section.SectionTypes.valueNames, "storage", storageLocation);
        System.err.println("INFO: FSI Server core settings transferred.");
        if (!Files.isWritable(requestProcessorSettingsFile)) {
            System.err.println("ERROR: Aborting migration. Error writing FSI Server 3 requestprocessor settings to " + requestProcessorSettingsFile.toString());
            return false;
        }
        if (!dryRun && !requestProcessorSettings.saveSettingsFile()) {
            System.err.println("ERROR: Aborting migration. Error writing FSI Server 3 requestprocessor settings to " + requestProcessorSettingsFile.toString());
            return false;
        }
        System.err.println("INFO: FSI Server 3 requestprocessor settings written successfully.");
        return true;
    }

    private boolean migrateUsers(boolean dryRun) {
        Path oldUsersFile = this.migrationDir.resolve("config").resolve("users.xml");
        if (!Files.exists(oldUsersFile, new LinkOption[0])) {
            System.err.println("INFO: No Users file found to migrate... Skipping");
            return true;
        }
        OldUsersConfig ouc = null;
        try {
            ouc = (OldUsersConfig)JAXB.unmarshal((File)oldUsersFile.toFile(), OldUsersConfig.class);
        }
        catch (Exception e) {
            System.err.println("ERROR: Aborting migration: Failed to read old users config from " + oldUsersFile.toString());
            return false;
        }
        Users nuc = new Users();
        nuc.users = new HashSet<Users.User>();
        for (OldUsersConfig.User ou : ouc.users) {
            Users.User newUser = new Users.User();
            newUser.name = ou.name;
            if (ou.hash != null && ou.hash.length() > 0) {
                newUser.hash = ou.hash;
            } else {
                newUser.plain = ou.plain;
            }
            if (ou.accesslevel.equalsIgnoreCase("admin")) {
                newUser.permissionSet = "administratorPermissions";
            }
            nuc.users.add(newUser);
        }
        Path usersFile = this.configDirectory.resolve("users.xml");
        try {
            if (!dryRun) {
                JAXB.marshal((Object)nuc, (File)usersFile.toFile());
            }
            System.err.println("INFO: Written users config to " + usersFile.toString());
        }
        catch (Exception e) {
            System.err.println("ERROR: Aborting migration: Failed to write users config to " + usersFile.toString());
            return false;
        }
        return true;
    }

    private boolean migrateGroups(boolean dryRun) {
        Path oldGroupsFile = this.migrationDir.resolve("config").resolve("groups.xml");
        if (!Files.exists(oldGroupsFile, new LinkOption[0])) {
            System.err.println("INFO: No Groups file found to migrate... Skipping");
            return true;
        }
        OldGroupsConfig ogc = null;
        try {
            ogc = (OldGroupsConfig)JAXB.unmarshal((File)oldGroupsFile.toFile(), OldGroupsConfig.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("ERROR: Aborting migration: Failed to read old groups config from " + oldGroupsFile.toString());
            return false;
        }
        Groups ngc = new Groups();
        ArrayList<Group> groupList = new ArrayList<Group>();
        for (OldGroupsConfig.Group og : ogc.getGroups()) {
            Group newGroup;
            if (og.name.equals("users")) {
                newGroup = new Group("authenticated");
                newGroup.setPermissionSet("default_authenticated");
            } else {
                newGroup = new Group(og.name);
            }
            newGroup.setUsers(og.users);
            groupList.add(newGroup);
        }
        ngc.setGroups(groupList);
        Path groupsFile = this.configDirectory.resolve("groups.xml");
        try {
            if (!dryRun) {
                JAXB.marshal((Object)ngc, (File)groupsFile.toFile());
            }
            System.err.println("INFO: Written groups config to " + groupsFile.toString());
        }
        catch (Exception e) {
            System.err.println("ERROR: Aborting migration: Failed to write groups config to " + groupsFile.toString());
            return false;
        }
        return true;
    }

    private boolean migrateSourceConnectors(boolean dryRun) {
        Path importerProfilesDirectory = this.migrationDir.resolve("importer_profiles");
        Path connectorDirectory = this.configDirectory.resolve("connectors");
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(importerProfilesDirectory);){
            for (Path file : stream) {
                if (!Files.isRegularFile(file, new LinkOption[0]) || !file.getFileName().toString().endsWith(".xml")) continue;
                try {
                    OldImporterProfile oldProfile = (OldImporterProfile)JAXB.unmarshal((File)file.toFile(), OldImporterProfile.class);
                    System.err.println("INFO: Read importer profile definition from : " + file.getFileName().toString());
                    SourceConnector connector = new SourceConnector();
                    connector.enabled = oldProfile.enabled;
                    connector.conversion.format = oldProfile.conversion.format;
                    if (oldProfile.conversion.quality > 0) {
                        connector.conversion.quality = oldProfile.conversion.quality;
                    }
                    connector.type = "storage";
                    connector.origin.location = oldProfile.origin.location;
                    for (OldImporterProfile.GroupEntry oge : oldProfile.access.groupEntries) {
                        SourceConnector.GroupEntry nge = new SourceConnector.GroupEntry();
                        if (oge.permissionset.equals("r")) {
                            nge.permissionset = "read_only";
                        } else if (oge.permissionset.equals("rw")) {
                            nge.permissionset = "read_write";
                        } else if (oge.permissionset.equals("public")) {
                            nge.permissionset = "public_images";
                        } else {
                            this.createNewPermissionSetFromOldPermissionSet(oge.permissionset, dryRun);
                            nge.permissionset = oge.permissionset;
                        }
                        nge.groupname = oge.groupname;
                    }
                    if (dryRun) continue;
                    Path newConnectorFile = connectorDirectory.resolve(file.getFileName());
                    JAXB.marshal((Object)connector, (File)newConnectorFile.toFile());
                    System.err.println("INFO: Written new Connector configuration to " + newConnectorFile.toString());
                }
                catch (DataBindingException dbe) {
                    System.err.println("WARNING: Could not read importer profile: " + file.getFileName().toString() + " ...skipping. " + dbe.getLocalizedMessage());
                }
            }
        }
        catch (IOException | DirectoryIteratorException e) {
            System.err.println("ERROR: Aborting migration. " + e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    private void createNewPermissionSetFromOldPermissionSet(String permissionsetname, boolean dryRun) {
        PermissionSet newPermissionSet = new PermissionSet(permissionsetname);
        OldPermissionSet oldPermissionSet = null;
        Path oldPermissionSetsFile = this.migrationDir.resolve("config").resolve("permissionsets.xml");
        OldPermissionSets oldSets = (OldPermissionSets)JAXB.unmarshal((File)oldPermissionSetsFile.toFile(), OldPermissionSets.class);
        for (OldPermissionSet entry : oldSets.getSets()) {
            if (!entry.name.equals(permissionsetname)) continue;
            oldPermissionSet = entry;
            break;
        }
        if (oldPermissionSet != null) {
            if (oldPermissionSet.dirList) {
                newPermissionSet.list.directories = true;
            }
            if (oldPermissionSet.imageList) {
                newPermissionSet.list.files = true;
            }
            if (oldPermissionSet.imageRead) {
                newPermissionSet.read.renderedImages = true;
            }
            if (oldPermissionSet.infoRead) {
                newPermissionSet.read.basicMetadata = true;
                newPermissionSet.read.extendedMetadata = true;
            }
            if (oldPermissionSet.upload && oldPermissionSet.delete) {
                newPermissionSet.write.createDirectory = true;
                newPermissionSet.write.extendedMetadata = true;
                newPermissionSet.write.moveWithinConnector = true;
                newPermissionSet.write.paste = true;
                newPermissionSet.write.upload = true;
                newPermissionSet.write.delete = true;
                newPermissionSet.write.moveToTrash = true;
                newPermissionSet.write.overwrite = true;
                newPermissionSet.write.rename = true;
            } else if (oldPermissionSet.upload) {
                newPermissionSet.write.createDirectory = true;
                newPermissionSet.write.upload = true;
                newPermissionSet.list.connector = true;
            }
            if (!dryRun) {
                Path newPermissionSetFile = this.configDirectory.resolve("permissionsets").resolve(permissionsetname + ".xml");
                JAXB.marshal((Object)newPermissionSet, (File)newPermissionSetFile.toFile());
            }
        } else {
            System.err.println("WARNING: Failed to migrate permission set " + permissionsetname);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean quickCheckMigrationDirectory() {
        List<String> allowedSubdirectories = Arrays.asList("config", "viewer", "users", "importer_profiles", "server_profiles");
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.migrationDir);){
            for (Path file : stream) {
                if (allowedSubdirectories.contains(file.toFile().getName())) continue;
                System.err.println("ERROR: Aborting migration. Migration directory contains unknown files: " + file.toFile().getName());
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException | DirectoryIteratorException x) {
            System.err.println("ERROR: Aborting migration. " + x.getLocalizedMessage());
            return false;
        }
        if (Files.isWritable(this.migrationDir.getParent())) return this.checkMigrationDirPermissions(this.migrationDir);
        System.err.println("ERROR: Aborting migration. " + this.migrationDir.getParent().toFile().getAbsolutePath() + " is not writable.");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkMigrationDirPermissions(Path path) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
            Path entry;
            Iterator<Path> iterator = stream.iterator();
            do {
                if (!iterator.hasNext()) return true;
                entry = iterator.next();
                if (!Files.isReadable(entry)) {
                    System.err.println("ERROR: Aborting migration. " + entry.toFile().getAbsolutePath() + " not readable.");
                    boolean bl = false;
                    return bl;
                }
                if (Files.isWritable(entry)) continue;
                System.err.println("ERROR: Aborting migration. " + entry.toFile().getAbsolutePath() + " not writeable.");
                boolean bl = false;
                return bl;
            } while (!Files.isDirectory(entry, new LinkOption[0]) || this.checkMigrationDirPermissions(entry));
            boolean bl = false;
            return bl;
        }
        catch (IOException | DirectoryIteratorException x) {
            System.err.println("ERROR: Aborting migration. " + x.getLocalizedMessage());
        }
        return true;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
    }
}

